/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorsType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.config.ServiceProviderType;
import org.picketlink.identity.federation.core.config.ServiceProvidersType;
import org.picketlink.identity.federation.core.config.TokenProviderType;
import org.picketlink.identity.federation.core.config.TokenProvidersType;
import org.picketlink.identity.federation.core.interfaces.SecurityTokenProvider;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.sts.STSCoreConfig;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.wstrust.ClaimsProcessor;
import org.picketlink.identity.federation.core.wstrust.STSConfiguration;
import org.picketlink.identity.federation.core.wstrust.SecurityActions;
import org.picketlink.identity.federation.core.wstrust.StandardRequestHandler;
import org.picketlink.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.picketlink.identity.federation.core.wstrust.WSTrustServiceFactory;

public class PicketLinkSTSConfiguration
implements STSConfiguration {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final STSType delegate;
    private final Map<String, SecurityTokenProvider> tokenProviders;
    private final Map<String, ServiceProviderType> spMetadata;
    private final Map<String, ClaimsProcessor> claimsProcessors;
    private TrustKeyManager trustManager;
    private WSTrustRequestHandler handler;
    private String certificateAlias;

    public PicketLinkSTSConfiguration() {
        this.tokenProviders = new HashMap<String, SecurityTokenProvider>();
        this.spMetadata = new HashMap<String, ServiceProviderType>();
        this.claimsProcessors = new HashMap<String, ClaimsProcessor>();
        this.delegate = new STSType();
        this.delegate.setRequestHandler(StandardRequestHandler.class.getCanonicalName());
    }

    public PicketLinkSTSConfiguration(STSType config) {
        block18: {
            KeyProviderType keyProviderType;
            ServiceProvidersType serviceProviders;
            ClaimsProcessorsType processors;
            TokenProvidersType providers;
            this.tokenProviders = new HashMap<String, SecurityTokenProvider>();
            this.spMetadata = new HashMap<String, ServiceProviderType>();
            this.claimsProcessors = new HashMap<String, ClaimsProcessor>();
            this.delegate = config;
            if (this.delegate.getRequestHandler() == null) {
                this.delegate.setRequestHandler(StandardRequestHandler.class.getCanonicalName());
            }
            if ((providers = this.delegate.getTokenProviders()) != null) {
                for (TokenProviderType provider : providers.getTokenProvider()) {
                    List<KeyValueType> providerPropertiesList;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    try {
                        providerPropertiesList = CoreConfigUtil.getProperties(provider);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    properties.put("ASSERTIONS_VALIDITY", String.valueOf(config.getTokenTimeout()));
                    properties.put("CLOCK_SKEW", String.valueOf(config.getClockSkew()));
                    for (KeyValueType propertyType : providerPropertiesList) {
                        properties.put(propertyType.getKey(), propertyType.getValue());
                    }
                    SecurityTokenProvider tokenProvider = WSTrustServiceFactory.getInstance().createTokenProvider(provider.getProviderClass(), properties);
                    this.tokenProviders.put(provider.getTokenType(), tokenProvider);
                    String tokenElementAndNS = tokenProvider.family() + "$" + provider.getTokenElement() + "$" + provider.getTokenElementNS();
                    this.tokenProviders.put(tokenElementAndNS, tokenProvider);
                }
            }
            if ((processors = this.delegate.getClaimsProcessors()) != null) {
                for (ClaimsProcessorType processor : processors.getClaimsProcessor()) {
                    List<KeyValueType> processorPropertiesList;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    try {
                        processorPropertiesList = CoreConfigUtil.getProperties(processor);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    for (KeyValueType propertyType : processorPropertiesList) {
                        properties.put(propertyType.getKey(), propertyType.getValue());
                    }
                    ClaimsProcessor claimsProcessor = WSTrustServiceFactory.getInstance().createClaimsProcessor(processor.getProcessorClass(), properties);
                    this.claimsProcessors.put(processor.getDialect(), claimsProcessor);
                }
            }
            if ((serviceProviders = this.delegate.getServiceProviders()) != null) {
                for (ServiceProviderType provider : serviceProviders.getServiceProvider()) {
                    this.spMetadata.put(provider.getEndpoint(), provider);
                }
            }
            if ((keyProviderType = config.getKeyProvider()) != null) {
                String keyManagerClassName = keyProviderType.getClassName();
                try {
                    List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProviderType);
                    Class<?> clazz = SecurityActions.loadClass(this.getClass(), keyManagerClassName);
                    if (clazz == null) {
                        throw logger.classNotLoadedError(keyManagerClassName);
                    }
                    this.trustManager = (TrustKeyManager)clazz.newInstance();
                    this.trustManager.setAuthProperties(authProperties);
                    this.trustManager.setValidatingAlias(keyProviderType.getValidatingAlias());
                    if (authProperties == null) break block18;
                    for (AuthPropertyType authPropertyType : authProperties) {
                        String key = authPropertyType.getKey();
                        if (!"X509CERTIFICATE".equals(key)) continue;
                        this.trustManager.addAdditionalOption("X509CERTIFICATE", authPropertyType.getValue());
                        break;
                    }
                }
                catch (Exception e) {
                    throw logger.stsUnableToConstructKeyManagerError(e);
                }
            }
        }
    }

    @Override
    public String getSTSName() {
        return this.delegate.getSTSName();
    }

    @Override
    public boolean encryptIssuedToken() {
        return this.delegate.isEncryptToken();
    }

    @Override
    public boolean signIssuedToken() {
        return this.delegate.isSignToken();
    }

    @Override
    public long getIssuedTokenTimeout() {
        return this.delegate.getTokenTimeout() * 1000;
    }

    @Override
    public WSTrustRequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = WSTrustServiceFactory.getInstance().createRequestHandler(this.delegate.getRequestHandler(), this);
        }
        return this.handler;
    }

    @Override
    public SecurityTokenProvider getProviderForService(String serviceName) {
        if (serviceName == null) {
            throw logger.nullArgumentError("serviceName");
        }
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return this.tokenProviders.get(provider.getTokenType());
        }
        return null;
    }

    @Override
    public SecurityTokenProvider getProviderForTokenType(String tokenType) {
        if (tokenType == null) {
            throw logger.nullArgumentError("tokenType");
        }
        return this.tokenProviders.get(tokenType);
    }

    @Override
    public SecurityTokenProvider getProviderForTokenElementNS(String family, QName tokenQName) {
        return this.tokenProviders.get(family + "$" + tokenQName.getLocalPart() + "$" + tokenQName.getNamespaceURI());
    }

    @Override
    public ClaimsProcessor getClaimsProcessor(String claimsDialect) {
        return this.claimsProcessors.get(claimsDialect);
    }

    @Override
    public String getTokenTypeForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return provider.getTokenType();
        }
        return null;
    }

    @Override
    public PublicKey getServiceProviderPublicKey(String serviceName) {
        PublicKey key = null;
        if (this.trustManager != null) {
            try {
                ServiceProviderType provider = this.spMetadata.get(serviceName);
                if (provider != null && provider.getTruststoreAlias() != null) {
                    key = this.trustManager.getPublicKey(provider.getTruststoreAlias());
                }
                if (key == null) {
                    key = this.trustManager.getValidatingKey(serviceName);
                }
            }
            catch (Exception e) {
                throw logger.stsPublicKeyError(serviceName, e);
            }
        }
        return key;
    }

    @Override
    public X509Certificate getServiceProviderCertificate(String serviceName) {
        X509Certificate x509 = null;
        if (this.trustManager != null) {
            try {
                Certificate cer;
                ServiceProviderType provider = this.spMetadata.get(serviceName);
                if (provider != null && provider.getTruststoreAlias() != null && (cer = this.trustManager.getCertificate(provider.getTruststoreAlias())) instanceof X509Certificate) {
                    x509 = (X509Certificate)cer;
                }
                if (x509 == null && (cer = this.trustManager.getCertificate(serviceName)) instanceof X509Certificate) {
                    x509 = (X509Certificate)cer;
                }
            }
            catch (Exception e) {
                throw logger.stsPublicKeyError(serviceName, e);
            }
        }
        return x509;
    }

    @Override
    public KeyPair getSTSKeyPair() {
        KeyPair keyPair = null;
        if (this.trustManager != null) {
            try {
                keyPair = this.trustManager.getSigningKeyPair();
            }
            catch (Exception e) {
                throw logger.stsSigningKeyPairError(e);
            }
        }
        return keyPair;
    }

    @Override
    public Certificate getCertificate(String alias) {
        Certificate certificate = null;
        if (this.trustManager != null) {
            try {
                certificate = this.trustManager.getCertificate(alias);
            }
            catch (Exception e) {
                throw logger.stsPublicKeyCertError(e);
            }
        }
        return certificate;
    }

    @Override
    public String getXMLDSigCanonicalizationMethod() {
        return this.delegate.getCanonicalizationMethod();
    }

    @Override
    public void addTokenProvider(String key, SecurityTokenProvider provider) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.tokenProviders.put(key, provider);
        QName tokenQName = provider.getSupportedQName();
        if (tokenQName != null) {
            String tokenElementAndNS = provider.family() + "$" + tokenQName.getLocalPart() + "$" + tokenQName.getNamespaceURI();
            this.tokenProviders.put(tokenElementAndNS, provider);
        }
    }

    @Override
    public void removeTokenProvider(String key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PicketLinkCoreSTS.rte);
        }
        this.tokenProviders.remove(key);
    }

    @Override
    public List<SecurityTokenProvider> getTokenProviders() {
        ArrayList<SecurityTokenProvider> list = new ArrayList<SecurityTokenProvider>();
        list.addAll(this.tokenProviders.values());
        return Collections.unmodifiableList(list);
    }

    @Override
    public List<SecurityTokenProvider> getProvidersByFamily(String familyName) {
        ArrayList<SecurityTokenProvider> result = new ArrayList<SecurityTokenProvider>();
        for (SecurityTokenProvider provider : this.tokenProviders.values()) {
            if (!provider.family().equals(familyName)) continue;
            result.add(provider);
        }
        return result;
    }

    @Override
    public String getSigningCertificateAlias() {
        if (this.certificateAlias == null) {
            this.certificateAlias = (String)this.trustManager.getAdditionalOption("X509CERTIFICATE");
        }
        return this.certificateAlias;
    }

    public void setSigningCertificateAlias(String alias) {
        this.certificateAlias = alias;
    }

    @Override
    public void copy(STSCoreConfig thatConfig) {
        if (!(thatConfig instanceof PicketLinkSTSConfiguration)) {
            throw new RuntimeException("Unknown config :" + thatConfig);
        }
        PicketLinkSTSConfiguration pc = (PicketLinkSTSConfiguration)thatConfig;
        this.tokenProviders.putAll(pc.tokenProviders);
        this.claimsProcessors.putAll(pc.claimsProcessors);
    }

    public String toString() {
        return "PicketLinkSTSConfiguration [delegate=" + this.delegate + ", tokenProviders=" + this.tokenProviders + ", spMetadata=" + this.spMetadata + ", claimsProcessors=" + this.claimsProcessors + ", trustManager=" + this.trustManager + ", handler=" + this.handler + "]";
    }
}

