/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.util.ArrayList;
import java.util.Hashtable;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSConfigData;

public class STSClientPool {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static STSClientPool instance = null;
    private int maxPoolSize = 100;
    private int initialClients = 0;
    private Hashtable<String, ArrayList<STSClient>> free = new Hashtable();
    private Hashtable<String, ArrayList<STSClient>> inUse = new Hashtable();
    private Hashtable<String, STSConfigData> configs = new Hashtable();

    protected STSClientPool(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public static STSClientPool instance(int maxPoolSize) {
        if (instance == null) {
            return new STSClientPool(maxPoolSize);
        }
        return instance;
    }

    public void initialize(int numberOfSTSClients, STSClientConfig stsClientConfig) {
        this.internalInitialize(numberOfSTSClients, stsClientConfig, null);
    }

    public void initialize(STSClientConfig stsClientConfig) {
        this.internalInitialize(this.initialClients, stsClientConfig, null);
    }

    public void initialize(int numberOfSTSClients, STSClientCreationCallBack clientCreationCallBack) {
        this.internalInitialize(numberOfSTSClients, null, clientCreationCallBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalInitialize(int numberOfSTSClients, STSClientConfig stsClientConfig, STSClientCreationCallBack clientCreationCallBack) {
        if (this.initialClients < 1) {
            this.initialClients = numberOfSTSClients;
        }
        String key = null;
        key = clientCreationCallBack != null ? clientCreationCallBack.getKey() : this.key(stsClientConfig);
        if (!this.free.containsKey(key)) {
            int i;
            ArrayList<STSClient> clients = new ArrayList<STSClient>(numberOfSTSClients);
            if (clientCreationCallBack != null) {
                for (i = 0; i < numberOfSTSClients; ++i) {
                    clients.add(clientCreationCallBack.createClient());
                }
            } else {
                for (i = 0; i < numberOfSTSClients; ++i) {
                    clients.add(new STSClient(stsClientConfig));
                }
            }
            Hashtable<String, ArrayList<STSClient>> hashtable = this.free;
            synchronized (hashtable) {
                STSConfigData configData = new STSConfigData();
                if (clientCreationCallBack != null) {
                    configData.config = null;
                    configData.callBack = clientCreationCallBack;
                } else {
                    configData.config = stsClientConfig;
                    configData.callBack = null;
                }
                this.configs.put(key, configData);
                this.free.put(key, clients);
                this.inUse.put(key, new ArrayList(numberOfSTSClients));
            }
        }
        throw logger.freePoolAlreadyContainsGivenKey(key);
    }

    public STSClient takeOut(String serviceName, String portName, String endPointAddress) {
        String key = this.key(serviceName, portName, endPointAddress);
        STSClient client = this.takeOutInternal(key);
        if (client == null) {
            this.initialize(this.initialClients, this.configs.get((Object)key).config);
            client = this.takeOutInternal(key);
        }
        return client;
    }

    public STSClient takeOut(STSClientConfig stsClientConfig) {
        String key = this.key(stsClientConfig);
        STSClient client = this.takeOutInternal(key);
        if (client == null) {
            this.initialize(this.initialClients, stsClientConfig);
            client = this.takeOutInternal(key);
        }
        return client;
    }

    public STSClient takeOut(String key) {
        STSClient client = this.takeOutInternal(key);
        if (client == null) {
            if (this.configs.get((Object)key).callBack != null) {
                this.internalInitialize(this.initialClients, null, this.configs.get((Object)key).callBack);
            }
            client = this.takeOutInternal(key);
        }
        return client;
    }

    public void putIn(String serviceName, String portName, String endPointAddress, STSClient client) {
        String key = this.key(serviceName, portName, endPointAddress);
        this.putInInternal(key, client);
    }

    public void putIn(STSClientConfig stsClientConfig, STSClient client) {
        String key = this.key(stsClientConfig);
        this.putInInternal(key, client);
    }

    public void putIn(String key, STSClient client) {
        this.putInInternal(key, client);
    }

    private synchronized STSClient takeOutInternal(String key) {
        ArrayList<STSClient> clients = this.free.get(key);
        if (clients != null) {
            STSClient client;
            int size = clients.size();
            if (size > 0) {
                client = clients.remove(size - 1);
            } else {
                int allocateClients = this.numClientsToAllocate(key);
                if (allocateClients <= 0) {
                    throw logger.maximumNumberOfClientsReachedforPool(String.valueOf(this.maxPoolSize));
                }
                this.addClients(key);
                client = clients.remove(clients.size() - 1);
            }
            this.markInUse(key, client);
            return client;
        }
        return null;
    }

    private int numClientsToAllocate(String key) {
        int c;
        int allClients = 0;
        ArrayList<STSClient> clients = this.inUse.get(key);
        if (clients != null) {
            allClients += clients.size();
        }
        if ((clients = this.free.get(key)) != null) {
            allClients += clients.size();
        }
        if ((c = this.maxPoolSize - allClients) > this.initialClients) {
            return this.initialClients;
        }
        if (c <= 0) {
            return 0;
        }
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addClients(String key) {
        STSConfigData configData = this.configs.get(key);
        if (configData == null) throw logger.cannotGetSTSConfigByKey(key);
        ArrayList<STSClient> freeClientPool = this.free.get(key);
        if (freeClientPool == null) throw logger.cannotGetFreeClientPoolKey(key);
        ArrayList<STSClient> clients = new ArrayList<STSClient>(this.initialClients);
        if (configData.config != null) {
            for (int i = 0; i < this.initialClients; ++i) {
                clients.add(new STSClient(configData.config));
            }
        } else {
            for (int i = 0; i < this.initialClients; ++i) {
                clients.add(configData.callBack.createClient());
            }
        }
        freeClientPool.addAll(clients);
    }

    private void markInUse(String key, STSClient client) {
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (usedClients != null) {
            usedClients.add(client);
        } else {
            logger.cannotGetUsedClientsByKey(key);
        }
    }

    private synchronized void putInInternal(String key, STSClient client) {
        ArrayList<STSClient> freeClients = this.free.get(key);
        ArrayList<STSClient> usedClients = this.inUse.get(key);
        if (!usedClients.remove(client)) {
            throw logger.removingNonExistingClientFromUsedClientsByKey(key);
        }
        freeClients.add(client);
    }

    private String key(STSClientConfig stsClientConfig) {
        return this.key(stsClientConfig.getServiceName(), stsClientConfig.getPortName(), stsClientConfig.getEndPointAddress());
    }

    private String key(String serviceName, String portName, String endPointAddress) {
        return serviceName + "|" + portName + "|" + endPointAddress;
    }

    public boolean isPoolingDisabled() {
        return this.maxPoolSize == 0;
    }
}

