/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponse;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenResponseCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSPolicyWriter;
import org.picketlink.identity.federation.core.wstrust.writers.WSSecurityWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.ComputedKeyType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.RenewingType;
import org.picketlink.identity.federation.ws.trust.RequestedProofTokenType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.trust.StatusType;
import org.w3c.dom.Element;

public class WSTrustResponseWriter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private final XMLStreamWriter writer;

    public WSTrustResponseWriter(OutputStream stream) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter(stream);
    }

    public WSTrustResponseWriter(Result result) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter(result);
    }

    public WSTrustResponseWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(RequestSecurityTokenResponseCollection collection) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "RequestSecurityTokenResponseCollection", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace(this.writer, "wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<RequestSecurityTokenResponse> responses = collection.getRequestSecurityTokenResponses();
        if (responses == null) {
            throw new ProcessingException("PL00092: Null Value:WS-Trust response message doesn't contain any response");
        }
        for (RequestSecurityTokenResponse response : responses) {
            this.write(response);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void write(RequestSecurityTokenResponse response) throws ProcessingException {
        BinarySecretType binarySecret;
        RequestedReferenceType ref;
        StaxUtil.writeStartElement(this.writer, "wst", "RequestSecurityTokenResponse", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String context = response.getContext();
        StaxUtil.writeAttribute(this.writer, "Context", context);
        if (response.getTokenType() != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "TokenType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, response.getTokenType().toASCIIString());
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getLifetime() != null) {
            Lifetime lifetime = response.getLifetime();
            StaxUtil.writeStartElement(this.writer, "wst", "Lifetime", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeLifetime(lifetime.getCreated(), lifetime.getExpires());
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getAppliesTo() != null) {
            WSPolicyWriter policyWriter = new WSPolicyWriter(this.writer);
            policyWriter.write(response.getAppliesTo());
        }
        if (response.getKeySize() != 0L) {
            StaxUtil.writeStartElement(this.writer, "wst", "KeySize", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, Long.toString(response.getKeySize()));
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getKeyType() != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "KeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, response.getKeyType().toString());
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRequestedSecurityToken() != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "RequestedSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> theList = response.getRequestedSecurityToken().getAny();
            for (Object securityToken : theList) {
                if (securityToken instanceof AssertionType) {
                    AssertionType assertion = (AssertionType)securityToken;
                    SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                    samlAssertionWriter.write(assertion);
                    continue;
                }
                if (securityToken instanceof Element) {
                    StaxUtil.writeDOMElement(this.writer, (Element)securityToken);
                    continue;
                }
                throw logger.writerUnknownTypeError(securityToken.getClass().getName());
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRequestedAttachedReference() != null) {
            ref = response.getRequestedAttachedReference();
            StaxUtil.writeStartElement(this.writer, "wst", "RequestedAttachedReference", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeSecurityTokenReference(ref.getSecurityTokenReference());
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRequestedUnattachedReference() != null) {
            ref = response.getRequestedUnattachedReference();
            StaxUtil.writeStartElement(this.writer, "wst", "RequestedUnattachedReference", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeSecurityTokenReference(ref.getSecurityTokenReference());
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRequestedProofToken() != null) {
            RequestedProofTokenType requestedProof = response.getRequestedProofToken();
            StaxUtil.writeStartElement(this.writer, "wst", "RequestedProofToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> theList = requestedProof.getAny();
            for (Object content : theList) {
                if (content instanceof BinarySecretType) {
                    binarySecret = (BinarySecretType)content;
                    StaxUtil.writeStartElement(this.writer, "wst", "BinarySecret", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    StaxUtil.writeAttribute(this.writer, "Type", binarySecret.getType());
                    StaxUtil.writeCharacters(this.writer, new String(binarySecret.getValue()));
                    StaxUtil.writeEndElement(this.writer);
                    continue;
                }
                if (content instanceof ComputedKeyType) {
                    ComputedKeyType computedKey = (ComputedKeyType)content;
                    StaxUtil.writeStartElement(this.writer, "wst", "ComputedKey", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    StaxUtil.writeCharacters(this.writer, computedKey.getAlgorithm());
                    StaxUtil.writeEndElement(this.writer);
                    continue;
                }
                throw new ProcessingException("PL00069: Parser: Type not supported:" + content);
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getEntropy() != null) {
            EntropyType entropy = response.getEntropy();
            StaxUtil.writeStartElement(this.writer, "wst", "Entropy", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            List<Object> entropyList = entropy.getAny();
            if (entropyList != null && entropyList.size() != 0) {
                for (Object entropyObj : entropyList) {
                    if (!(entropyObj instanceof BinarySecretType)) continue;
                    binarySecret = (BinarySecretType)entropyObj;
                    StaxUtil.writeStartElement(this.writer, "wst", "BinarySecret", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                    if (binarySecret.getType() != null) {
                        StaxUtil.writeAttribute(this.writer, "Type", binarySecret.getType());
                    }
                    StaxUtil.writeCharacters(this.writer, new String(binarySecret.getValue()));
                    StaxUtil.writeEndElement(this.writer);
                }
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getStatus() != null) {
            StatusType status = response.getStatus();
            StaxUtil.writeStartElement(this.writer, "wst", "Status", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            if (status.getCode() == null || status.getCode() == "") {
                throw logger.wsTrustValidationStatusCodeMissing();
            }
            StaxUtil.writeStartElement(this.writer, "wst", "Code", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, response.getStatus().getCode());
            StaxUtil.writeEndElement(this.writer);
            if (status.getReason() != null) {
                StaxUtil.writeStartElement(this.writer, "wst", "Reason", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
                StaxUtil.writeCharacters(this.writer, response.getStatus().getReason());
                StaxUtil.writeEndElement(this.writer);
            }
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRequestedTokenCancelled() != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "RequestedTokenCancelled", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeEndElement(this.writer);
        }
        if (response.getRenewing() != null) {
            RenewingType renewingType = response.getRenewing();
            StaxUtil.writeStartElement(this.writer, "wst", "Renewing", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeAttribute(this.writer, "Allow", "" + renewingType.isAllow());
            StaxUtil.writeAttribute(this.writer, "OK", "" + renewingType.isOK());
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

