/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.sts;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.config.AuthPropertyType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorType;
import org.picketlink.identity.federation.core.config.ClaimsProcessorsType;
import org.picketlink.identity.federation.core.config.KeyProviderType;
import org.picketlink.identity.federation.core.config.KeyValueType;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.config.ServiceProviderType;
import org.picketlink.identity.federation.core.config.ServiceProvidersType;
import org.picketlink.identity.federation.core.config.TokenProviderType;
import org.picketlink.identity.federation.core.config.TokenProvidersType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.AbstractParser;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;

public class STSConfigParser
extends AbstractParser {
    private static final String CONFIG_NS = "urn:picketlink:identity-federation:config:1.0";
    public static final String ROOT_ELEMENT = "PicketLinkSTS";
    private static final String KEY_PROVIDER_ELEMENT = "KeyProvider";
    private static final String AUTH_ELEMENT = "Auth";
    private static final String SIGNING_ALIAS_ELEMENT = "SigningAlias";
    private static final String VALIDATING_ALIAS_ELEMENT = "ValidatingAlias";
    private static final String REQUEST_HANDLER_ELEMENT = "RequestHandler";
    private static final String PROPERTY_ELEMENT = "Property";
    private static final String CLAIMS_PROCESSORS_ELEMENT = "ClaimsProcessors";
    private static final String CLAIMS_PROCESSOR_ELEMENT = "ClaimsProcessor";
    private static final String TOKEN_PROVIDERS_ELEMENT = "TokenProviders";
    private static final String TOKEN_PROVIDER_ELEMENT = "TokenProvider";
    private static final String SERVICE_PROVIDERS_ELEMENT = "ServiceProviders";
    private static final String SERVICE_PROVIDER_ELEMENT = "ServiceProvider";
    private static final String STS_NAME_ATTRIB = "STSName";
    private static final String TOKEN_TIMEOUT_ATTRIB = "TokenTimeout";
    private static final String CLOCK_SKEW_ATTRIB = "ClockSkew";
    private static final String SIGN_TOKEN_ATTRIB = "SignToken";
    private static final String ENCRYPT_TOKEN_ATTRIB = "EncryptToken";
    private static final String CANON_METHOD_ATTRIB = "CanonicalizationMethod";
    private static final String CLASS_NAME_ATTRIB = "ClassName";
    private static final String KEY_ATTRIB = "Key";
    private static final String VALUE_ATTRIB = "Value";
    private static final String DIALECT_ATTRIB = "Dialect";
    private static final String PROCESSOR_CLASS_ATTRIB = "ProcessorClass";
    private static final String PROVIDER_CLASS_ATTRIB = "ProviderClass";
    private static final String TOKEN_TYPE_ATTRIB = "TokenType";
    private static final String TOKEN_ELEMENT_ATTRIB = "TokenElement";
    private static final String TOKEN_ELEMENT_NS_ATTRIB = "TokenElementNS";
    private static final String ENDPOINT_ATTRIB = "Endpoint";
    private static final String TRUSTSTORE_ALIAS_ATTRIB = "TruststoreAlias";

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, ROOT_ELEMENT);
        STSType configType = new STSType();
        QName attributeQName = new QName("", STS_NAME_ATTRIB);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute != null) {
            configType.setSTSName(StaxParserUtil.getAttributeValue(attribute));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", TOKEN_TIMEOUT_ATTRIB))) != null) {
            configType.setTokenTimeout(Integer.valueOf(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", CLOCK_SKEW_ATTRIB))) != null) {
            configType.setClockSkew(Integer.valueOf(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", SIGN_TOKEN_ATTRIB))) != null) {
            configType.setSignToken(Boolean.valueOf(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", ENCRYPT_TOKEN_ATTRIB))) != null) {
            configType.setEncryptToken(Boolean.valueOf(StaxParserUtil.getAttributeValue(attribute)));
        }
        if ((attribute = startElement.getAttributeByName(attributeQName = new QName("", CANON_METHOD_ATTRIB))) != null) {
            configType.setCanonicalizationMethod(StaxParserUtil.getAttributeValue(attribute));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(ROOT_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (subEvent == null) break;
            String elementName = StaxParserUtil.getStartElementName(subEvent);
            if (KEY_PROVIDER_ELEMENT.equalsIgnoreCase(elementName)) {
                configType.setKeyProvider(this.parseKeyProvider(xmlEventReader));
                continue;
            }
            if (REQUEST_HANDLER_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                    throw new ParsingException("PL00071: Parser: Expected text value:RequestHandler");
                }
                configType.setRequestHandler(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (CLAIMS_PROCESSORS_ELEMENT.equalsIgnoreCase(elementName)) {
                configType.setClaimsProcessors(this.parseClaimsProcessors(xmlEventReader));
                continue;
            }
            if (TOKEN_PROVIDERS_ELEMENT.equalsIgnoreCase(elementName)) {
                configType.setTokenProviders(this.parseTokenProviders(xmlEventReader));
                continue;
            }
            if (SERVICE_PROVIDERS_ELEMENT.equalsIgnoreCase(elementName)) {
                configType.setServiceProviders(this.parseServiceProviders(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(elementName, subEvent.getLocation());
        }
        return configType;
    }

    public boolean supports(QName qname) {
        return CONFIG_NS.equals(qname.getNamespaceURI());
    }

    private KeyProviderType parseKeyProvider(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, KEY_PROVIDER_ELEMENT);
        KeyProviderType keyProvider = new KeyProviderType();
        QName attributeQName = new QName("", CLASS_NAME_ATTRIB);
        Attribute attribute = startElement.getAttributeByName(attributeQName);
        if (attribute == null) {
            throw logger.parserRequiredAttribute(CLASS_NAME_ATTRIB);
        }
        keyProvider.setClassName(StaxParserUtil.getAttributeValue(attribute));
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            EndElement endElement;
            if (xmlEvent instanceof EndElement) {
                EndElement endElement2 = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement2);
                if (endElementName.equals(KEY_PROVIDER_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (subEvent == null) break;
            String elementName = StaxParserUtil.getStartElementName(subEvent);
            if (SIGNING_ALIAS_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                if (!StaxParserUtil.hasTextAhead(xmlEventReader)) {
                    throw logger.parserExpectedTextValue(SIGNING_ALIAS_ELEMENT);
                }
                keyProvider.setSigningAlias(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if (VALIDATING_ALIAS_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                KeyValueType keyValue = new KeyValueType();
                attributeQName = new QName("", KEY_ATTRIB);
                attribute = subEvent.getAttributeByName(attributeQName);
                if (attribute != null) {
                    keyValue.setKey(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", VALUE_ATTRIB))) != null) {
                    keyValue.setValue(StaxParserUtil.getAttributeValue(attribute));
                }
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, VALIDATING_ALIAS_ELEMENT);
                keyProvider.add(keyValue);
                continue;
            }
            if (AUTH_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                AuthPropertyType authProperty = new AuthPropertyType();
                attributeQName = new QName("", KEY_ATTRIB);
                attribute = subEvent.getAttributeByName(attributeQName);
                if (attribute != null) {
                    authProperty.setKey(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", VALUE_ATTRIB))) != null) {
                    authProperty.setValue(StaxParserUtil.getAttributeValue(attribute));
                }
                endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, AUTH_ELEMENT);
                keyProvider.add(authProperty);
                continue;
            }
            throw logger.parserUnknownTag(elementName, subEvent.getLocation());
        }
        return keyProvider;
    }

    private ClaimsProcessorsType parseClaimsProcessors(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, CLAIMS_PROCESSORS_ELEMENT);
        ClaimsProcessorsType claimsProcessors = new ClaimsProcessorsType();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(CLAIMS_PROCESSORS_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (subEvent == null) break;
            String elementName = StaxParserUtil.getStartElementName(subEvent);
            if (CLAIMS_PROCESSOR_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(subEvent, CLAIMS_PROCESSOR_ELEMENT);
                ClaimsProcessorType claimsProcessor = new ClaimsProcessorType();
                QName attributeQName = new QName("", PROCESSOR_CLASS_ATTRIB);
                Attribute attribute = subEvent.getAttributeByName(attributeQName);
                if (attribute != null) {
                    claimsProcessor.setProcessorClass(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", DIALECT_ATTRIB))) != null) {
                    claimsProcessor.setDialect(StaxParserUtil.getAttributeValue(attribute));
                }
                while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
                    if (xmlEvent instanceof EndElement) {
                        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                        String endElementName = StaxParserUtil.getEndElementName(endElement);
                        if (endElementName.equals(CLAIMS_PROCESSOR_ELEMENT)) break;
                        throw logger.parserUnknownEndElement(endElementName);
                    }
                    subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    if (subEvent == null) break;
                    elementName = StaxParserUtil.getStartElementName(subEvent);
                    if (PROPERTY_ELEMENT.equalsIgnoreCase(elementName)) {
                        subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                        KeyValueType keyValue = new KeyValueType();
                        attributeQName = new QName("", KEY_ATTRIB);
                        attribute = subEvent.getAttributeByName(attributeQName);
                        if (attribute != null) {
                            keyValue.setKey(StaxParserUtil.getAttributeValue(attribute));
                        }
                        if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", VALUE_ATTRIB))) != null) {
                            keyValue.setValue(StaxParserUtil.getAttributeValue(attribute));
                        }
                        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                        StaxParserUtil.validate(endElement, PROPERTY_ELEMENT);
                        claimsProcessor.add(keyValue);
                        continue;
                    }
                    throw logger.parserUnknownTag(elementName, subEvent.getLocation());
                }
                claimsProcessors.add(claimsProcessor);
                continue;
            }
            throw logger.parserUnknownTag(elementName, subEvent.getLocation());
        }
        return claimsProcessors;
    }

    private TokenProvidersType parseTokenProviders(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, TOKEN_PROVIDERS_ELEMENT);
        TokenProvidersType tokenProviders = new TokenProvidersType();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(TOKEN_PROVIDERS_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (subEvent == null) break;
            String elementName = StaxParserUtil.getStartElementName(subEvent);
            if (TOKEN_PROVIDER_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(subEvent, TOKEN_PROVIDER_ELEMENT);
                TokenProviderType tokenProvider = new TokenProviderType();
                QName attributeQName = new QName("", PROVIDER_CLASS_ATTRIB);
                Attribute attribute = subEvent.getAttributeByName(attributeQName);
                if (attribute != null) {
                    tokenProvider.setProviderClass(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", TOKEN_TYPE_ATTRIB))) != null) {
                    tokenProvider.setTokenType(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", TOKEN_ELEMENT_ATTRIB))) != null) {
                    tokenProvider.setTokenElement(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", TOKEN_ELEMENT_NS_ATTRIB))) != null) {
                    tokenProvider.setTokenElementNS(StaxParserUtil.getAttributeValue(attribute));
                }
                while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
                    if (xmlEvent instanceof EndElement) {
                        EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                        String endElementName = StaxParserUtil.getEndElementName(endElement);
                        if (endElementName.equals(TOKEN_PROVIDER_ELEMENT)) break;
                        throw logger.parserUnknownEndElement(endElementName);
                    }
                    subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
                    if (subEvent == null) break;
                    elementName = StaxParserUtil.getStartElementName(subEvent);
                    if (PROPERTY_ELEMENT.equalsIgnoreCase(elementName)) {
                        subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                        KeyValueType keyValue = new KeyValueType();
                        attributeQName = new QName("", KEY_ATTRIB);
                        attribute = subEvent.getAttributeByName(attributeQName);
                        if (attribute != null) {
                            keyValue.setKey(StaxParserUtil.getAttributeValue(attribute));
                        }
                        if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", VALUE_ATTRIB))) != null) {
                            keyValue.setValue(StaxParserUtil.getAttributeValue(attribute));
                        }
                        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                        StaxParserUtil.validate(endElement, PROPERTY_ELEMENT);
                        tokenProvider.add(keyValue);
                        continue;
                    }
                    throw logger.parserUnknownTag(elementName, subEvent.getLocation());
                }
                tokenProviders.add(tokenProvider);
                continue;
            }
            throw logger.parserUnknownTag(elementName, subEvent.getLocation());
        }
        return tokenProviders;
    }

    private ServiceProvidersType parseServiceProviders(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, SERVICE_PROVIDERS_ELEMENT);
        ServiceProvidersType serviceProviders = new ServiceProvidersType();
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = (EndElement)StaxParserUtil.getNextEvent(xmlEventReader);
                String endElementName = StaxParserUtil.getEndElementName(endElement);
                if (endElementName.equals(SERVICE_PROVIDERS_ELEMENT)) break;
                throw logger.parserUnknownEndElement(endElementName);
            }
            StartElement subEvent = StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (subEvent == null) break;
            String elementName = StaxParserUtil.getStartElementName(subEvent);
            if (SERVICE_PROVIDER_ELEMENT.equalsIgnoreCase(elementName)) {
                subEvent = StaxParserUtil.getNextStartElement(xmlEventReader);
                StaxParserUtil.validate(subEvent, SERVICE_PROVIDER_ELEMENT);
                ServiceProviderType serviceProvider = new ServiceProviderType();
                QName attributeQName = new QName("", TOKEN_TYPE_ATTRIB);
                Attribute attribute = subEvent.getAttributeByName(attributeQName);
                if (attribute != null) {
                    serviceProvider.setTokenType(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", ENDPOINT_ATTRIB))) != null) {
                    serviceProvider.setEndpoint(StaxParserUtil.getAttributeValue(attribute));
                }
                if ((attribute = subEvent.getAttributeByName(attributeQName = new QName("", TRUSTSTORE_ALIAS_ATTRIB))) != null) {
                    serviceProvider.setTruststoreAlias(StaxParserUtil.getAttributeValue(attribute));
                }
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, SERVICE_PROVIDER_ELEMENT);
                serviceProviders.add(serviceProvider);
                continue;
            }
            throw logger.parserUnknownTag(elementName, subEvent.getLocation());
        }
        return serviceProviders;
    }
}

