/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.sts.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.picketlink.identity.federation.core.sts.registry.AbstractJDBCRegistry;
import org.picketlink.identity.federation.core.sts.registry.SecurityTokenRegistry;

public class JDBCTokenRegistry
extends AbstractJDBCRegistry
implements SecurityTokenRegistry {
    public JDBCTokenRegistry() {
        super("jdbc/picketlink-sts");
    }

    public JDBCTokenRegistry(String jndiName) {
        super(jndiName);
    }

    public void addToken(String tokenID, Object token) throws IOException {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        String insertTableSQL = "INSERT INTO TOKEN_REGISTRY(TOKEN_ID, TOKEN, CREATED_DATE) VALUES(?,?,?)";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = this.dataSource.getConnection();
            Date tokenCreationDate = Calendar.getInstance().getTime();
            byte[] marshalledToken = this.marshallToken(token);
            String theToken = new String(marshalledToken, "UTF-8");
            preparedStatement = conn.prepareStatement(insertTableSQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.setString(2, theToken);
            preparedStatement.setTimestamp(3, new Timestamp(tokenCreationDate.getTime()));
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }

    public void removeToken(String tokenID) throws IOException {
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        String deleteSQL = "DELETE FROM TOKEN_REGISTRY WHERE TOKEN_ID = ?";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(deleteSQL);
            preparedStatement.setString(1, tokenID);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(preparedStatement);
        this.safeClose(conn);
    }

    public Object getToken(String tokenID) {
        try {
            return this.unmarshalToken(this.getLOB(tokenID));
        }
        catch (IOException e) {
            throw logger.runtimeException("getToken", e);
        }
    }

    private byte[] marshallToken(Object token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(token);
        return baos.toByteArray();
    }

    private Object unmarshalToken(String serializedText) {
        try {
            ByteArrayInputStream byteArray = new ByteArrayInputStream(serializedText.getBytes("UTF-8"));
            return new ObjectInputStream(byteArray).readObject();
        }
        catch (Exception e) {
            throw logger.errorUnmarshallingToken(e);
        }
    }

    private String getLOB(String tokenID) throws IOException {
        String string;
        if (this.dataSource == null) {
            throw logger.datasourceIsNull();
        }
        String selectSQL = "select TOKEN from TOKEN_REGISTRY where TOKEN_ID = ?";
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            conn = this.dataSource.getConnection();
            preparedStatement = conn.prepareStatement(selectSQL);
            preparedStatement.setString(1, tokenID);
            resultSet = preparedStatement.executeQuery();
            string = resultSet.getString(1);
        }
        catch (SQLException e) {
            try {
                throw new IOException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(resultSet);
                this.safeClose(preparedStatement);
                this.safeClose(conn);
                throw throwable;
            }
        }
        this.safeClose(resultSet);
        this.safeClose(preparedStatement);
        this.safeClose(conn);
        return string;
    }
}

