/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import java.io.OutputStream;
import java.net.URI;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.X509Data;
import org.picketlink.identity.federation.PicketLinkLogger;
import org.picketlink.identity.federation.PicketLinkLoggerFactory;
import org.picketlink.identity.federation.core.config.STSType;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.util.Base64;
import org.picketlink.identity.federation.core.util.ProvidersUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.core.util.SystemPropertiesUtil;
import org.picketlink.identity.federation.core.util.XMLEncryptionUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.ws.addressing.AttributedURIType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RenewingType;
import org.picketlink.identity.federation.ws.trust.RequestedReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.AttributedString;
import org.picketlink.identity.federation.ws.wss.secext.KeyIdentifierType;
import org.picketlink.identity.federation.ws.wss.secext.SecurityTokenReferenceType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSTrustUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static boolean includeKeyInfoInEncryptedKey;

    public static KeyIdentifierType createKeyIdentifier(String valueType, String value) {
        KeyIdentifierType keyIdentifier = new KeyIdentifierType();
        keyIdentifier.setValueType(valueType);
        keyIdentifier.setValue(value);
        return keyIdentifier;
    }

    public static RequestedReferenceType createRequestedReference(KeyIdentifierType keyIdentifier, Map<QName, String> attributes) {
        SecurityTokenReferenceType securityTokenReference = new SecurityTokenReferenceType();
        securityTokenReference.addAny(keyIdentifier);
        securityTokenReference.addOtherAttributes(attributes);
        RequestedReferenceType reference = new RequestedReferenceType();
        reference.setSecurityTokenReference(securityTokenReference);
        return reference;
    }

    public static AppliesTo createAppliesTo(String endpointURI) {
        AttributedURIType attributedURI = new AttributedURIType();
        attributedURI.setValue(endpointURI);
        EndpointReferenceType reference = new EndpointReferenceType();
        reference.setAddress(attributedURI);
        AppliesTo appliesTo = new AppliesTo();
        appliesTo.addAny(reference);
        return appliesTo;
    }

    public static EndpointReferenceType createIssuer(String addressUri) {
        AttributedURIType attributedURI = new AttributedURIType();
        attributedURI.setValue(addressUri);
        EndpointReferenceType endpointReference = new EndpointReferenceType();
        endpointReference.setAddress(attributedURI);
        return endpointReference;
    }

    public static String parseAppliesTo(AppliesTo appliesTo) {
        EndpointReferenceType reference = null;
        for (Object obj : appliesTo.getAny()) {
            JAXBElement element;
            if (obj instanceof EndpointReferenceType) {
                reference = (EndpointReferenceType)obj;
            } else if (obj instanceof JAXBElement && (element = (JAXBElement)obj).getName().getLocalPart().equalsIgnoreCase("EndpointReference")) {
                reference = (EndpointReferenceType)element.getValue();
            }
            if (reference == null || reference.getAddress() == null) continue;
            return reference.getAddress().getValue();
        }
        return null;
    }

    public static RenewingType parseRenewingType(XMLEventReader xmlEventReader) throws ParsingException {
        RenewingType renewingType = new RenewingType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "Renewing");
        Attribute allowAttribute = startElement.getAttributeByName(new QName("Allow"));
        if (allowAttribute != null) {
            renewingType.setAllow(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(allowAttribute)));
        }
        Attribute okAttribute = startElement.getAttributeByName(new QName("OK"));
        if (allowAttribute != null) {
            renewingType.setOK(Boolean.parseBoolean(StaxParserUtil.getAttributeValue(okAttribute)));
        }
        EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
        StaxParserUtil.validate(endElement, "Renewing");
        return renewingType;
    }

    public static Lifetime createDefaultLifetime(long tokenTimeout) {
        GregorianCalendar created = new GregorianCalendar();
        GregorianCalendar expires = new GregorianCalendar();
        expires.setTimeInMillis(created.getTimeInMillis() + tokenTimeout);
        return new Lifetime(created, expires);
    }

    public static Principal getOnBehalfOfPrincipal(OnBehalfOfType onBehalfOf) {
        UsernameTokenType usernameToken = null;
        List<Object> theList = onBehalfOf.getAny();
        for (Object content : theList) {
            JAXBElement element;
            if (content instanceof UsernameTokenType) {
                usernameToken = (UsernameTokenType)content;
                continue;
            }
            if (!(content instanceof JAXBElement) || !(element = (JAXBElement)content).getName().getLocalPart().equalsIgnoreCase("UsernameToken")) continue;
            usernameToken = (UsernameTokenType)element.getValue();
        }
        if (usernameToken != null && usernameToken.getUsername() != null) {
            final String username = usernameToken.getUsername().getValue();
            return new Principal(){

                public String getName() {
                    return username;
                }
            };
        }
        logger.debug("Unable to parse the contents of the OnBehalfOfType: " + onBehalfOf.getAny());
        return null;
    }

    public static OnBehalfOfType createOnBehalfOfWithUsername(String username, String id) {
        AttributedString attrString = new AttributedString();
        attrString.setValue(username);
        UsernameTokenType usernameToken = new UsernameTokenType();
        usernameToken.setId(id);
        usernameToken.setUsername(attrString);
        OnBehalfOfType onBehalfOf = new OnBehalfOfType();
        onBehalfOf.add(usernameToken);
        return onBehalfOf;
    }

    public static byte[] getBinarySecret(EntropyType entropy) {
        byte[] secret = null;
        for (Object obj : entropy.getAny()) {
            if (!(obj instanceof BinarySecretType)) continue;
            BinarySecretType binarySecret = (BinarySecretType)obj;
            secret = binarySecret.getValue();
            break;
        }
        return secret;
    }

    public static void persistSTSConfiguration(STSType stsConfiguration, OutputStream outputStream) {
        throw new RuntimeException();
    }

    public static byte[] createRandomSecret(int size) {
        SecureRandom random = new SecureRandom();
        byte[] secret = new byte[size];
        random.nextBytes(secret);
        return secret;
    }

    public static byte[] P_SHA1(byte[] secret, byte[] seed, int requiredSize) throws NoSuchAlgorithmException, InvalidKeyException {
        int offset = 0;
        byte[] result = new byte[requiredSize];
        SecretKeySpec key = new SecretKeySpec(secret, "HMACSHA1");
        Mac mac = Mac.getInstance("HMACSHA1");
        byte[] A = seed;
        while (requiredSize > 0) {
            mac.init(key);
            mac.update(A);
            A = mac.doFinal();
            mac.reset();
            mac.init(key);
            mac.update(A);
            mac.update(seed);
            byte[] partialResult = mac.doFinal();
            int copySize = Math.min(requiredSize, partialResult.length);
            System.arraycopy(partialResult, 0, result, offset, copySize);
            offset += copySize;
            requiredSize -= copySize;
        }
        return result;
    }

    public static KeyInfoType createKeyInfo(byte[] secret, PublicKey encryptionKey, URI keyWrapAlgo, X509Certificate cer) throws WSTrustException {
        KeyInfoType keyInfo = null;
        if (encryptionKey != null) {
            try {
                Document document = DocumentUtil.createDocument();
                EncryptedKey key = XMLEncryptionUtil.encryptKey(document, new SecretKeySpec(secret, "AES"), encryptionKey, secret.length * 8);
                if (cer != null && includeKeyInfoInEncryptedKey) {
                    KeyInfo kiEnc = new KeyInfo(document);
                    X509Data xData = new X509Data(document);
                    xData.addIssuerSerial(cer.getIssuerDN().getName(), cer.getSerialNumber());
                    kiEnc.add(xData);
                    key.setKeyInfo(kiEnc);
                }
                Element encryptedKeyElement = XMLCipher.getInstance().martial(key);
                keyInfo = new KeyInfoType();
                keyInfo.addContent(encryptedKeyElement);
            }
            catch (Exception e) {
                throw logger.stsKeyInfoTypeCreationError(e);
            }
        } else {
            logger.stsSecretKeyNotEncrypted();
        }
        return keyInfo;
    }

    public static KeyInfoType createKeyInfo(byte[] secret, PublicKey encryptionKey, URI keyWrapAlgo) throws WSTrustException {
        return WSTrustUtil.createKeyInfo(secret, encryptionKey, keyWrapAlgo, null);
    }

    public static KeyInfoType createKeyInfo(Certificate certificate) throws WSTrustException {
        KeyInfoType keyInfo = null;
        try {
            byte[] encodedCert = certificate.getEncoded();
            X509DataType x509 = new X509DataType();
            X509CertificateType cert = new X509CertificateType();
            cert.setEncodedCertificate(Base64.encodeBytes(encodedCert).getBytes());
            x509.add(cert);
            keyInfo = new KeyInfoType();
            keyInfo.addContent(x509);
        }
        catch (Exception e) {
            throw logger.stsKeyInfoTypeCreationError(e);
        }
        return keyInfo;
    }

    public static KeyValueType createKeyValue(PublicKey key) {
        return XMLSignatureUtil.createKeyValue(key);
    }

    public static String getServiceNameFromAppliesTo(RequestSecurityToken requestSecurityToken) {
        AppliesTo appliesTo;
        String serviceName = null;
        if (requestSecurityToken != null && (appliesTo = requestSecurityToken.getAppliesTo()) != null) {
            serviceName = WSTrustUtil.parseAppliesTo(appliesTo);
        }
        return serviceName;
    }

    static {
        ProvidersUtil.ensure();
        SystemPropertiesUtil.ensure();
        String keyInfoProp = SystemPropertiesUtil.getSystemProperty("picketlink.encryption.includeKeyInfo", null);
        if (StringUtil.isNotNull(keyInfoProp)) {
            includeKeyInfoInEncryptedKey = Boolean.parseBoolean(keyInfoProp);
        }
        includeKeyInfoInEncryptedKey = true;
    }
}

