/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.credential.internal;

import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Named;
import org.picketlink.authentication.event.LoginFailedEvent;
import org.picketlink.authentication.event.PostAuthenticateEvent;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.Password;
import org.picketlink.idm.model.Agent;

@Named(value="loginCredentials")
@RequestScoped
public class DefaultLoginCredentials
implements Credentials {
    private Object credential;
    private String userId;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Object getCredential() {
        return this.credential;
    }

    public void setCredential(Object credential) {
        this.credential = credential;
    }

    public String getPassword() {
        if (this.credential != null && this.credential instanceof Password) {
            Password ptp = (Password)this.credential;
            return new String(ptp.getValue());
        }
        return null;
    }

    public void setPassword(String password) {
        this.credential = new Password(password.toCharArray());
    }

    public void invalidate() {
        this.credential = null;
        this.userId = null;
    }

    protected void setValid(@Observes PostAuthenticateEvent event) {
        this.invalidate();
    }

    protected void afterLogin(@Observes PostAuthenticateEvent event) {
        this.invalidate();
    }

    protected void loginFailed(@Observes LoginFailedEvent event) {
        this.invalidate();
    }

    public String toString() {
        return "LoginCredential[" + (this.userId != null ? this.userId : "unknown") + "]";
    }

    public Agent getValidatedAgent() {
        return null;
    }

    public Credentials.Status getStatus() {
        return null;
    }
}

