/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.permission.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.PropertyQuery;
import org.picketlink.internal.util.Strings;
import org.picketlink.permission.annotations.PermissionsHandledBy;
import org.picketlink.permission.internal.BaseAbstractPermissionHandler;
import org.picketlink.permission.spi.PermissionHandler;

public class EntityPermissionHandler
extends BaseAbstractPermissionHandler
implements PermissionHandler {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();
    private Map<Class<?>, Property<Serializable>> identifierProperties = new ConcurrentHashMap();
    @Inject
    Instance<EntityManager> entityManager;

    public boolean canHandle(Class<?> resourceClass) {
        return resourceClass.isAnnotationPresent(Entity.class);
    }

    public String getGeneratedIdentifier(Object resource) {
        return String.format("%s:%s", this.getIdentifierName(resource.getClass()), this.getNaturalIdentifier(resource));
    }

    public Serializable getNaturalIdentifier(Object resource) {
        Class<?> resourceClass = resource.getClass();
        if (!this.identifierProperties.containsKey(resourceClass)) {
            PropertyQuery pq = PropertyQueries.createQuery(resource.getClass());
            pq.addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Id.class));
            this.identifierProperties.put(resourceClass, (Property<Serializable>)pq.getSingleResult());
        }
        Property<Serializable> p = this.identifierProperties.get(resourceClass);
        return (Serializable)p.getValue(resource);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            PermissionsHandledBy identifier;
            String name = null;
            if (cls.isAnnotationPresent(PermissionsHandledBy.class) && !Strings.isEmpty((identifier = cls.getAnnotation(PermissionsHandledBy.class)).name())) {
                name = identifier.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }

    public boolean canLoadResource(String identifier) {
        return false;
    }

    public Object lookupResource(String identifier) {
        return null;
    }
}

