/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.permission.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.picketlink.permission.annotations.PermissionsHandledBy;
import org.picketlink.permission.internal.ClassPermissionHandler;
import org.picketlink.permission.internal.EntityPermissionHandler;
import org.picketlink.permission.spi.PermissionHandler;

@ApplicationScoped
public class PermissionHandlerPolicy {
    private Map<Class<?>, PermissionHandler> handlers = new ConcurrentHashMap();
    private Set<PermissionHandler> registeredHandlers = new HashSet<PermissionHandler>();

    @Inject
    public void create() {
        if (this.registeredHandlers.isEmpty()) {
            this.registeredHandlers.add(new EntityPermissionHandler());
            this.registeredHandlers.add(new ClassPermissionHandler());
        }
    }

    public String getGeneratedIdentifier(Object resource) {
        if (resource instanceof String) {
            return (String)resource;
        }
        PermissionHandler handler = this.getHandlerForResource(resource);
        return handler != null ? handler.getGeneratedIdentifier(resource) : null;
    }

    public Object lookupResource(String identifier, Collection<Object> loadedResources) {
        Map<String, Object> loadedResourceIdentifiers = this.loadResourceIdentifiers(loadedResources);
        if (loadedResourceIdentifiers.containsKey(identifier)) {
            return loadedResourceIdentifiers.get(identifier);
        }
        PermissionHandler handler = this.getHandlerForIdentifier(identifier);
        return handler != null ? handler.lookupResource(identifier) : null;
    }

    private Map<String, Object> loadResourceIdentifiers(Collection<Object> resources) {
        if (resources == null || resources.isEmpty()) {
            return null;
        }
        HashMap<String, Object> identifiers = new HashMap<String, Object>();
        for (Object resource : resources) {
            String identifier;
            PermissionHandler handler = this.getHandlerForResource(resource);
            if (handler == null || identifiers.containsKey(identifier = handler.getGeneratedIdentifier(resource))) continue;
            identifiers.put(identifier, resource);
        }
        return identifiers;
    }

    public Map<String, Object> lookupResources(Collection<String> identifiers, Collection<Object> loadedResources) {
        HashMap<String, Object> resources = new HashMap<String, Object>();
        Map<String, Object> loadedResourceIdentifiers = this.loadResourceIdentifiers(loadedResources);
        for (String identifier : identifiers) {
            Object resource;
            if (loadedResourceIdentifiers.containsKey(identifier)) {
                resources.put(identifier, loadedResourceIdentifiers.get(identifier));
                continue;
            }
            PermissionHandler handler = this.getHandlerForIdentifier(identifier);
            if (handler == null || (resource = handler.lookupResource(identifier)) == null) continue;
            resources.put(identifier, resource);
        }
        return resources;
    }

    public Serializable getNaturalIdentifier(Object resource) {
        PermissionHandler strategy = this.getHandlerForResource(resource);
        return strategy != null ? strategy.getNaturalIdentifier(resource) : null;
    }

    private PermissionHandler getHandlerForIdentifier(String identifier) {
        for (PermissionHandler handler : this.handlers.values()) {
            if (!handler.canLoadResource(identifier)) continue;
            return handler;
        }
        for (PermissionHandler handler : this.registeredHandlers) {
            if (!handler.canLoadResource(identifier)) continue;
            return handler;
        }
        return null;
    }

    private PermissionHandler getHandlerForResource(Object resource) {
        PermissionHandler handler = this.handlers.get(resource.getClass());
        if (handler == null) {
            Class handlerClass;
            if (resource.getClass().isAnnotationPresent(PermissionsHandledBy.class) && (handlerClass = resource.getClass().getAnnotation(PermissionsHandledBy.class).value()) != PermissionHandler.class) {
                try {
                    handler = (PermissionHandler)handlerClass.newInstance();
                    this.handlers.put(resource.getClass(), handler);
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error instantiating IdentifierStrategy for object " + resource, ex);
                }
            }
            for (PermissionHandler s : this.registeredHandlers) {
                if (!s.canHandle(resource.getClass())) continue;
                handler = s;
                this.handlers.put(resource.getClass(), handler);
                break;
            }
        }
        return handler;
    }

    public Set<String> convertResourcePermissions(Object resource, Object permissions) {
        PermissionHandler handler = this.getHandlerForResource(resource);
        return handler != null ? handler.convertResourcePermissions(resource.getClass(), permissions) : null;
    }

    public Set<PermissionHandler> getRegisteredHandlers() {
        return this.registeredHandlers;
    }

    public void setRegisteredHandlers(Set<PermissionHandler> registeredHandlers) {
        this.registeredHandlers = registeredHandlers;
    }
}

