/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.saml;

import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.ParserNamespaceSupport;
import org.picketlink.identity.federation.core.parsers.util.SAML11ParserUtil;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11RequestType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11SubjectQueryAbstractType;

public class SAML11RequestParser
implements ParserNamespaceSupport {
    protected SAML11RequestType parseRequiredAttributes(StartElement startElement) throws ParsingException {
        Attribute idAttr = startElement.getAttributeByName(new QName("RequestID"));
        if (idAttr == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: RequestID");
        }
        String id = StaxParserUtil.getAttributeValue(idAttr);
        Attribute issueInstantAttr = startElement.getAttributeByName(new QName("IssueInstant"));
        if (issueInstantAttr == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: IssueInstant");
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(issueInstantAttr));
        return new SAML11RequestType(id, issueInstant);
    }

    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, "Request");
        SAML11RequestType request = this.parseRequiredAttributes(startElement);
        while (xmlEventReader.hasNext() && (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) != null) {
            SAML11SubjectQueryAbstractType query;
            String elementName = StaxParserUtil.getStartElementName(startElement);
            if ("AttributeQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AttributeQuery(xmlEventReader);
                request.setQuery(query);
                continue;
            }
            if ("AuthenticationQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AuthenticationQuery(xmlEventReader);
                request.setQuery(query);
                continue;
            }
            if ("AssertionArtifact".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                request.addAssertionArtifact(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            if ("AuthorizationDecisionQuery".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                query = SAML11ParserUtil.parseSAML11AuthorizationDecisionQueryType(xmlEventReader);
                request.setQuery(query);
                continue;
            }
            if (elementName.equals(JBossSAMLConstants.SIGNATURE.get())) {
                request.setSignature(StaxParserUtil.getDOMElement(xmlEventReader));
                continue;
            }
            if ("AssertionIDReference".equals(elementName)) {
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                request.addAssertionIDRef(StaxParserUtil.getElementText(xmlEventReader));
                continue;
            }
            throw new RuntimeException("PL00064: Parser: Unknown Start Element: " + elementName + "::location=" + startElement.getLocation());
        }
        return request;
    }

    public boolean supports(QName qname) {
        return JBossSAMLURIConstants.PROTOCOL_NSURI.get().equals(qname.getNamespaceURI());
    }
}

