/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.parsers.util.StaxParserUtil;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectLocalityType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLParserUtil {
    public static AttributeStatementType parseAttributeStatement(XMLEventReader xmlEventReader) throws ParsingException {
        AttributeStatementType attributeStatementType = new AttributeStatementType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String ATTRIBSTATEMT = JBossSAMLConstants.ATTRIBUTE_STATEMENT.get();
        StaxParserUtil.validate(startElement, ATTRIBSTATEMT);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
                StaxParserUtil.validate(endElement, JBossSAMLConstants.ATTRIBUTE_STATEMENT.get());
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement(xmlEventReader);
            String tag = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) {
                AttributeType attribute = SAMLParserUtil.parseAttribute(xmlEventReader);
                attributeStatementType.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::Location=" + startElement.getLocation());
        }
        return attributeStatementType;
    }

    public static AttributeType parseAttribute(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE.get());
        AttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()));
        if (name == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: Name");
        }
        attributeType = new AttributeType(StaxParserUtil.getAttributeValue(name));
        SAMLParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.ATTRIBUTE.get(), attributeType);
        return attributeType;
    }

    public static void parseAttributeType(XMLEventReader xmlEventReader, StartElement startElement, String rootTag, AttributeType attributeType) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        Attribute nameFormat;
        Attribute friendlyName;
        QName x500EncodingName = new QName(JBossSAMLURIConstants.X500_NSURI.get(), JBossSAMLConstants.ENCODING.get(), JBossSAMLURIConstants.X500_PREFIX.get());
        Attribute x500EncodingAttr = startElement.getAttributeByName(x500EncodingName);
        if (x500EncodingAttr != null) {
            attributeType.getOtherAttributes().put(x500EncodingAttr.getName(), StaxParserUtil.getAttributeValue(x500EncodingAttr));
        }
        if ((friendlyName = startElement.getAttributeByName(new QName(JBossSAMLConstants.FRIENDLY_NAME.get()))) != null) {
            attributeType.setFriendlyName(StaxParserUtil.getAttributeValue(friendlyName));
        }
        if ((nameFormat = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_FORMAT.get()))) != null) {
            attributeType.setNameFormat(StaxParserUtil.getAttributeValue(nameFormat));
        }
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek(xmlEventReader)) instanceof EndElement && StaxParserUtil.matches(end = StaxParserUtil.getNextEndElement(xmlEventReader), rootTag) || (startElement = StaxParserUtil.peekNextStartElement(xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) break;
            if (JBossSAMLConstants.ATTRIBUTE_VALUE.get().equals(tag)) {
                Object attributeValue = SAMLParserUtil.parseAttributeValue(xmlEventReader);
                attributeType.addAttributeValue(attributeValue);
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::Location=" + startElement.getLocation());
        }
    }

    public static Object parseAttributeValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.ATTRIBUTE_VALUE.get());
        Attribute type = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xsi"));
        if (type == null) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        String typeValue = StaxParserUtil.getAttributeValue(type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":anyType")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        throw new RuntimeException("PL0065: Parser : Unknown xsi:type=" + typeValue);
    }

    public static AuthnStatementType parseAuthnStatement(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String AUTHNSTATEMENT = JBossSAMLConstants.AUTHN_STATEMENT.get();
        StaxParserUtil.validate(startElement, AUTHNSTATEMENT);
        Attribute authnInstant = startElement.getAttributeByName(new QName("AuthnInstant"));
        if (authnInstant == null) {
            throw new RuntimeException("PL00063: Parser: Required attribute missing: AuthnInstant");
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue(authnInstant));
        AuthnStatementType authnStatementType = new AuthnStatementType(issueInstant);
        Attribute sessionIndex = startElement.getAttributeByName(new QName("SessionIndex"));
        if (sessionIndex != null) {
            authnStatementType.setSessionIndex(StaxParserUtil.getAttributeValue(sessionIndex));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek(xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent(xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName(endElement);
                if (endElementTag.equals(AUTHNSTATEMENT)) break;
                throw new RuntimeException("PL00061: Parser: Unknown End Element:" + endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement(xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName(startElement);
            if (JBossSAMLConstants.SUBJECT_LOCALITY.get().equals(tag)) {
                Attribute dns;
                startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
                SubjectLocalityType subjectLocalityType = new SubjectLocalityType();
                Attribute address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()));
                if (address != null) {
                    subjectLocalityType.setAddress(StaxParserUtil.getAttributeValue(address));
                }
                if ((dns = startElement.getAttributeByName(new QName(JBossSAMLConstants.DNS_NAME.get()))) != null) {
                    subjectLocalityType.setDNSName(StaxParserUtil.getAttributeValue(dns));
                }
                authnStatementType.setSubjectLocality(subjectLocalityType);
                StaxParserUtil.validate(StaxParserUtil.getNextEndElement(xmlEventReader), JBossSAMLConstants.SUBJECT_LOCALITY.get());
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT.get().equals(tag)) {
                authnStatementType.setAuthnContext(SAMLParserUtil.parseAuthnContextType(xmlEventReader));
                continue;
            }
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::Location=" + startElement.getLocation());
        }
        return authnStatementType;
    }

    public static AuthnContextType parseAuthnContextType(XMLEventReader xmlEventReader) throws ParsingException {
        AuthnContextType authnContextType = new AuthnContextType();
        StartElement startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(startElement, JBossSAMLConstants.AUTHN_CONTEXT.get());
        startElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        String tag = startElement.getName().getLocalPart();
        if (JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get().equals(tag)) {
            String text = StaxParserUtil.getElementText(xmlEventReader);
            AuthnContextDeclRefType aAuthnContextDeclType = new AuthnContextDeclRefType(URI.create(text));
            authnContextType.addURIType(aAuthnContextDeclType);
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            StaxParserUtil.validate(endElement, JBossSAMLConstants.AUTHN_CONTEXT.get());
        } else if (JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get().equals(tag)) {
            String text = StaxParserUtil.getElementText(xmlEventReader);
            AuthnContextClassRefType aAuthnContextClassRefType = new AuthnContextClassRefType(URI.create(text));
            AuthnContextType.AuthnContextTypeSequence authnContextSequence = authnContextType.new AuthnContextType.AuthnContextTypeSequence();
            authnContextSequence.setClassRef(aAuthnContextClassRefType);
            authnContextType.setSequence(authnContextSequence);
            EndElement endElement = StaxParserUtil.getNextEndElement(xmlEventReader);
            StaxParserUtil.validate(endElement, JBossSAMLConstants.AUTHN_CONTEXT.get());
        } else {
            throw new RuntimeException("PL00062: Parser : Unknown tag:" + tag + "::Location=" + startElement.getLocation());
        }
        return authnContextType;
    }

    public static NameIDType parseNameIDType(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute spNameQualifier;
        Attribute spProvidedID;
        Attribute format;
        StartElement nameIDElement = StaxParserUtil.getNextStartElement(xmlEventReader);
        NameIDType nameID = new NameIDType();
        Attribute nameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_QUALIFIER.get()));
        if (nameQualifier != null) {
            nameID.setNameQualifier(StaxParserUtil.getAttributeValue(nameQualifier));
        }
        if ((format = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.FORMAT.get()))) != null) {
            nameID.setFormat(URI.create(StaxParserUtil.getAttributeValue(format)));
        }
        if ((spProvidedID = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_PROVIDED_ID.get()))) != null) {
            nameID.setSPProvidedID(StaxParserUtil.getAttributeValue(spProvidedID));
        }
        if ((spNameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_NAME_QUALIFIER.get()))) != null) {
            nameID.setSPNameQualifier(StaxParserUtil.getAttributeValue(spNameQualifier));
        }
        String nameIDValue = StaxParserUtil.getElementText(xmlEventReader);
        nameID.setValue(nameIDValue);
        return nameID;
    }

    public static List<String> parseProtocolEnumeration(StartElement startElement) {
        ArrayList<String> protocolEnum = new ArrayList<String>();
        Attribute proto = startElement.getAttributeByName(new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()));
        String val = StaxParserUtil.getAttributeValue(proto);
        if (StringUtil.isNotNull(val)) {
            StringTokenizer st = new StringTokenizer(val);
            while (st.hasMoreTokens()) {
                protocolEnum.add(st.nextToken());
            }
        }
        return protocolEnum;
    }
}

