/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.holders;

import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;

public class IssuerInfoHolder {
    private NameIDType issuer;
    private String statusCodeURI = JBossSAMLURIConstants.STATUS_SUCCESS.get();
    private String samlVersion = JBossSAMLConstants.VERSION_2_0.get();

    public IssuerInfoHolder(NameIDType issuer) {
        if (issuer == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:issuer");
        }
        this.issuer = issuer;
    }

    public IssuerInfoHolder(String issuerAsString) {
        if (issuerAsString == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:issuerAsString");
        }
        this.issuer = new NameIDType();
        this.issuer.setValue(issuerAsString);
    }

    public NameIDType getIssuer() {
        return this.issuer;
    }

    public void setIssuer(NameIDType issuer) {
        this.issuer = issuer;
    }

    public String getStatusCode() {
        return this.statusCodeURI;
    }

    public void setStatusCode(String statusCode) {
        this.statusCodeURI = statusCode;
    }

    public String getSamlVersion() {
        return this.samlVersion;
    }

    public void setSamlVersion(String samlVersion) {
        this.samlVersion = samlVersion;
    }
}

