/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.wstrust;

import java.net.ConnectException;
import java.net.URI;
import java.security.Principal;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientFactory;
import org.picketlink.identity.federation.core.wstrust.WSTrustException;
import org.picketlink.identity.federation.core.wstrust.WSTrustUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.w3c.dom.Element;

public class WSTrustClient {
    private final STSClient[] clients;

    public WSTrustClient(String serviceName, String port, String endpointURI, SecurityInfo secInfo) throws ParsingException {
        this(serviceName, port, new String[]{endpointURI}, secInfo);
    }

    public WSTrustClient(String serviceName, String port, String[] endpointURIs, SecurityInfo secInfo) throws ParsingException {
        if (serviceName == null || port == null || endpointURIs == null || secInfo == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:The service name, port, endpoint URIs and security info parameters cannot be null");
        }
        if (endpointURIs.length == 0) {
            throw new IllegalArgumentException("PL00078: Null Parameter:At least one endpoint URI must be provided");
        }
        this.clients = new STSClient[endpointURIs.length];
        STSClientConfig.Builder builder = new STSClientConfig.Builder();
        builder.serviceName(serviceName).portName(port).username(secInfo.username).password(secInfo.passwd);
        int index = 0;
        String[] stringArray = endpointURIs;
        int n = endpointURIs.length;
        int n2 = 0;
        while (n2 < n) {
            String endpointURI = stringArray[n2];
            builder.endpointAddress(endpointURI);
            this.clients[index++] = STSClientFactory.getInstance().create(builder.build());
            ++n2;
        }
    }

    public Element issueToken(String tokenType) throws WSTrustException {
        if (tokenType == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:The token type");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        request.setTokenType(URI.create(tokenType));
        return this.issueInternal(request, 0);
    }

    public Element issueTokenForEndpoint(String endpointURI) throws WSTrustException {
        if (endpointURI == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:The endpoint URI");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        return this.issueInternal(request, 0);
    }

    public Element issueToken(String endpointURI, String tokenType) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:Either the token type or endpoint URI must be specified");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (tokenType != null) {
            request.setTokenType(URI.create(tokenType));
        }
        if (endpointURI != null) {
            request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        }
        return this.issueInternal(request, 0);
    }

    public Element issueTokenOnBehalfOf(String endpointURI, String tokenType, Principal principal) throws WSTrustException {
        if (endpointURI == null && tokenType == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:Either the token type or endpoint URI must be specified");
        }
        if (principal == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:The on-behalf-of principal");
        }
        RequestSecurityToken request = new RequestSecurityToken();
        if (tokenType != null) {
            request.setTokenType(URI.create(tokenType));
        }
        if (endpointURI != null) {
            request.setAppliesTo(WSTrustUtil.createAppliesTo((String)endpointURI));
        }
        request.setOnBehalfOf(WSTrustUtil.createOnBehalfOfWithUsername((String)principal.getName(), (String)"ID"));
        return this.issueInternal(request, 0);
    }

    public Element issueToken(RequestSecurityToken request) throws WSTrustException {
        if (request == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:request");
        }
        return this.issueInternal(request, 0);
    }

    public Element renewToken(String tokenType, Element token) throws WSTrustException {
        return this.renewInternal(tokenType, token, 0);
    }

    public boolean validateToken(Element token) throws WSTrustException {
        return this.validateInternal(token, 0);
    }

    public boolean cancelToken(Element token) throws WSTrustException {
        return this.cancelInternal(token, 0);
    }

    private Element issueInternal(RequestSecurityToken request, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.issueToken(request);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.issueInternal(request, ++clientIndex);
            }
            throw e;
        }
    }

    private Element renewInternal(String tokenType, Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.renewToken(tokenType, token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.renewInternal(tokenType, token, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean validateInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.validateToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.validateInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean cancelInternal(Element token, int clientIndex) throws WSTrustException {
        STSClient client = this.clients[clientIndex];
        try {
            return client.cancelToken(token);
        }
        catch (RuntimeException e) {
            if (this.isCausedByConnectException(e) && clientIndex < this.clients.length - 1) {
                return this.cancelInternal(token, ++clientIndex);
            }
            throw e;
        }
    }

    private boolean isCausedByConnectException(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable instanceof ConnectException && throwable.getMessage().equals("Connection refused");
    }

    public static class SecurityInfo {
        private final String username;
        private final String passwd;

        public SecurityInfo(String name, char[] pass) {
            this.username = name;
            this.passwd = new String(pass);
        }

        public SecurityInfo(String name, String pass) {
            this.username = name;
            this.passwd = pass;
        }
    }
}

