/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.md.providers;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedNameType;
import org.picketlink.identity.federation.saml.v2.metadata.LocalizedURIType;
import org.picketlink.identity.federation.saml.v2.metadata.OrganizationType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SSODescriptorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataBuilderDelegate {
    public static EndpointType createEndpoint(String binding, String location, String responseLocation) {
        EndpointType endpoint = new EndpointType(URI.create(binding), URI.create(location));
        endpoint.setResponseLocation(URI.create(responseLocation));
        return endpoint;
    }

    public static OrganizationType createOrganization(String organizationName, String organizationDisplayName, String organizationURL, String lang) {
        if (organizationName == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:organizationName");
        }
        if (organizationDisplayName == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:organizationDisplayName");
        }
        if (organizationURL == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:organizationURL");
        }
        if (lang == null) {
            lang = JBossSAMLConstants.LANG_EN.get();
        }
        LocalizedNameType orgName = new LocalizedNameType(lang);
        orgName.setValue(organizationName);
        LocalizedNameType orgDisplayName = new LocalizedNameType(lang);
        orgDisplayName.setValue(organizationDisplayName);
        LocalizedURIType orgURL = new LocalizedURIType(lang);
        orgURL.setValue(URI.create(organizationURL));
        OrganizationType orgType = new OrganizationType();
        orgType.addOrganizationName(orgName);
        orgType.addOrganizationDisplayName(orgDisplayName);
        orgType.addOrganizationURL(orgURL);
        return orgType;
    }

    public static EntityDescriptorType createEntityDescriptor(SSODescriptorType idpOrSPDescriptor) {
        EntityDescriptorType.EDTDescriptorChoiceType edtDescriptorChoiceType = new EntityDescriptorType.EDTDescriptorChoiceType(idpOrSPDescriptor);
        ArrayList<EntityDescriptorType.EDTDescriptorChoiceType> edtList = new ArrayList<EntityDescriptorType.EDTDescriptorChoiceType>();
        edtList.add(edtDescriptorChoiceType);
        EntityDescriptorType.EDTChoiceType choiceType = new EntityDescriptorType.EDTChoiceType(edtList);
        EntityDescriptorType entity = new EntityDescriptorType(" ");
        entity.addChoiceType(choiceType);
        return entity;
    }

    public static IDPSSODescriptorType createIDPSSODescriptor(boolean requestsSigned, KeyDescriptorType keyDescriptorType, EndpointType ssoEndPoint, EndpointType sloEndPoint, List<AttributeType> attributes, OrganizationType org) {
        ArrayList emptyList = new ArrayList();
        IDPSSODescriptorType idp = new IDPSSODescriptorType(emptyList);
        idp.addSingleSignOnService(ssoEndPoint);
        idp.addSingleLogoutService(sloEndPoint);
        for (AttributeType attr : attributes) {
            idp.addAttribute(attr);
        }
        idp.addKeyDescriptor(keyDescriptorType);
        idp.setWantAuthnRequestsSigned(Boolean.valueOf(requestsSigned));
        idp.setOrganization(org);
        return idp;
    }

    public static SPSSODescriptorType createSPSSODescriptor(boolean requestsSigned, KeyDescriptorType keyDescriptorType, EndpointType sloEndPoint, List<AttributeType> attributes, OrganizationType org) {
        ArrayList<String> protocolEnumList = new ArrayList<String>();
        protocolEnumList.add(JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        SPSSODescriptorType sp = new SPSSODescriptorType(protocolEnumList);
        sp.addSingleLogoutService(sloEndPoint);
        sp.addKeyDescriptor(keyDescriptorType);
        sp.setAuthnRequestsSigned(Boolean.valueOf(requestsSigned));
        sp.setOrganization(org);
        return sp;
    }
}

