/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.factories;

import java.net.URI;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AudienceRestrictionType;
import org.picketlink.identity.federation.saml.v2.assertion.BaseIDAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.ConditionsType;
import org.picketlink.identity.federation.saml.v2.assertion.KeyInfoConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMLAssertionFactory {
    public static AudienceRestrictionType createAudienceRestriction(String ... values) {
        AudienceRestrictionType audienceRestriction = new AudienceRestrictionType();
        if (values != null) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                audienceRestriction.addAudience(URI.create(val));
                ++n2;
            }
        }
        return audienceRestriction;
    }

    public static NameIDType createNameID(String format, String qualifier, String value) {
        NameIDType nameID = new NameIDType();
        if (format != null) {
            nameID.setFormat(URI.create(format));
        }
        nameID.setNameQualifier(qualifier);
        nameID.setValue(value);
        return nameID;
    }

    public static ConditionsType createConditions(XMLGregorianCalendar notBefore, XMLGregorianCalendar notOnOrAfter, ConditionAbstractType ... restrictions) {
        ConditionsType conditions = new ConditionsType();
        conditions.setNotBefore(notBefore);
        conditions.setNotOnOrAfter(notOnOrAfter);
        if (restrictions != null) {
            ConditionAbstractType[] conditionAbstractTypeArray = restrictions;
            int n = restrictions.length;
            int n2 = 0;
            while (n2 < n) {
                ConditionAbstractType condition = conditionAbstractTypeArray[n2];
                conditions.addCondition(condition);
                ++n2;
            }
        }
        return conditions;
    }

    public static KeyInfoConfirmationDataType createKeyInfoConfirmation(KeyInfoType keyInfo) {
        KeyInfoConfirmationDataType type = new KeyInfoConfirmationDataType();
        type.setAnyType((Object)keyInfo);
        return type;
    }

    public static SubjectConfirmationType createSubjectConfirmation(NameIDType nameID, String confirmationMethod, KeyInfoConfirmationDataType keyInfoData) {
        SubjectConfirmationType subjectConfirmation = new SubjectConfirmationType();
        subjectConfirmation.setNameID(nameID);
        subjectConfirmation.setMethod(confirmationMethod);
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationDataType)keyInfoData);
        return subjectConfirmation;
    }

    public static SubjectType createSubject(NameIDType nameID, SubjectConfirmationType confirmation) {
        SubjectType subject = new SubjectType();
        if (nameID != null) {
            SubjectType.STSubType subType = new SubjectType.STSubType();
            subType.addConfirmation(confirmation);
            subType.addBaseID((BaseIDAbstractType)nameID);
            subject.setSubType(subType);
        }
        return subject;
    }

    public static AssertionType createAssertion(String id, NameIDType issuerID, XMLGregorianCalendar issueInstant, ConditionsType conditions, SubjectType subject, List<StatementAbstractType> statements) {
        AssertionType assertion = new AssertionType(id, issueInstant);
        assertion.setIssuer(issuerID);
        if (conditions != null) {
            assertion.setConditions(conditions);
        }
        if (subject != null) {
            assertion.setSubject(subject);
        }
        if (statements != null) {
            for (StatementAbstractType statement : statements) {
                assertion.addStatement(statement);
            }
        }
        return assertion;
    }
}

