/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.v2.writers;

import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.picketlink.identity.federation.core.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.exceptions.ParsingException;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.picketlink.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.BaseWriter;
import org.picketlink.identity.federation.core.util.JAXBUtil;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.util.StringUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectType;
import org.picketlink.identity.federation.saml.v2.protocol.ArtifactResolveType;
import org.picketlink.identity.federation.saml.v2.protocol.AttributeQueryType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.NameIDPolicyType;
import org.picketlink.identity.federation.saml.v2.protocol.XACMLAuthzDecisionQueryType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAMLRequestWriter
extends BaseWriter {
    public SAMLRequestWriter(XMLStreamWriter writer) {
        super(writer);
    }

    public void write(AuthnRequestType request) throws ProcessingException {
        NameIDPolicyType nameIDPolicy;
        Element sig;
        NameIDType issuer;
        String providerName;
        Integer attrIndex;
        Integer assertionIndex;
        URI protocolBinding;
        Boolean isPassive;
        Boolean forceAuthn;
        URI assertionURL;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.AUTHN_REQUEST.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((assertionURL = request.getAssertionConsumerServiceURL()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_URL.get(), assertionURL.toASCIIString());
        }
        if ((forceAuthn = request.isForceAuthn()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FORCE_AUTHN.get(), forceAuthn.toString());
        }
        if ((isPassive = request.isIsPassive()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.IS_PASSIVE.get(), isPassive.toString());
        }
        if ((protocolBinding = request.getProtocolBinding()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.PROTOCOL_BINDING.get(), protocolBinding.toString());
        }
        if ((assertionIndex = request.getAssertionConsumerServiceIndex()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ASSERTION_CONSUMER_SERVICE_INDEX.get(), assertionIndex.toString());
        }
        if ((attrIndex = request.getAttributeConsumingServiceIndex()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ATTRIBUTE_CONSUMING_SERVICE_INDEX.get(), attrIndex.toString());
        }
        if (StringUtil.isNotNull(providerName = request.getProviderName())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.PROVIDER_NAME.get(), providerName);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((nameIDPolicy = request.getNameIDPolicy()) != null) {
            this.write(nameIDPolicy);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(LogoutRequestType logOutRequest) throws ProcessingException {
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.LOGOUT_REQUEST.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), logOutRequest.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), logOutRequest.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), logOutRequest.getIssueInstant().toString());
        URI destination = logOutRequest.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = logOutRequest.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        NameIDType issuer = logOutRequest.getIssuer();
        this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        NameIDType nameID = logOutRequest.getNameID();
        if (nameID != null) {
            this.write(nameID, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.NAMEID.get(), ASSERTION_PREFIX));
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(NameIDPolicyType nameIDPolicy) throws ProcessingException {
        Boolean allowCreate;
        String spNameQualifier;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.NAMEID_POLICY.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        URI format = nameIDPolicy.getFormat();
        if (format != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.FORMAT.get(), format.toASCIIString());
        }
        if (StringUtil.isNotNull(spNameQualifier = nameIDPolicy.getSPNameQualifier())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.SP_NAME_QUALIFIER.get(), spNameQualifier);
        }
        if ((allowCreate = nameIDPolicy.isAllowCreate()) != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ALLOW_CREATE.get(), allowCreate.toString());
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(ArtifactResolveType request) throws ProcessingException {
        String artifact;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ARTIFACT_RESOLVE.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if (StringUtil.isNotNull(artifact = request.getArtifact())) {
            StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ARTIFACT.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
            StaxUtil.writeCharacters(this.writer, artifact);
            StaxUtil.writeEndElement(this.writer);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(AttributeQueryType request) throws ProcessingException {
        SubjectType subject;
        Element sig;
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.ATTRIBUTE_QUERY.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), request.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), request.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), request.getIssueInstant().toString());
        URI destination = request.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = request.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((issuer = request.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        if ((sig = request.getSignature()) != null) {
            StaxUtil.writeDOMElement(this.writer, sig);
        }
        if ((subject = request.getSubject()) != null) {
            this.write(subject);
        }
        List attributes = request.getAttribute();
        for (AttributeType attr : attributes) {
            this.write(attr);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(XACMLAuthzDecisionQueryType xacmlQuery) throws ProcessingException {
        NameIDType issuer;
        String consent;
        StaxUtil.writeStartElement(this.writer, PROTOCOL_PREFIX, JBossSAMLConstants.REQUEST_ABSTRACT.get(), JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, PROTOCOL_PREFIX, JBossSAMLURIConstants.PROTOCOL_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, ASSERTION_PREFIX, JBossSAMLURIConstants.ASSERTION_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, XACML_SAML_PROTO_PREFIX, JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get());
        StaxUtil.writeDefaultNameSpace(this.writer, JBossSAMLURIConstants.XACML_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ID.get(), xacmlQuery.getID());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.VERSION.get(), xacmlQuery.getVersion());
        StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.ISSUE_INSTANT.get(), xacmlQuery.getIssueInstant().toString());
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get(), JBossSAMLConstants.INPUT_CONTEXT_ONLY.get(), XACML_SAML_PROTO_PREFIX), "true");
        StaxUtil.writeAttribute(this.writer, new QName(JBossSAMLURIConstants.XACML_SAML_PROTO_NSURI.get(), JBossSAMLConstants.RETURN_CONTEXT.get(), XACML_SAML_PROTO_PREFIX), "true");
        StaxUtil.writeNameSpace(this.writer, JBossSAMLURIConstants.XSI_PREFIX.get(), JBossSAMLURIConstants.XSI_NSURI.get());
        StaxUtil.writeNameSpace(this.writer, "xs", JBossSAMLURIConstants.XMLSCHEMA_NSURI.get());
        StaxUtil.writeAttribute(this.writer, JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xacml-samlp:XACMLAuthzDecisionQueryType");
        URI destination = xacmlQuery.getDestination();
        if (destination != null) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.DESTINATION.get(), destination.toASCIIString());
        }
        if (StringUtil.isNotNull(consent = xacmlQuery.getConsent())) {
            StaxUtil.writeAttribute(this.writer, JBossSAMLConstants.CONSENT.get(), consent);
        }
        if ((issuer = xacmlQuery.getIssuer()) != null) {
            this.write(issuer, new QName(JBossSAMLURIConstants.ASSERTION_NSURI.get(), JBossSAMLConstants.ISSUER.get(), ASSERTION_PREFIX));
        }
        RequestType xacmlRequest = xacmlQuery.getRequest();
        ObjectFactory of = new ObjectFactory();
        StringWriter sw = new StringWriter();
        try {
            Marshaller m = JAXBUtil.getMarshaller(RequestType.class.getPackage().getName());
            m.marshal((Object)of.createRequest(xacmlRequest), (Writer)sw);
        }
        catch (JAXBException e) {
            throw new ProcessingException(e);
        }
        try {
            Document xacmlDoc = DocumentUtil.getDocument(sw.toString());
            StaxUtil.writeDOMNode(this.writer, xacmlDoc.getDocumentElement());
        }
        catch (ConfigurationException e) {
            throw new ProcessingException(e);
        }
        catch (ParsingException e) {
            throw new ProcessingException(e);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }
}

