/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.writers;

import java.io.OutputStream;
import java.net.URI;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import org.picketlink.identity.federation.core.exceptions.ProcessingException;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.util.StaxUtil;
import org.picketlink.identity.federation.core.wstrust.wrappers.Lifetime;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityToken;
import org.picketlink.identity.federation.core.wstrust.wrappers.RequestSecurityTokenCollection;
import org.picketlink.identity.federation.core.wstrust.writers.WSPolicyWriter;
import org.picketlink.identity.federation.core.wstrust.writers.WSSecurityWriter;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.ws.addressing.EndpointReferenceType;
import org.picketlink.identity.federation.ws.policy.AppliesTo;
import org.picketlink.identity.federation.ws.trust.BinarySecretType;
import org.picketlink.identity.federation.ws.trust.CancelTargetType;
import org.picketlink.identity.federation.ws.trust.EntropyType;
import org.picketlink.identity.federation.ws.trust.OnBehalfOfType;
import org.picketlink.identity.federation.ws.trust.RenewTargetType;
import org.picketlink.identity.federation.ws.trust.UseKeyType;
import org.picketlink.identity.federation.ws.trust.ValidateTargetType;
import org.picketlink.identity.federation.ws.wss.secext.UsernameTokenType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.w3c.dom.Element;

public class WSTrustRequestWriter {
    private final XMLStreamWriter writer;

    public WSTrustRequestWriter(OutputStream out) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter(out);
    }

    public WSTrustRequestWriter(Result result) throws ProcessingException {
        this.writer = StaxUtil.getXMLStreamWriter(result);
    }

    public WSTrustRequestWriter(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public void write(RequestSecurityTokenCollection requestTokenCollection) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "RequestSecurityTokenCollection", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace(this.writer, "wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List<RequestSecurityToken> tokenList = requestTokenCollection.getRequestSecurityTokens();
        if (tokenList == null) {
            throw new ProcessingException("PL00092: Null Value:RST list is null");
        }
        for (RequestSecurityToken token : tokenList) {
            this.write(token);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    public void write(RequestSecurityToken requestToken) throws ProcessingException {
        RenewTargetType renewTarget;
        CancelTargetType cancelTarget;
        ValidateTargetType validateTarget;
        OnBehalfOfType onBehalfOf;
        UseKeyType useKeyType;
        EntropyType entropy;
        URI keyType;
        long keySize;
        AppliesTo appliesTo;
        EndpointReferenceType endpoint;
        URI tokenType;
        StaxUtil.writeStartElement(this.writer, "wst", "RequestSecurityToken", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeNameSpace(this.writer, "wst", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String context = requestToken.getContext();
        StaxUtil.writeAttribute(this.writer, "Context", context);
        URI requestType = requestToken.getRequestType();
        if (requestType != null) {
            this.writeRequestType(this.writer, requestType);
        }
        if ((tokenType = requestToken.getTokenType()) != null) {
            this.writeTokenType(this.writer, tokenType);
        }
        if ((endpoint = requestToken.getIssuer()) != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "Issuer", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeStartElement(this.writer, "wsa", "Address", "http://www.w3.org/2005/08/addressing");
            StaxUtil.writeCharacters(this.writer, endpoint.getAddress().getValue());
            StaxUtil.writeEndElement(this.writer);
            StaxUtil.writeEndElement(this.writer);
        }
        if (requestToken.getLifetime() != null) {
            Lifetime lifetime = requestToken.getLifetime();
            StaxUtil.writeStartElement(this.writer, "wst", "Lifetime", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            new WSSecurityWriter(this.writer).writeLifetime(lifetime.getCreated(), lifetime.getExpires());
            StaxUtil.writeEndElement(this.writer);
        }
        if ((appliesTo = requestToken.getAppliesTo()) != null) {
            WSPolicyWriter wsPolicyWriter = new WSPolicyWriter(this.writer);
            wsPolicyWriter.write(appliesTo);
        }
        if ((keySize = requestToken.getKeySize()) != 0L) {
            StaxUtil.writeStartElement(this.writer, "wst", "KeySize", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, Long.toString(keySize));
            StaxUtil.writeEndElement(this.writer);
        }
        if ((keyType = requestToken.getKeyType()) != null) {
            StaxUtil.writeStartElement(this.writer, "wst", "KeyType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
            StaxUtil.writeCharacters(this.writer, keyType.toString());
            StaxUtil.writeEndElement(this.writer);
        }
        if ((entropy = requestToken.getEntropy()) != null) {
            this.writeEntropyType(entropy);
        }
        if ((useKeyType = requestToken.getUseKey()) != null) {
            this.writeUseKeyType(useKeyType);
        }
        if ((onBehalfOf = requestToken.getOnBehalfOf()) != null) {
            this.writeOnBehalfOfType(onBehalfOf);
        }
        if ((validateTarget = requestToken.getValidateTarget()) != null) {
            this.writeValidateTargetType(validateTarget);
        }
        if ((cancelTarget = requestToken.getCancelTarget()) != null) {
            this.writeCancelTargetType(cancelTarget);
        }
        if ((renewTarget = requestToken.getRenewTarget()) != null) {
            this.writeRenewTargetType(renewTarget);
        }
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.flush(this.writer);
    }

    private void writeEntropyType(EntropyType entropy) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "Entropy", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List entropyList = entropy.getAny();
        if (entropyList != null) {
            for (Object entropyObj : entropyList) {
                if (!(entropyObj instanceof BinarySecretType)) continue;
                BinarySecretType binarySecret = (BinarySecretType)entropyObj;
                this.writeBinarySecretType(this.writer, binarySecret);
            }
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeUseKeyType(UseKeyType useKeyType) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "UseKey", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List theList = useKeyType.getAny();
        for (Object useKeyTypeValue : theList) {
            if (useKeyTypeValue instanceof Element) {
                Element domElement = (Element)useKeyTypeValue;
                StaxUtil.writeDOMElement(this.writer, domElement);
                continue;
            }
            if (useKeyTypeValue instanceof byte[]) {
                byte[] certificate = (byte[])useKeyTypeValue;
                StaxUtil.writeStartElement(this.writer, "ds", "X509Certificate", "http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeNameSpace(this.writer, "ds", "http://www.w3.org/2000/09/xmldsig#");
                StaxUtil.writeCharacters(this.writer, new String(certificate));
                StaxUtil.writeEndElement(this.writer);
                continue;
            }
            if (useKeyTypeValue instanceof KeyValueType) {
                this.writeKeyValueType((KeyValueType)useKeyTypeValue);
                continue;
            }
            throw new RuntimeException("PL00081: Writer: Unknown Type:" + useKeyTypeValue.getClass().getName());
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeKeyValueType(KeyValueType type) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "ds", "KeyValue", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeNameSpace(this.writer, "ds", "http://www.w3.org/2000/09/xmldsig#");
        if (type.getContent().size() == 0) {
            throw new ProcessingException("PL00092: Null Value:KeyValueType must contain at least one value");
        }
        for (Object obj : type.getContent()) {
            if (!(obj instanceof RSAKeyValueType)) continue;
            RSAKeyValueType rsaKeyValue = (RSAKeyValueType)obj;
            this.writeRSAKeyValueType(rsaKeyValue);
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeRSAKeyValueType(RSAKeyValueType type) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "dsig", "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#");
        byte[] modulus = type.getModulus();
        StaxUtil.writeStartElement(this.writer, "dsig", "Modulus", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(this.writer, new String(modulus));
        StaxUtil.writeEndElement(this.writer);
        byte[] exponent = type.getExponent();
        StaxUtil.writeStartElement(this.writer, "dsig", "Exponent", "http://www.w3.org/2000/09/xmldsig#");
        StaxUtil.writeCharacters(this.writer, new String(exponent));
        StaxUtil.writeEndElement(this.writer);
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeOnBehalfOfType(OnBehalfOfType onBehalfOf) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "OnBehalfOf", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        UsernameTokenType usernameToken = (UsernameTokenType)onBehalfOf.getAny().get(0);
        WSSecurityWriter wsseWriter = new WSSecurityWriter(this.writer);
        wsseWriter.write(usernameToken);
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeValidateTargetType(ValidateTargetType validateTarget) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "ValidateTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List list = validateTarget.getAny();
        for (Object validateTargetObj : list) {
            if (validateTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)validateTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (validateTargetObj instanceof Element) {
                StaxUtil.writeDOMElement(this.writer, (Element)validateTargetObj);
                continue;
            }
            throw new ProcessingException("PL00081: Writer: Unknown Type:Unknown validate target type=" + validateTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeRenewTargetType(RenewTargetType renewTarget) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "RenewTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List list = renewTarget.getAny();
        for (Object renewTargetObj : list) {
            if (renewTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)renewTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (renewTargetObj instanceof Element) {
                StaxUtil.writeDOMElement(this.writer, (Element)renewTargetObj);
                continue;
            }
            throw new ProcessingException("PL00081: Writer: Unknown Type:Unknown renew target type=" + renewTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeCancelTargetType(CancelTargetType cancelTarget) throws ProcessingException {
        StaxUtil.writeStartElement(this.writer, "wst", "CancelTarget", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        List list = cancelTarget.getAny();
        for (Object cancelTargetObj : list) {
            if (cancelTargetObj instanceof AssertionType) {
                AssertionType assertion = (AssertionType)cancelTargetObj;
                SAMLAssertionWriter samlAssertionWriter = new SAMLAssertionWriter(this.writer);
                samlAssertionWriter.write(assertion);
                continue;
            }
            if (cancelTargetObj instanceof Element) {
                StaxUtil.writeDOMElement(this.writer, (Element)cancelTargetObj);
                continue;
            }
            throw new ProcessingException("PL00081: Writer: Unknown Type:Unknown cancel target type=" + cancelTargetObj.getClass().getName());
        }
        StaxUtil.writeEndElement(this.writer);
    }

    private void writeBinarySecretType(XMLStreamWriter writer, BinarySecretType binarySecret) throws ProcessingException {
        StaxUtil.writeStartElement(writer, "wst", "BinarySecret", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        String type = binarySecret.getType();
        StaxUtil.writeAttribute(writer, "Type", type);
        StaxUtil.writeCharacters(writer, new String(binarySecret.getValue()));
        StaxUtil.writeEndElement(writer);
    }

    private void writeRequestType(XMLStreamWriter writer, URI uri) throws ProcessingException {
        StaxUtil.writeStartElement(writer, "wst", "RequestType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeCharacters(writer, uri.toASCIIString());
        StaxUtil.writeEndElement(writer);
    }

    private void writeTokenType(XMLStreamWriter writer, URI uri) throws ProcessingException {
        StaxUtil.writeStartElement(writer, "wst", "TokenType", "http://docs.oasis-open.org/ws-sx/ws-trust/200512");
        StaxUtil.writeCharacters(writer, uri.toASCIIString());
        StaxUtil.writeEndElement(writer);
    }
}

