/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.filters;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.AssertionExpiredException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.sig.SAML2Signature;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AuthenticationStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11StatementAbstractType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.filters.SecurityActions;
import org.picketlink.identity.federation.web.interfaces.IRoleValidator;
import org.picketlink.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.picketlink.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.picketlink.identity.federation.web.roles.DefaultRoleValidator;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.HTTPRedirectUtil;
import org.picketlink.identity.federation.web.util.PostBindingUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SPFilter
implements Filter {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String ISSUER_ID = "ISSUER_ID";
    public static final String DESIRED_IDP = "picketlink.desired.idp";
    public static final String CHARACTER_ENCODING = "CHARACTER_ENCODING";
    public static final String CONFIGURATION_PROVIDER = "CONFIGURATION_PROVIDER";
    public static final String SAML_HANDLER_CHAIN_CLASS = "SAML_HANDLER_CHAIN_CLASS";
    private final boolean trace = logger.isTraceEnabled();
    protected SPType spConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    protected String configFile;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected transient String samlHandlerChainClass = null;
    private TrustKeyManager keyManager;
    private ServletContext servletContext = null;
    private transient SAML2HandlerChain chain = null;
    protected boolean ignoreSignatures = false;
    private IRoleValidator roleValidator = new DefaultRoleValidator();
    private String logOutPage = "/logout.jsp";
    protected String canonicalizationMethod = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    protected volatile PicketLinkAuditHelper auditHelper = null;
    protected volatile String issuerID = null;
    protected IDPSSODescriptorType idpMetadata;
    protected Lock chainLock = new ReentrantLock();
    private String characterEncoding;
    protected SAMLConfigurationProvider configProvider = null;
    private Map<String, Object> chainConfigOptions;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = this.createHttpServletRequestWrapper((HttpServletRequest)servletRequest);
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        try {
            String characterEncoding = this.getCharacterEncoding();
            if (characterEncoding != null) {
                request.setCharacterEncoding(characterEncoding);
            }
            HttpSession session = request.getSession(true);
            boolean localLogout = this.isLocalLogout(request);
            if (localLogout) {
                try {
                    this.sendToLogoutPage(request, response, session);
                }
                catch (ServletException e) {
                    logger.samlLogoutError((Throwable)e);
                    throw new IOException(e);
                }
                return;
            }
            String samlRequest = request.getParameter("SAMLRequest");
            String samlResponse = request.getParameter("SAMLResponse");
            Principal principal = request.getUserPrincipal();
            if (!(principal == null || this.isGlobalLogout(request) || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
                    this.generalUserRequest(request, response);
                }
                if (StringUtil.isNotNull((String)samlResponse)) {
                    this.handleSAMLResponse(request, response);
                }
                if (StringUtil.isNotNull((String)samlRequest)) {
                    this.handleSAMLRequest(request, response);
                }
                if ((principal = (request = this.createHttpServletRequestWrapper((HttpServletRequest)servletRequest)).getUserPrincipal()) != null && !response.isCommitted()) {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    this.localAuthentication(request, response);
                }
            }
        }
        catch (IOException e) {
            SPType configuration = this.getConfiguration();
            if (StringUtil.isNotNull((String)configuration.getErrorPage())) {
                try {
                    request.getRequestDispatcher(configuration.getErrorPage()).forward((ServletRequest)request, (ServletResponse)response);
                }
                catch (ServletException e1) {
                    logger.samlErrorPageForwardError(configuration.getErrorPage(), (Throwable)e1);
                }
                response.setStatus(500);
            }
            throw e;
        }
    }

    private HttpServletRequest createHttpServletRequestWrapper(HttpServletRequest request) {
        return new HttpServletRequestWrapper(request){

            public Principal getUserPrincipal() {
                HttpSession session = this.getSession(false);
                if (session != null) {
                    return (Principal)session.getAttribute("picketlink.principal");
                }
                return super.getUserPrincipal();
            }
        };
    }

    private String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.processConfiguration(filterConfig);
    }

    private AuthnRequestType createSAMLRequest(String serviceURL, String identityURL) throws ConfigurationException {
        if (serviceURL == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:serviceURL");
        }
        if (identityURL == null) {
            throw new IllegalArgumentException("PL00078: Null Parameter:identityURL");
        }
        SAML2Request saml2Request = new SAML2Request();
        String id = IDGenerator.create("ID_");
        return saml2Request.createAuthnRequestType(id, serviceURL, identityURL, serviceURL);
    }

    protected void sendToDestination(Document samlDocument, String relayState, String destination, HttpServletResponse response, boolean request) throws IOException, SAXException, GeneralSecurityException {
        if (!this.ignoreSignatures) {
            SAML2Signature samlSignature = new SAML2Signature();
            Node nextSibling = samlSignature.getNextSiblingOfIssuer(samlDocument);
            if (nextSibling != null) {
                samlSignature.setNextSibling(nextSibling);
            }
            KeyPair keypair = this.keyManager.getSigningKeyPair();
            samlSignature.signSAMLDocument(samlDocument, keypair);
        }
        String samlMessage = PostBindingUtil.base64Encode(DocumentUtil.getDocumentAsString((Document)samlDocument));
        PostBindingUtil.sendPost(new DestinationInfoHolder(destination, samlMessage, relayState), response, request);
    }

    private boolean handleSAMLResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.validate(request)) {
            throw new IOException("PL00019: Validation check failed");
        }
        String samlVersion = this.getSAMLVersion(request);
        if (!JBossSAMLConstants.VERSION_2_0.get().equals(samlVersion)) {
            return this.handleSAML11UnsolicitedResponse(request, response);
        }
        return this.handleSAML2Response(request, response);
    }

    private boolean isLocalLogout(HttpServletRequest request) {
        String lloStr = request.getParameter("LLO");
        return StringUtil.isNotNull((String)lloStr) && "true".equalsIgnoreCase(lloStr);
    }

    protected void sendToLogoutPage(HttpServletRequest request, HttpServletResponse response, HttpSession session) throws IOException, ServletException {
        RequestDispatcher dispatch = this.servletContext.getRequestDispatcher(this.getConfiguration().getLogOutPage());
        if (dispatch == null) {
            logger.samlSPCouldNotDispatchToLogoutPage(this.getConfiguration().getLogOutPage());
        } else {
            logger.trace("Forwarding request to logOutPage: " + this.getConfiguration().getLogOutPage());
            try {
                session.invalidate();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            try {
                dispatch.forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception e) {
                dispatch.forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private SPType getConfiguration() {
        return (SPType)this.picketLinkConfiguration.getIdpOrSP();
    }

    private boolean isGlobalLogout(HttpServletRequest request) {
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    private boolean generalUserRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        boolean willSendRequest = false;
        HTTPContext httpContext = new HTTPContext(request, response, this.servletContext);
        Set<SAML2Handler> handlers = this.chain.handlers();
        boolean postBinding = this.getConfiguration().getBindingType().equals("POST");
        SAML2HandlerResponse saml2HandlerResponse = null;
        try {
            String idp;
            ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(postBinding, this.serviceURL, this.picketLinkConfiguration, this.idpMetadata);
            if (this.issuerID != null) {
                baseProcessor.setIssuer(this.issuerID);
            }
            if (StringUtil.isNotNull((String)(idp = (String)request.getAttribute(DESIRED_IDP)))) {
                baseProcessor.setIdentityURL(idp);
            } else {
                baseProcessor.setIdentityURL(this.getIdentityURL());
            }
            baseProcessor.setAuditHelper(this.auditHelper);
            saml2HandlerResponse = baseProcessor.process(httpContext, handlers, this.chainLock);
        }
        catch (ProcessingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ParsingException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        catch (ConfigurationException pe) {
            logger.samlSPHandleRequestError((Throwable)pe);
            throw new RuntimeException(pe);
        }
        willSendRequest = saml2HandlerResponse.getSendRequest();
        Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
        String relayState = saml2HandlerResponse.getRelayState();
        String destination = saml2HandlerResponse.getDestination();
        String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
        if (destination != null && samlResponseDocument != null) {
            try {
                if (this.isEnableAudit()) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.REQUEST_TO_IDP);
                    auditEvent.setWhoIsAuditing(this.getContextPath());
                    this.auditHelper.audit(auditEvent);
                }
                this.sendRequestToIDP(destination, samlResponseDocument, relayState, request, response, willSendRequest, destinationQueryStringWithSignature);
                return false;
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw logger.samlSPProcessingExceptionError((Throwable)e);
            }
        }
        return this.localAuthentication(request, response);
    }

    private String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getIdentityURL() {
        return this.getConfiguration().getIdentityURL();
    }

    private boolean isEnableAudit() {
        return this.picketLinkConfiguration.isEnableAudit();
    }

    protected void sendRequestToIDP(String destination, Document samlDocument, String relayState, HttpServletRequest request, HttpServletResponse response, boolean willSendRequest, String destinationQueryStringWithSignature) throws ProcessingException, ConfigurationException, IOException {
        if (this.isAjaxRequest(request) && request.getUserPrincipal() == null) {
            response.sendError(403);
        } else if (this.isHttpPostBinding()) {
            this.sendHttpPostBindingRequest(destination, samlDocument, relayState, response, willSendRequest);
        } else {
            this.sendHttpRedirectRequest(destination, samlDocument, relayState, response, willSendRequest, destinationQueryStringWithSignature);
        }
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader("X-Requested-With");
        return requestedWithHeader != null && "XMLHttpRequest".equalsIgnoreCase(requestedWithHeader);
    }

    protected boolean isHttpPostBinding() {
        return this.getBinding().equalsIgnoreCase("POST");
    }

    protected void sendHttpPostBindingRequest(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest) throws ProcessingException, IOException, ConfigurationException {
        String samlMessage = PostBindingUtil.base64Encode(DocumentUtil.getDocumentAsString((Document)samlDocument));
        DestinationInfoHolder destinationHolder = new DestinationInfoHolder(destination, samlMessage, relayState);
        PostBindingUtil.sendPost(destinationHolder, response, willSendRequest);
    }

    protected void sendHttpRedirectRequest(String destination, Document samlDocument, String relayState, HttpServletResponse response, boolean willSendRequest, String destinationQueryStringWithSignature) throws IOException, ProcessingException, ConfigurationException {
        String destinationQueryString = null;
        if (destinationQueryStringWithSignature != null) {
            destinationQueryString = destinationQueryStringWithSignature;
        } else {
            String samlMessage = DocumentUtil.getDocumentAsString((Document)samlDocument);
            String base64Request = RedirectBindingUtil.deflateBase64URLEncode(samlMessage.getBytes("UTF-8"));
            destinationQueryString = RedirectBindingUtil.getDestinationQueryString(base64Request, relayState, willSendRequest);
        }
        RedirectBindingUtil.RedirectBindingUtilDestHolder holder = new RedirectBindingUtil.RedirectBindingUtilDestHolder();
        holder.setDestination(destination).setDestinationQueryString(destinationQueryString);
        HTTPRedirectUtil.sendRedirectForRequestor(RedirectBindingUtil.getDestinationURL(holder), response);
    }

    protected String getBinding() {
        return this.getConfiguration().getBindingType();
    }

    protected boolean localAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return true;
    }

    protected boolean validate(HttpServletRequest request) {
        return request.getParameter("SAMLResponse") != null;
    }

    private String getSAMLVersion(HttpServletRequest request) {
        String version;
        String samlResponse = request.getParameter("SAMLResponse");
        try {
            Document samlDocument = this.toSAMLResponseDocument(samlResponse, "POST".equalsIgnoreCase(request.getMethod()));
            Element element = samlDocument.getDocumentElement();
            version = element.getAttribute("Version");
            if (StringUtil.isNullOrEmpty((String)version)) {
                String minorVersion = element.getAttribute("MinorVersion");
                String majorVersion = element.getAttribute("MajorVersion");
                version = minorVersion + "." + majorVersion;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not extract version from SAML Response.", e);
        }
        return version;
    }

    private Document toSAMLResponseDocument(String samlResponse, boolean isPostBinding) throws ParsingException {
        InputStream dataStream = null;
        dataStream = isPostBinding ? PostBindingUtil.base64DecodeAsStream(samlResponse) : RedirectBindingUtil.base64DeflateDecode(samlResponse);
        try {
            return DocumentUtil.getDocument((InputStream)dataStream);
        }
        catch (Exception e) {
            logger.samlResponseFromIDPParsingFailed();
            throw new ParsingException("", (Throwable)e);
        }
    }

    public boolean handleSAML11UnsolicitedResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            return true;
        }
        HttpSession session = request.getSession(true);
        if (StringUtil.isNotNull((String)samlResponse)) {
            boolean isValid = false;
            try {
                isValid = this.validate(request);
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
                throw new IOException();
            }
            if (!isValid) {
                throw new IOException("PL00019: Validation check failed");
            }
            try {
                InputStream base64DecodedResponse = null;
                base64DecodedResponse = "GET".equalsIgnoreCase(request.getMethod()) ? RedirectBindingUtil.base64DeflateDecode(samlResponse) : PostBindingUtil.base64DecodeAsStream(samlResponse);
                SAMLParser parser = new SAMLParser();
                SAML11ResponseType saml11Response = (SAML11ResponseType)parser.parse(base64DecodedResponse);
                List<SAML11AssertionType> assertions = saml11Response.get();
                if (assertions.size() > 1) {
                    logger.trace("More than one assertion from IDP. Considering the first one.");
                }
                String username = null;
                List<Object> roles = new ArrayList();
                SAML11AssertionType assertion = assertions.get(0);
                if (assertion != null) {
                    List<SAML11StatementAbstractType> statements = assertion.getStatements();
                    for (SAML11StatementAbstractType statement : statements) {
                        if (!(statement instanceof SAML11AuthenticationStatementType)) continue;
                        SAML11AuthenticationStatementType subStat = (SAML11AuthenticationStatementType)statement;
                        SAML11SubjectType subject = subStat.getSubject();
                        username = subject.getChoice().getNameID().getValue();
                    }
                    roles = AssertionUtil.getRoles(assertion, null);
                }
                return true;
            }
            catch (Exception e) {
                logger.samlSPHandleRequestError((Throwable)e);
            }
        }
        return false;
    }

    private boolean handleSAML2Response(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(true);
        String samlResponse = request.getParameter("SAMLResponse");
        HTTPContext httpContext = new HTTPContext(request, response, this.servletContext);
        Set<SAML2Handler> handlers = this.chain.handlers();
        Principal principal = request.getUserPrincipal();
        try {
            ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration, this.idpMetadata);
            if (this.auditHelper != null) {
                responseProcessor.setAuditHelper(this.auditHelper);
            }
            responseProcessor.setTrustKeyManager(this.keyManager);
            SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers, this.chainLock);
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            String relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            boolean willSendRequest = saml2HandlerResponse.getSendRequest();
            String destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            if (destination == null || samlResponseDocument == null) {
                boolean sessionValidity;
                boolean bl = sessionValidity = request.getUserPrincipal() != null;
                if (!sessionValidity) {
                    this.sendToLogoutPage(request, response, session);
                    return false;
                }
                List<String> roles = saml2HandlerResponse.getRoles();
                if (principal == null) {
                    principal = (Principal)session.getAttribute("picketlink.principal");
                }
                if (principal == null) {
                    throw new RuntimeException("PL00092: Null Value: principal");
                }
                if (this.isEnableAudit()) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_FROM_IDP);
                    auditEvent.setSubjectName(principal.getName());
                    auditEvent.setWhoIsAuditing(this.getContextPath());
                    this.auditHelper.audit(auditEvent);
                }
                return true;
            }
            this.sendRequestToIDP(destination, samlResponseDocument, relayState, request, response, willSendRequest, destinationQueryStringWithSignature);
        }
        catch (ProcessingException pe) {
            Throwable t = pe.getCause();
            if (t != null && t instanceof AssertionExpiredException) {
                logger.error("Assertion has expired. Asking IDP for reissue");
                if (this.isEnableAudit()) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.EXPIRED_ASSERTION);
                    auditEvent.setAssertionID(((AssertionExpiredException)t).getId());
                    this.auditHelper.audit(auditEvent);
                }
                return this.generalUserRequest(request, response);
            }
            logger.samlSPHandleRequestError((Throwable)pe);
            throw logger.samlSPProcessingExceptionError((Throwable)pe);
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(request, response);
    }

    private void processIdPMetadata(SPType spConfiguration) {
        IDPSSODescriptorType idpssoDescriptorType = null;
        idpssoDescriptorType = StringUtil.isNotNull((String)spConfiguration.getIdpMetadataFile()) ? this.getIdpMetadataFromFile(spConfiguration) : this.getIdpMetadataFromProvider(spConfiguration);
        if (idpssoDescriptorType != null) {
            List<EndpointType> endpoints = idpssoDescriptorType.getSingleSignOnService();
            for (EndpointType endpoint : endpoints) {
                String endpointBinding = endpoint.getBinding().toString();
                if (endpointBinding.contains("HTTP-POST")) {
                    endpointBinding = "POST";
                } else if (endpointBinding.contains("HTTP-Redirect")) {
                    endpointBinding = "REDIRECT";
                }
                if (!spConfiguration.getBindingType().equals(endpointBinding)) continue;
                spConfiguration.setIdentityURL(endpoint.getLocation().toString());
                break;
            }
            this.idpMetadata = idpssoDescriptorType;
        }
    }

    private IDPSSODescriptorType getIdpMetadataFromProvider(SPType spConfiguration) {
        List<EntityDescriptorType> entityDescriptors = CoreConfigUtil.getMetadataConfiguration((ProviderType)spConfiguration, this.servletContext);
        if (entityDescriptors != null) {
            for (EntityDescriptorType entityDescriptorType : entityDescriptors) {
                IDPSSODescriptorType idpssoDescriptorType = this.handleMetadata(entityDescriptorType);
                if (idpssoDescriptorType == null) continue;
                return idpssoDescriptorType;
            }
        }
        return null;
    }

    protected IDPSSODescriptorType handleMetadata(EntitiesDescriptorType entities) {
        Object entityDescriptor;
        IDPSSODescriptorType idpSSO = null;
        List<Object> entityDescs = entities.getEntityDescriptor();
        Iterator<Object> iterator = entityDescs.iterator();
        while (iterator.hasNext() && (idpSSO = (entityDescriptor = iterator.next()) instanceof EntitiesDescriptorType ? this.getIDPSSODescriptor(entities) : this.handleMetadata((EntityDescriptorType)entityDescriptor)) == null) {
        }
        return idpSSO;
    }

    protected IDPSSODescriptorType handleMetadata(EntityDescriptorType entityDescriptor) {
        return CoreConfigUtil.getIDPDescriptor(entityDescriptor);
    }

    protected IDPSSODescriptorType getIDPSSODescriptor(EntitiesDescriptorType entities) {
        List<Object> entityDescs = entities.getEntityDescriptor();
        Iterator<Object> iterator = entityDescs.iterator();
        if (iterator.hasNext()) {
            Object entityDescriptor = iterator.next();
            if (entityDescriptor instanceof EntitiesDescriptorType) {
                return this.getIDPSSODescriptor((EntitiesDescriptorType)entityDescriptor);
            }
            return CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)entityDescriptor);
        }
        return null;
    }

    protected IDPSSODescriptorType getIdpMetadataFromFile(SPType configuration) {
        InputStream is = this.servletContext.getResourceAsStream(configuration.getIdpMetadataFile());
        if (is == null) {
            return null;
        }
        Object metadata = null;
        try {
            Document samlDocument = DocumentUtil.getDocument((InputStream)is);
            SAMLParser parser = new SAMLParser();
            metadata = parser.parse(DocumentUtil.getNodeAsStream((Node)samlDocument));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IDPSSODescriptorType idpSSO = null;
        if (metadata instanceof EntitiesDescriptorType) {
            EntitiesDescriptorType entities = (EntitiesDescriptorType)metadata;
            idpSSO = this.handleMetadata(entities);
        } else {
            idpSSO = this.handleMetadata((EntityDescriptorType)metadata);
        }
        if (idpSSO == null) {
            logger.samlSPUnableToGetIDPDescriptorFromMetadata();
            return idpSSO;
        }
        return idpSSO;
    }

    private boolean handleSAMLRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String samlRequest = request.getParameter("SAMLRequest");
        HTTPContext httpContext = new HTTPContext(request, response, this.servletContext);
        Set<SAML2Handler> handlers = this.chain.handlers();
        try {
            ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(request.getMethod().equals("POST"), this.serviceURL, this.picketLinkConfiguration, this.idpMetadata);
            requestProcessor.setTrustKeyManager(this.keyManager);
            boolean result = requestProcessor.process(samlRequest, httpContext, handlers, this.chainLock);
            if (this.isEnableAudit()) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.REQUEST_FROM_IDP);
                auditEvent.setWhoIsAuditing(this.getContextPath());
                this.auditHelper.audit(auditEvent);
            }
            if (response.isCommitted()) {
                return false;
            }
            if (result) {
                return result;
            }
        }
        catch (Exception e) {
            logger.samlSPHandleRequestError((Throwable)e);
            throw logger.samlSPProcessingExceptionError((Throwable)e);
        }
        return this.localAuthentication(request, response);
    }

    protected void processConfiguration(FilterConfig filterConfig) {
        InputStream is;
        if (StringUtil.isNullOrEmpty((String)this.configFile)) {
            is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink.xml");
        } else {
            try {
                is = new FileInputStream(this.configFile);
            }
            catch (FileNotFoundException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        String configurationProviderName = filterConfig.getInitParameter(CONFIGURATION_PROVIDER);
        if (configurationProviderName != null) {
            try {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), configurationProviderName);
                if (clazz == null) {
                    throw new ClassNotFoundException("PL00085: Class Not Loaded:" + configurationProviderName);
                }
                this.configProvider = (SAMLConfigurationProvider)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create configuration provider [" + configurationProviderName + "].", e);
            }
        }
        try {
            String sysProp;
            Boolean enableAudit;
            PicketLinkType picketLinkType;
            if (this.configProvider != null) {
                try {
                    if (is == null) {
                        is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                        if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                            ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                        }
                    } else if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                        ((AbstractSAMLConfigurationProvider)this.configProvider).setConsolidatedConfigFile(is);
                    }
                    picketLinkType = this.configProvider.getPicketLinkConfiguration();
                    picketLinkType.setIdpOrSP((ProviderType)this.configProvider.getSPConfiguration());
                }
                catch (ProcessingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
                catch (ParsingException e) {
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else if (is != null) {
                try {
                    picketLinkType = ConfigurationUtil.getConfiguration(is);
                }
                catch (ParsingException e) {
                    logger.trace((Throwable)e);
                    throw logger.samlSPConfigurationError((Throwable)e);
                }
            } else {
                is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw logger.configurationFileMissing(this.configFile);
                }
                picketLinkType = new PicketLinkType();
                picketLinkType.setIdpOrSP((ProviderType)ConfigurationUtil.getSPConfiguration(is));
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (!(enableAudit = Boolean.valueOf(picketLinkType.isEnableAudit())).booleanValue() && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
                enableAudit = Boolean.parseBoolean(sysProp);
            }
            if (enableAudit.booleanValue() && this.auditHelper == null) {
                String securityDomainName = PicketLinkAuditHelper.getSecurityDomainName(this.servletContext);
                this.auditHelper = new PicketLinkAuditHelper(securityDomainName);
            }
            SPType spConfiguration = (SPType)picketLinkType.getIdpOrSP();
            this.processIdPMetadata(spConfiguration);
            this.serviceURL = spConfiguration.getServiceURL();
            this.canonicalizationMethod = spConfiguration.getCanonicalizationMethod();
            this.picketLinkConfiguration = picketLinkType;
            this.issuerID = filterConfig.getInitParameter(ISSUER_ID);
            this.characterEncoding = filterConfig.getInitParameter(CHARACTER_ENCODING);
            this.samlHandlerChainClass = filterConfig.getInitParameter(SAML_HANDLER_CHAIN_CLASS);
            logger.samlSPSettingCanonicalizationMethod(this.canonicalizationMethod);
            XMLSignatureUtil.setCanonicalizationMethodType(this.canonicalizationMethod);
            try {
                this.initKeyProvider();
                this.initializeHandlerChain(picketLinkType);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            logger.trace("Identity Provider URL=" + this.getConfiguration().getIdentityURL());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initKeyProvider() {
        if (!this.doSupportSignature()) {
            return;
        }
        SPType configuration = this.getConfiguration();
        KeyProviderType keyProvider = configuration.getKeyProvider();
        if (keyProvider == null && this.doSupportSignature()) {
            throw new RuntimeException("PL00092: Null Value:KeyProvider is null for context=" + this.getContextPath());
        }
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("PL00092: Null Value:KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(this.getClass(), keyManagerClassName);
            if (clazz == null) {
                throw new ClassNotFoundException("PL00085: Class Not Loaded:" + keyManagerClassName);
            }
            TrustKeyManager keyManager = (TrustKeyManager)clazz.newInstance();
            List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
            keyManager.setAuthProperties(authProperties);
            keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            String identityURL = configuration.getIdentityURL();
            if (authProperties != null) {
                for (AuthPropertyType authPropertyType : authProperties) {
                    String key = authPropertyType.getKey();
                    if (!"X509CERTIFICATE".equals(key)) continue;
                    keyManager.addAdditionalOption("X509CERTIFICATE", authPropertyType.getValue());
                    break;
                }
            }
            keyManager.addAdditionalOption("idp.key", new URL(identityURL).getHost());
            this.keyManager = keyManager;
        }
        catch (Exception e) {
            logger.trustKeyManagerCreationError((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        logger.trace("Key Provider=" + keyProvider.getClassName());
    }

    protected boolean doSupportSignature() {
        return this.getConfiguration().isSupportsSignature();
    }

    protected void initializeHandlerChain(PicketLinkType picketLinkType) throws Exception {
        SAML2HandlerChain handlerChain;
        if (StringUtil.isNullOrEmpty((String)this.samlHandlerChainClass)) {
            handlerChain = SAML2HandlerChainFactory.createChain();
        } else {
            try {
                handlerChain = SAML2HandlerChainFactory.createChain(this.samlHandlerChainClass);
            }
            catch (ProcessingException e1) {
                throw new RuntimeException(e1);
            }
        }
        Handlers handlers = picketLinkType.getHandlers();
        if (handlers == null) {
            String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
            handlers = ConfigurationUtil.getHandlers(this.servletContext.getResourceAsStream(handlerConfigFileName));
        }
        picketLinkType.setHandlers(handlers);
        handlerChain.addAll(HandlerUtil.getHandlers(handlers));
        this.populateChainConfig(picketLinkType);
        DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(this.chainConfigOptions);
        Set<SAML2Handler> samlHandlers = handlerChain.handlers();
        for (SAML2Handler handler : samlHandlers) {
            handler.initChainConfig(handlerChainConfig);
        }
        this.chain = handlerChain;
    }

    protected void populateChainConfig(PicketLinkType picketLinkType) throws ConfigurationException, ProcessingException {
        HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
        chainConfigOptions.put("CONFIGURATION", picketLinkType.getIdpOrSP());
        chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
        if (this.doSupportSignature()) {
            chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            String certificateAlias = (String)this.keyManager.getAdditionalOption("X509CERTIFICATE");
            if (certificateAlias != null) {
                chainConfigOptions.put("X509CERTIFICATE", this.keyManager.getCertificate(certificateAlias));
            }
        }
        this.chainConfigOptions = chainConfigOptions;
    }
}

