/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.NamedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.common.properties.query.TypedPropertyCriteria;
import org.picketlink.common.reflection.Reflections;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.ldap.internal.LDAPUtil;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.model.annotation.AttributeProperty;
import org.picketlink.idm.query.AttributeParameter;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.query.RelationshipQuery;
import org.picketlink.idm.query.RelationshipQueryParameter;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@CredentialHandlers(value={LDAPPlainTextPasswordCredentialHandler.class})
public class LDAPIdentityStore
extends AbstractIdentityStore<LDAPIdentityStoreConfiguration>
implements CredentialStore<LDAPIdentityStoreConfiguration> {
    private LDAPOperationManager operationManager;

    @Override
    public void setup(LDAPIdentityStoreConfiguration config) {
        super.setup(config);
        if (config.isActiveDirectory()) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapActiveDirectoryConfiguration();
        }
        try {
            this.operationManager = new LDAPOperationManager((LDAPIdentityStoreConfiguration)this.getConfig());
        }
        catch (NamingException e) {
            throw IDMInternalMessages.MESSAGES.storeLdapCouldNotCreateContext(e);
        }
    }

    @Override
    public void addAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.addRelationship((Relationship)attributedType);
        } else {
            this.operationManager.createSubContext(this.getBindingDN(attributedType), this.extractAttributes(attributedType, true));
            this.addToParentAsMember(attributedType);
            attributedType.setId(this.getEntryIdentifier(attributedType));
        }
    }

    @Override
    public void updateAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            IDMInternalLog.LDAP_STORE_LOGGER.ldapRelationshipUpdateNotSupported(attributedType);
        } else {
            BasicAttributes updatedAttributes = this.extractAttributes(attributedType, false);
            NamingEnumeration<Attribute> attributes = updatedAttributes.getAll();
            try {
                while (attributes.hasMore()) {
                    this.operationManager.modifyAttribute(this.getBindingDN(attributedType), attributes.next());
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not update attributes.", (Throwable)ne);
            }
            finally {
                this.safeClose(attributes);
            }
        }
    }

    @Override
    public void removeAttributedType(IdentityContext context, AttributedType attributedType) {
        if (Relationship.class.isInstance(attributedType)) {
            this.removeRelationship((Relationship)attributedType);
        } else {
            this.operationManager.removeEntryById(this.getBaseDN(attributedType), attributedType.getId());
        }
    }

    @Override
    protected void removeFromRelationships(IdentityContext context, IdentityType identityType) {
        String bindingDN = this.getBindingDN((AttributedType)identityType);
        for (LDAPMappingConfiguration relationshipConfig : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
            for (String attributeName : relationshipConfig.getMappedProperties().values()) {
                StringBuilder filter = new StringBuilder();
                filter.append("(&(").append(attributeName).append("=").append("").append(bindingDN).append("))");
                NamingEnumeration<SearchResult> search = null;
                try {
                    search = this.operationManager.search(this.getMappingConfig(relationshipConfig.getRelatedAttributedType()).getBaseDN(), filter.toString(), this.getMappingConfig(relationshipConfig.getRelatedAttributedType()));
                    while (search.hasMore()) {
                        SearchResult result = search.next();
                        Attributes attributes = result.getAttributes();
                        Attribute relationshipAttribute = attributes.get(attributeName);
                        if (relationshipAttribute == null || !relationshipAttribute.contains(bindingDN)) continue;
                        relationshipAttribute.remove(bindingDN);
                        if (relationshipAttribute.size() == 0) {
                            relationshipAttribute.add(this.getEmptyAttributeValue());
                        }
                        this.operationManager.modifyAttribute(result.getNameInNamespace(), relationshipAttribute);
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    this.safeClose(search);
                }
            }
        }
    }

    public <V extends IdentityType> List<V> fetchQueryResults(IdentityContext context, IdentityQuery<V> identityQuery) {
        LDAPMappingConfiguration ldapEntryConfig;
        StringBuilder filter;
        ArrayList<IdentityType> results = new ArrayList<IdentityType>();
        if (identityQuery.getParameter(IdentityType.ID) != null) {
            Object[] queryParameterValues = identityQuery.getParameter(IdentityType.ID);
            NamingEnumeration<SearchResult> search = this.lookupEntryByID(queryParameterValues[0].toString(), ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), null);
            try {
                while (search.hasMore()) {
                    results.add((IdentityType)this.populateAttributedType(context, search.next(), null));
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not create identity type from LDAP entry.", (Throwable)ne);
            }
            finally {
                this.safeClose(search);
            }
            return results;
        }
        if (!IdentityType.class.equals((Object)identityQuery.getIdentityType()) && (filter = this.createIdentityTypeSearchFilter(identityQuery, ldapEntryConfig = this.getMappingConfig(identityQuery.getIdentityType()))).length() != 0) {
            NamingEnumeration<SearchResult> search = null;
            try {
                search = this.operationManager.search(this.getBaseDN(ldapEntryConfig), filter.toString(), ldapEntryConfig);
                while (search.hasMoreElements()) {
                    IdentityType type = (IdentityType)this.populateAttributedType(context, (SearchResult)search.nextElement(), null);
                    if (type == null) continue;
                    results.add(type);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not query identity types.", (Throwable)e);
            }
            finally {
                this.safeClose(search);
            }
        }
        return results;
    }

    public <V extends Relationship> List<V> fetchQueryResults(IdentityContext context, RelationshipQuery<V> query) {
        ArrayList<V> results = new ArrayList<V>();
        if (Relationship.class.equals((Object)query.getRelationshipClass())) {
            for (LDAPMappingConfiguration configuration : ((LDAPIdentityStoreConfiguration)this.getConfig()).getRelationshipConfigs()) {
                results.addAll(this.fetchRelationships(context, query, configuration));
            }
        } else {
            results.addAll(this.fetchRelationships(context, query, this.getMappingConfig(query.getRelationshipClass())));
        }
        return results;
    }

    private String getRelationshipMappedProperty(Class<? extends IdentityType> identityType, LDAPMappingConfiguration mappingConfig) {
        Property property = PropertyQueries.createQuery((Class)mappingConfig.getMappedClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(identityType, TypedPropertyCriteria.MatchOption.ALL)).getFirstResult();
        if (property == null) {
            return null;
        }
        return (String)mappingConfig.getMappedProperties().get(property.getName());
    }

    private <V extends Relationship> List<V> fetchRelationships(IdentityContext context, RelationshipQuery<V> query, LDAPMappingConfiguration mappingConfig) {
        ArrayList<Relationship> results = new ArrayList<Relationship>();
        Class relationshipClass = mappingConfig.getMappedClass();
        Map parameters = query.getParameters();
        LDAPMappingConfiguration relatedTypeConfig = this.getMappingConfig(mappingConfig.getRelatedAttributedType());
        StringBuilder filter = new StringBuilder();
        filter.append("(&").append((CharSequence)this.getObjectClassesFilter(relatedTypeConfig));
        ArrayList<String> entriesToFilter = new ArrayList<String>();
        for (QueryParameter queryParameter : parameters.keySet()) {
            Object[] values = (Object[])parameters.get(queryParameter);
            RelationshipQueryParameter relationshipQueryParameter = null;
            String attributeName = null;
            if (RelationshipQueryParameter.class.isInstance(queryParameter)) {
                relationshipQueryParameter = (RelationshipQueryParameter)queryParameter;
                attributeName = (String)mappingConfig.getMappedProperties().get(relationshipQueryParameter.getName());
            } else {
                if (!Relationship.IDENTITY.equals(queryParameter)) continue;
                IdentityType identityType = (IdentityType)values[0];
                if (!mappingConfig.getRelatedAttributedType().isInstance(identityType)) {
                    attributeName = this.getRelationshipMappedProperty(identityType.getClass(), mappingConfig);
                }
            }
            for (Object value : values) {
                Property property;
                AttributedType attributedType = (AttributedType)value;
                if (!((LDAPIdentityStoreConfiguration)this.getConfig()).supportsType(attributedType.getClass(), IdentityStoreConfiguration.IdentityOperation.read)) {
                    return results;
                }
                String bindingDN = null;
                try {
                    NamingEnumeration<SearchResult> result = this.operationManager.lookupById(this.getBaseDN(attributedType), attributedType.getId(), this.getMappingConfig(attributedType.getClass()));
                    if (result.hasMore()) {
                        SearchResult next = result.next();
                        bindingDN = next.getNameInNamespace();
                        if (!attributedType.getClass().equals(relatedTypeConfig.getMappedClass())) {
                            entriesToFilter.add(bindingDN);
                        }
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                boolean filterByOwner = attributedType.getClass().equals(relatedTypeConfig.getMappedClass());
                if (attributeName != null && (property = PropertyQueries.createQuery((Class)relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{attributeName})).getFirstResult()) != null) {
                    filterByOwner = property.getJavaClass().equals(relatedTypeConfig.getMappedClass());
                }
                if (filterByOwner) {
                    filter.append(this.operationManager.getFilterById(this.getBaseDN(attributedType), attributedType.getId()));
                    continue;
                }
                filter.append("(").append(attributeName).append("=").append(bindingDN).append(")");
            }
        }
        filter.append(")");
        NamingEnumeration<SearchResult> search = null;
        try {
            if (filter.length() > 0) {
                String baseDN = this.getBaseDN(relatedTypeConfig);
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Search relationships for type [%s] using filter [%] and baseDN [%s]", relationshipClass, filter.toString(), baseDN);
                }
                search = this.operationManager.search(baseDN, filter.toString(), relatedTypeConfig);
                while (search.hasMore()) {
                    SearchResult entry = search.next();
                    if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found entry [%s] for relationship ", entry.getNameInNamespace(), relationshipClass);
                    }
                    Attributes ownerAttributes = entry.getAttributes();
                    AttributedType ownerType = this.populateAttributedType(context, entry, null);
                    for (Map.Entry memberAttribute : mappingConfig.getMappedProperties().entrySet()) {
                        String attributeName = (String)memberAttribute.getValue();
                        Attribute attribute = ownerAttributes.get(attributeName);
                        NamingEnumeration<?> attributeValues = attribute.getAll();
                        while (attributeValues.hasMore()) {
                            String dn;
                            String attributeValue = attributeValues.next().toString();
                            if (!entriesToFilter.isEmpty() && !entriesToFilter.contains(attributeValue)) continue;
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Processing relationship [%s] from attribute [%s] with attributeValue [%s]", relationshipClass, attributeName, attributeValue);
                            }
                            if (StringUtil.isNullOrEmpty((String)attributeValue.trim())) continue;
                            Property associatedProperty = PropertyQueries.createQuery((Class)relationshipClass).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{(String)memberAttribute.getKey()})).getSingleResult();
                            String memberBaseDN = attributeValue.substring(attributeValue.indexOf(",") + 1);
                            NamingEnumeration<SearchResult> result = this.operationManager.search(memberBaseDN, dn = attributeValue.substring(0, attributeValue.indexOf(",")), null);
                            if (!result.hasMore()) {
                                throw new IdentityManagementException("Associated entry does not exists [" + attributeValue + "].");
                            }
                            Property property = PropertyQueries.createQuery((Class)relationshipClass).addCriteria((PropertyCriteria)new TypedPropertyCriteria(mappingConfig.getRelatedAttributedType())).getSingleResult();
                            if (!property.getJavaClass().isAssignableFrom(ownerType.getClass())) continue;
                            Relationship relationship = (Relationship)Reflections.newInstance((Class)relationshipClass);
                            property.setValue((Object)relationship, (Object)ownerType);
                            SearchResult member = result.next();
                            AttributedType relType = this.populateAttributedType(context, member, null);
                            if (!associatedProperty.getJavaClass().isAssignableFrom(relType.getClass())) continue;
                            associatedProperty.setValue((Object)relationship, (Object)relType);
                            if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                IDMInternalLog.LDAP_STORE_LOGGER.tracef("Relationship [%s] created from attribute [%s] with attributeValue [%s]", relationshipClass, attributeName, attributeValue);
                            }
                            results.add(relationship);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw IDMInternalMessages.MESSAGES.queryRelationshipFailed(query, e);
        }
        finally {
            this.safeClose(search);
        }
        return results;
    }

    public void storeCredential(IdentityContext context, Account account, CredentialStorage storage) {
    }

    public <T extends CredentialStorage> T retrieveCurrentCredential(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    public <T extends CredentialStorage> List<T> retrieveCredentials(IdentityContext context, Account account, Class<T> storageClass) {
        return null;
    }

    @Override
    protected void removeCredentials(IdentityContext context, Account account) {
    }

    private String getBaseDN(LDAPMappingConfiguration ldapEntryConfig) {
        String baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        if (ldapEntryConfig.getBaseDN() != null) {
            baseDN = ldapEntryConfig.getBaseDN();
        }
        return baseDN;
    }

    private <V extends IdentityType> StringBuilder createIdentityTypeSearchFilter(IdentityQuery<V> identityQuery, LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder filter = new StringBuilder();
        for (Map.Entry entry : identityQuery.getParameters().entrySet()) {
            Object[] queryParameterValues;
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            if (IdentityType.ID.equals(queryParameter) || (queryParameterValues = (Object[])entry.getValue()).length <= 0 || !AttributeParameter.class.isInstance(queryParameter)) continue;
            AttributeParameter attributeParameter = (AttributeParameter)queryParameter;
            String attributeName = (String)ldapEntryConfig.getMappedProperties().get(attributeParameter.getName());
            if (attributeName == null) continue;
            Object attributeValue = queryParameterValues[0];
            if (Date.class.isInstance(attributeValue)) {
                attributeValue = LDAPUtil.formatDate((Date)attributeValue);
            }
            if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                filter.append("(").append(attributeName).append(">=").append(attributeValue).append(")");
                continue;
            }
            if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                filter.append("(").append(attributeName).append("<=").append(attributeValue).append(")");
                continue;
            }
            filter.append("(").append(attributeName).append("=").append(attributeValue).append(")");
        }
        if (filter.length() != 0) {
            filter.insert(0, "(&(");
            if (ldapEntryConfig != null) {
                filter.append((CharSequence)this.getObjectClassesFilter(ldapEntryConfig));
            } else {
                filter.append("(").append("objectclass").append("=").append("*").append(")");
            }
            filter.append("))");
        }
        return filter;
    }

    private StringBuilder getObjectClassesFilter(LDAPMappingConfiguration ldapEntryConfig) {
        StringBuilder builder = new StringBuilder();
        for (String objectClass : ldapEntryConfig.getObjectClasses()) {
            builder.append("(objectClass=").append(objectClass).append(")");
        }
        return builder;
    }

    private void addRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes entryAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String relationshipTypeProperty : mappingConfig.getMappedProperties().keySet()) {
            Property relationshipProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{relationshipTypeProperty})).getSingleResult();
            Attribute attribute = entryAttributes.get((String)mappingConfig.getMappedProperties().get(relationshipTypeProperty));
            if (attribute == null) continue;
            ArrayList<String> membersToRemove = new ArrayList<String>();
            String memberDN = this.getBindingDN((AttributedType)relationshipProperty.getValue((Object)relationship));
            try {
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object next = attributeValues.next();
                    if (next.toString().trim().equals(this.getEmptyAttributeValue().trim())) {
                        membersToRemove.add(this.getEmptyAttributeValue());
                        membersToRemove.add(this.getEmptyAttributeValue().trim());
                    }
                    if (!next.toString().toLowerCase().equals(memberDN.toLowerCase())) continue;
                    membersToRemove.add(next.toString());
                }
                for (String memberToRemove : membersToRemove) {
                    attribute.remove(memberToRemove);
                }
            }
            catch (NamingException ne) {
                throw new IdentityManagementException("Could not iterate over members for relationship [" + relationship + "].", (Throwable)ne);
            }
            attribute.add(memberDN);
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType), attribute);
        }
    }

    private AttributedType getRelationshipOwner(Relationship relationship) {
        Class ownertType = this.getMappingConfig(relationship.getClass()).getRelatedAttributedType();
        Property property = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(ownertType)).getSingleResult();
        return (AttributedType)property.getValue((Object)relationship);
    }

    private void removeRelationship(Relationship relationship) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(relationship.getClass());
        AttributedType ownerType = this.getRelationshipOwner(relationship);
        Attributes ownerAttributes = this.operationManager.getAttributes(ownerType.getId(), this.getBaseDN(ownerType), mappingConfig);
        for (String typeProperty : mappingConfig.getMappedProperties().keySet()) {
            String childDN;
            Property relProperty = PropertyQueries.createQuery(relationship.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{typeProperty})).getSingleResult();
            Attribute mappedAttribute = ownerAttributes.get((String)mappingConfig.getMappedProperties().get(typeProperty));
            if (mappedAttribute != null && mappedAttribute.contains(childDN = this.getBindingDN((AttributedType)relProperty.getValue((Object)relationship)))) {
                mappedAttribute.remove(childDN);
            }
            if (mappedAttribute.size() == 0) {
                mappedAttribute.add(this.getEmptyAttributeValue());
            }
            this.operationManager.modifyAttribute(this.getBindingDN(ownerType), mappedAttribute);
        }
    }

    private AttributedType populateAttributedType(IdentityContext context, SearchResult searchResult, AttributedType attributedType) {
        return this.populateAttributedType(context, searchResult, attributedType, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributedType populateAttributedType(IdentityContext context, SearchResult searchResult, AttributedType attributedType, int hierarchyDepthCount) {
        block23: {
            try {
                LDAPMappingConfiguration mappingConfig;
                String entryDN = searchResult.getNameInNamespace();
                String entryBaseDN = entryDN.substring(entryDN.indexOf(",") + 1);
                Attributes attributes = searchResult.getAttributes();
                if (attributedType == null) {
                    attributedType = (AttributedType)Reflections.newInstance((Class)((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(entryBaseDN, this.getEntryObjectClasses(attributes)));
                }
                if (hierarchyDepthCount > (mappingConfig = this.getMappingConfig(attributedType.getClass())).getHierarchySearchDepth()) {
                    return null;
                }
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating attributed type [%s] from DN [%s]", attributedType, entryDN);
                }
                NamingEnumeration<? extends Attribute> ldapAttributes = attributes.getAll();
                while (ldapAttributes.hasMore()) {
                    Object attributeValue;
                    Attribute ldapAttribute = ldapAttributes.next();
                    try {
                        attributeValue = ldapAttribute.get();
                    }
                    catch (NoSuchElementException nsee) {
                        continue;
                    }
                    String attributeName = ldapAttribute.getID();
                    if (attributeName.toLowerCase().equals(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName().toLowerCase())) {
                        attributedType.setId(this.operationManager.decodeEntryUUID(attributeValue));
                        continue;
                    }
                    List properties = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(AttributeProperty.class)).getResultList();
                    for (Property property : properties) {
                        String ldapAttributeName = (String)mappingConfig.getMappedProperties().get(property.getName());
                        if (ldapAttributeName == null || !ldapAttributeName.toLowerCase().equals(attributeName.toLowerCase())) continue;
                        if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                            IDMInternalLog.LDAP_STORE_LOGGER.tracef("Populating property [%s] from ldap attribute [%s] with value [%s] from DN [%s].", new Object[]{property.getName(), attributeName, attributeValue, entryBaseDN});
                        }
                        if (property.getJavaClass().equals(Date.class)) {
                            property.setValue((Object)attributedType, (Object)LDAPUtil.parseDate(attributeValue.toString()));
                            continue;
                        }
                        property.setValue((Object)attributedType, attributeValue);
                    }
                }
                if (IdentityType.class.isInstance(attributedType)) {
                    IdentityType identityType = (IdentityType)attributedType;
                    String createdTimestamp = attributes.get("createTimeStamp").get().toString();
                    identityType.setCreatedDate(LDAPUtil.parseDate(createdTimestamp));
                }
                LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
                if (mappingConfig.getParentMembershipAttributeName() == null) break block23;
                StringBuilder filter = new StringBuilder("(&");
                filter.append("(").append((CharSequence)this.getObjectClassesFilter(entryConfig)).append(")").append("(").append(mappingConfig.getParentMembershipAttributeName()).append("=").append("").append(this.getBindingName(attributedType)).append(",").append(entryBaseDN).append(")");
                filter.append(")");
                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Searching parent entry for DN [%s] using filter [%s].", entryDN, filter.toString());
                }
                NamingEnumeration<SearchResult> search = this.operationManager.search(((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN(), filter.toString(), entryConfig);
                try {
                    if (search.hasMore()) {
                        SearchResult next = search.next();
                        Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
                        if (parentProperty != null) {
                            String parentDN = next.getNameInNamespace();
                            String parentBaseDN = parentDN.substring(parentDN.indexOf(",") + 1);
                            Class baseDNType = ((LDAPIdentityStoreConfiguration)this.getConfig()).getSupportedTypeByBaseDN(parentBaseDN, this.getEntryObjectClasses(attributes));
                            if (parentProperty.getJavaClass().isAssignableFrom(baseDNType)) {
                                if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                                    IDMInternalLog.LDAP_STORE_LOGGER.tracef("Found parent [%s] for entry for DN [%s].", parentDN, entryDN);
                                }
                                int hierarchyDepthCount1 = ++hierarchyDepthCount;
                                parentProperty.setValue((Object)attributedType, (Object)this.populateAttributedType(context, next, null, hierarchyDepthCount1));
                            }
                        }
                    } else if (IDMInternalLog.LDAP_STORE_LOGGER.isTraceEnabled()) {
                        IDMInternalLog.LDAP_STORE_LOGGER.tracef("No parent entry found for DN [%s] using filter [%s].", entryDN, filter.toString());
                    }
                }
                finally {
                    this.safeClose(search);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not populate attribute type " + attributedType + ".", (Throwable)e);
            }
        }
        return attributedType;
    }

    private List<String> getEntryObjectClasses(Attributes attributes) throws NamingException {
        Attribute objectClassesAttribute = attributes.get("objectclass");
        ArrayList<String> objectClasses = new ArrayList<String>();
        if (objectClassesAttribute == null) {
            return objectClasses;
        }
        NamingEnumeration<?> all = objectClassesAttribute.getAll();
        while (all.hasMore()) {
            objectClasses.add(all.next().toString());
        }
        return objectClasses;
    }

    private String getBindingName(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property idProperty = mappingConfig.getIdProperty();
        return (String)mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + (String)idProperty.getValue((Object)attributedType);
    }

    private BasicAttributes extractAttributes(AttributedType attributedType, boolean extractObjectClasses) {
        BasicAttributes entryAttributes = new BasicAttributes();
        Map mappedProperties = this.getMappingConfig(attributedType.getClass()).getMappedProperties();
        for (String propertyName : mappedProperties.keySet()) {
            if (this.getMappingConfig(attributedType.getClass()).getReadOnlyAttributes().contains(propertyName)) continue;
            Property property = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{propertyName})).getSingleResult();
            Object propertyValue = property.getValue((Object)attributedType);
            if (AttributedType.class.isInstance(propertyValue)) {
                AttributedType referencedType = (AttributedType)propertyValue;
                propertyValue = this.getBindingDN(referencedType);
            } else if (propertyValue == null || StringUtil.isNullOrEmpty((String)propertyValue.toString())) {
                propertyValue = this.getEmptyAttributeValue();
            }
            entryAttributes.put((String)mappedProperties.get(propertyName), propertyValue);
        }
        if (extractObjectClasses) {
            LDAPMappingConfiguration ldapEntryConfig = this.getMappingConfig(attributedType.getClass());
            BasicAttribute objectClassAttribute = new BasicAttribute("objectclass");
            for (String objectClassValue : ldapEntryConfig.getObjectClasses()) {
                objectClassAttribute.add(objectClassValue);
                if (!objectClassValue.equals("groupOfNames") && !objectClassValue.equals("groupOfEntries") && !objectClassValue.equals("groupOfUniqueNames")) continue;
                entryAttributes.put("member", this.getEmptyAttributeValue());
            }
            entryAttributes.put(objectClassAttribute);
        }
        return entryAttributes;
    }

    private LDAPMappingConfiguration getMappingConfig(Class<? extends AttributedType> attributedType) {
        LDAPMappingConfiguration mappingConfig = ((LDAPIdentityStoreConfiguration)this.getConfig()).getMappingConfig(attributedType);
        if (mappingConfig == null) {
            throw new IdentityManagementException("Not mapped type [" + attributedType + "].");
        }
        return mappingConfig;
    }

    NamingEnumeration<SearchResult> lookupEntryByID(String id, String baseDN, LDAPMappingConfiguration mappingConfiguration) {
        return this.operationManager.lookupById(baseDN, id, mappingConfiguration);
    }

    LDAPOperationManager getOperationManager() {
        return this.operationManager;
    }

    String getBindingDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        Property idProperty = mappingConfig.getIdProperty();
        String baseDN = mappingConfig.getBaseDN() == null ? "" : "," + this.getBaseDN(attributedType);
        return (String)mappingConfig.getMappedProperties().get(idProperty.getName()) + "=" + (String)idProperty.getValue((Object)attributedType) + baseDN;
    }

    private String getBaseDN(AttributedType attributedType) {
        LDAPMappingConfiguration mappingConfig = this.getMappingConfig(attributedType.getClass());
        String baseDN = mappingConfig.getBaseDN();
        String mappingDN = (String)mappingConfig.getParentMapping().get(mappingConfig.getIdProperty().getValue((Object)attributedType));
        if (mappingDN != null) {
            baseDN = mappingDN;
        } else {
            AttributedType parentType;
            Property parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult();
            if (parentProperty != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
                Property parentIdProperty = this.getMappingConfig(parentType.getClass()).getIdProperty();
                String parentId = (String)parentIdProperty.getValue((Object)parentType);
                String parentBaseDN = (String)mappingConfig.getParentMapping().get(parentId);
                baseDN = parentBaseDN != null ? parentBaseDN : this.getBaseDN(parentType);
            }
        }
        if (baseDN == null) {
            baseDN = ((LDAPIdentityStoreConfiguration)this.getConfig()).getBaseDN();
        }
        return baseDN;
    }

    private void addToParentAsMember(AttributedType attributedType) {
        AttributedType parentType;
        Property parentProperty;
        LDAPMappingConfiguration entryConfig = this.getMappingConfig(attributedType.getClass());
        if (entryConfig.getParentMembershipAttributeName() != null && (parentProperty = PropertyQueries.createQuery(attributedType.getClass()).addCriteria((PropertyCriteria)new TypedPropertyCriteria(attributedType.getClass())).getFirstResult()) != null && (parentType = (AttributedType)parentProperty.getValue((Object)attributedType)) != null) {
            Attributes attributes = this.operationManager.getAttributes(parentType.getId(), this.getBaseDN(parentType), entryConfig);
            Attribute attribute = attributes.get(entryConfig.getParentMembershipAttributeName());
            attribute.add(this.getBindingDN(attributedType));
            this.operationManager.modifyAttribute(this.getBindingDN(parentType), attribute);
        }
    }

    private String getEntryIdentifier(AttributedType attributedType) {
        NamingEnumeration<SearchResult> search = null;
        try {
            search = this.operationManager.search(this.getBaseDN(attributedType), "(" + this.getBindingName(attributedType) + ")", this.getMappingConfig(attributedType.getClass()));
            Attribute id = search.next().getAttributes().get(((LDAPIdentityStoreConfiguration)this.getConfig()).getUniqueIdentifierAttributeName());
            if (id == null) {
                throw new IdentityManagementException("Could not retrieve identifier for entry [" + this.getBindingDN(attributedType) + "].");
            }
            String string = id.get().toString();
            return string;
        }
        catch (NamingException ne) {
            throw new IdentityManagementException("Could not add type [" + attributedType + "].", (Throwable)ne);
        }
        finally {
            this.safeClose(search);
        }
    }

    private void safeClose(NamingEnumeration<?> search) {
        if (search != null) {
            try {
                search.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private String getEmptyAttributeValue() {
        return " ";
    }
}

