/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.picketlink.common.util.LDAPUtil;
import org.picketlink.idm.IDMInternalLog;
import org.picketlink.idm.IDMInternalMessages;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPMappingConfiguration;

public class LDAPOperationManager {
    private List<String> managedAttributes = new ArrayList<String>();
    private final LdapContext context;
    private final LdapContext authenticationContext;
    private final LDAPIdentityStoreConfiguration config;

    public LDAPOperationManager(LDAPIdentityStoreConfiguration config) throws NamingException {
        this.config = config;
        this.context = this.constructContext();
        this.authenticationContext = this.constructContext();
    }

    private LdapContext constructContext() throws NamingException {
        String url;
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", this.config.getFactoryName());
        env.setProperty("java.naming.security.authentication", this.config.getAuthType());
        String protocol = this.config.getProtocol();
        if (protocol != null) {
            env.setProperty("java.naming.security.protocol", protocol);
        }
        String bindDN = this.config.getBindDN();
        char[] bindCredential = null;
        if (this.config.getBindCredential() != null) {
            bindCredential = this.config.getBindCredential().toCharArray();
        }
        if (bindDN != null) {
            env.setProperty("java.naming.security.principal", bindDN);
            env.put("java.naming.security.credentials", bindCredential);
        }
        if ((url = this.config.getLdapURL()) == null) {
            throw new RuntimeException("url");
        }
        env.setProperty("java.naming.provider.url", url);
        Properties additionalProperties = this.config.getConnectionProperties();
        if (additionalProperties != null) {
            Set<Object> keys = additionalProperties.keySet();
            for (Object key : keys) {
                env.setProperty((String)key, additionalProperties.getProperty((String)key));
            }
        }
        if (this.config.isActiveDirectory()) {
            env.put("java.naming.ldap.attributes.binary", "objectGUID");
        }
        if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
            IDMInternalLog.LDAP_STORE_LOGGER.debugf("Creating LdapContext using properties: [%s]", env);
        }
        return new InitialLdapContext(env, null);
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods);
    }

    public <T> T lookup(String dn) {
        try {
            return (T)this.context.lookup(dn);
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not lookup entry using DN [%s]", dn);
            return null;
        }
    }

    public <T> List<T> removeEntryById(String baseDN, String id) {
        ArrayList result = new ArrayList();
        NamingEnumeration<SearchResult> answer = null;
        try {
            BasicAttributes attributesToSearch = new BasicAttributes(true);
            attributesToSearch.put(new BasicAttribute(this.getUniqueIdentifierAttributeName(), id));
            answer = this.getContext().search(baseDN, (Attributes)attributesToSearch);
            if (answer.hasMore()) {
                SearchResult sr = answer.next();
                this.destroySubcontext(sr.getNameInNamespace());
            }
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not remove entry from DN [%s] and id [%s]", baseDN, id);
            throw new RuntimeException(e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return result;
    }

    public NamingEnumeration<SearchResult> search(String baseDN, String filter, LDAPMappingConfiguration mappingConfiguration) throws NamingException {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        cons.setReturningObjFlag(false);
        List<String> returningAttributes = this.getReturningAttributes(mappingConfiguration);
        cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
        try {
            return this.getContext().search(baseDN, filter, cons);
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not query server using DN [%s] and filter [%s]", baseDN, filter);
            throw e;
        }
    }

    private List<String> getReturningAttributes(LDAPMappingConfiguration mappingConfiguration) {
        ArrayList<String> returningAttributes = new ArrayList<String>();
        if (mappingConfiguration != null) {
            returningAttributes.addAll(mappingConfiguration.getMappedProperties().values());
            returningAttributes.add(mappingConfiguration.getParentMembershipAttributeName());
            for (LDAPMappingConfiguration relationshipConfig : this.config.getRelationshipConfigs()) {
                if (!relationshipConfig.getRelatedAttributedType().equals(mappingConfiguration.getMappedClass())) continue;
                returningAttributes.addAll(relationshipConfig.getMappedProperties().values());
            }
        } else {
            returningAttributes.add("*");
        }
        returningAttributes.add(this.getUniqueIdentifierAttributeName());
        returningAttributes.add("createTimeStamp");
        returningAttributes.add("objectclass");
        return returningAttributes;
    }

    public String getFilterById(String baseDN, String id) {
        String filter = null;
        if (this.config.isActiveDirectory()) {
            String strObjectGUID = "<GUID=" + id + ">";
            try {
                Attributes attributes = this.context.getAttributes(strObjectGUID);
                byte[] objectGUID = (byte[])attributes.get("objectGUID").get();
                filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + LDAPUtil.convertObjectGUIToByteString((byte[])objectGUID) + "))";
            }
            catch (NamingException ne) {
                return filter;
            }
        }
        if (filter == null) {
            filter = "(&(objectClass=*)(" + this.getUniqueIdentifierAttributeName() + "=" + id + "))";
        }
        return filter;
    }

    public NamingEnumeration<SearchResult> lookupById(String baseDN, String id, LDAPMappingConfiguration mappingConfiguration) {
        String filter = this.getFilterById(baseDN, id);
        if (filter != null) {
            try {
                SearchControls cons = new SearchControls();
                cons.setSearchScope(2);
                cons.setReturningObjFlag(false);
                cons.setCountLimit(1L);
                List<String> returningAttributes = this.getReturningAttributes(mappingConfiguration);
                cons.setReturningAttributes(returningAttributes.toArray(new String[returningAttributes.size()]));
                return this.getContext().search(baseDN, filter, cons);
            }
            catch (NamingException e) {
                IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not query server using DN [%s] and filter [%s]", baseDN, filter);
                throw new RuntimeException(e);
            }
        }
        return this.createEmptyEnumeration();
    }

    public void destroySubcontext(String dn) {
        try {
            NamingEnumeration<Binding> enumeration = null;
            try {
                enumeration = this.getContext().listBindings(dn);
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    String name = binding.getNameInNamespace();
                    this.destroySubcontext(name);
                }
                this.getContext().unbind(dn);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    enumeration.close();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not unbind DN [%s]", dn);
            throw new RuntimeException(e);
        }
    }

    public boolean isManagedAttribute(String attributeName) {
        if (this.managedAttributes.contains(attributeName)) {
            return true;
        }
        if (this.checkAttributePresence(attributeName)) {
            this.managedAttributes.add(attributeName);
            return true;
        }
        return false;
    }

    public boolean checkAttributePresence(String attributeName) {
        try {
            DirContext schema = this.context.getSchema("");
            DirContext cnSchema = (DirContext)schema.lookup("AttributeDefinition/" + attributeName);
            if (cnSchema != null) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public boolean authenticate(String dn, String password) {
        try {
            this.authenticationContext.addToEnvironment("java.naming.security.principal", dn);
            this.authenticationContext.addToEnvironment("java.naming.security.credentials", password);
            this.authenticationContext.lookup(dn);
        }
        catch (Exception e) {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf(e, "Authentication failed for DN [%s]", dn);
            }
            return false;
        }
        return true;
    }

    private void modifyAttributes(String dn, ModificationItem[] mods) {
        try {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("Modifying attributes for entry [%s]: [", dn);
                for (ModificationItem item : mods) {
                    IDMInternalLog.LDAP_STORE_LOGGER.debugf("  Op [%s]: %s = %s", item.getModificationOp(), item.getAttribute().getID(), item.getAttribute().get());
                }
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("]", new Object[0]);
            }
            this.context.modifyAttributes(dn, mods);
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not modify attribute for DN [%s].", dn);
            throw new IdentityManagementException("Could not modify attribute for DN [" + dn + "]", (Throwable)e);
        }
    }

    public void createSubContext(String name, Attributes attributes) {
        try {
            if (IDMInternalLog.LDAP_STORE_LOGGER.isDebugEnabled()) {
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("Creating entry [%s] with attributes: [", name);
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute attribute = all.next();
                    IDMInternalLog.LDAP_STORE_LOGGER.debugf("  %s = %s", attribute.getID(), attribute.get());
                }
                IDMInternalLog.LDAP_STORE_LOGGER.debugf("]", new Object[0]);
            }
            this.getContext().createSubcontext(name, attributes);
        }
        catch (NamingException e) {
            IDMInternalLog.LDAP_STORE_LOGGER.errorf(e, "Could not create entry [%s].", name);
            throw new IdentityManagementException("Error creating subcontext [" + name + "]", (Throwable)e);
        }
    }

    private LdapContext getContext() {
        return this.context;
    }

    private String getUniqueIdentifierAttributeName() {
        return this.config.getUniqueIdentifierAttributeName();
    }

    private NamingEnumeration<SearchResult> createEmptyEnumeration() {
        return new NamingEnumeration<SearchResult>(){

            @Override
            public SearchResult next() throws NamingException {
                return null;
            }

            @Override
            public boolean hasMore() throws NamingException {
                return false;
            }

            @Override
            public void close() throws NamingException {
            }

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public SearchResult nextElement() {
                return null;
            }
        };
    }

    public Attributes getAttributes(String entryUUID, String baseDN, LDAPMappingConfiguration mappingConfiguration) {
        NamingEnumeration<SearchResult> search = this.lookupById(baseDN, entryUUID, mappingConfiguration);
        try {
            if (!search.hasMore()) {
                throw IDMInternalMessages.MESSAGES.storeLdapEntryNotFoundWithId(entryUUID, baseDN);
            }
            Attributes attributes = search.next().getAttributes();
            return attributes;
        }
        catch (NamingException e) {
            throw IDMInternalMessages.MESSAGES.storeLdapCouldNotLoadAttributesForEntry(entryUUID, baseDN);
        }
        finally {
            try {
                search.close();
            }
            catch (NamingException e) {}
        }
    }

    public String decodeEntryUUID(Object entryUUID) {
        String id = this.config.isActiveDirectory() ? LDAPUtil.decodeObjectGUID((byte[])((byte[])entryUUID)) : entryUUID.toString();
        return id;
    }
}

