/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.util.HashSet;
import java.util.Set;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.internal.DigestCredentialHandler;
import org.picketlink.idm.credential.internal.PlainTextPasswordCredentialHandler;
import org.picketlink.idm.credential.internal.X509CertificateCredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.spi.annotations.SupportsStores;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.spi.IdentityStore;

public class DefaultCredentialHandlerFactory
implements CredentialHandlerFactory {
    Set<CredentialHandler> defaultHandlers = new HashSet<CredentialHandler>();
    Set<CredentialHandler> registeredHandlers = new HashSet<CredentialHandler>();

    public DefaultCredentialHandlerFactory() {
        this.defaultHandlers.add(new PlainTextPasswordCredentialHandler());
        this.defaultHandlers.add(new DigestCredentialHandler());
        this.defaultHandlers.add(new LDAPPlainTextPasswordCredentialHandler());
        this.defaultHandlers.add(new X509CertificateCredentialHandler());
    }

    public void registerHandler(CredentialHandler handler) {
        this.registeredHandlers.add(handler);
    }

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, Class<? extends IdentityStore> identityStoreClass) {
        for (CredentialHandler handler : this.registeredHandlers) {
            if (!this.handlerSupports(handler, credentialsClass, identityStoreClass)) continue;
            return handler;
        }
        for (CredentialHandler handler : this.defaultHandlers) {
            if (!this.handlerSupports(handler, credentialsClass, identityStoreClass)) continue;
            return handler;
        }
        return null;
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, Class<? extends IdentityStore> identityStoreClass) {
        for (CredentialHandler handler : this.registeredHandlers) {
            if (!this.handlerSupports(handler, credentialClass, identityStoreClass)) continue;
            return handler;
        }
        for (CredentialHandler handler : this.defaultHandlers) {
            if (!this.handlerSupports(handler, credentialClass, identityStoreClass)) continue;
            return handler;
        }
        return null;
    }

    private boolean handlerSupports(CredentialHandler handler, Class<?> credentialClass, Class<? extends IdentityStore> identityStoreClass) {
        SupportsCredentials sc = handler.getClass().getAnnotation(SupportsCredentials.class);
        SupportsStores ss = handler.getClass().getAnnotation(SupportsStores.class);
        if (sc == null || ss == null) {
            return false;
        }
        for (Class cls : sc.value()) {
            if (!cls.equals(credentialClass)) continue;
            for (Class isc : ss.value()) {
                if (!isc.equals(identityStoreClass)) continue;
                return true;
            }
        }
        return false;
    }
}

