/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.DigestUtil;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.spi.annotations.SupportsStores;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.password.internal.PlainTextPasswordStorage;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={DigestCredentials.class, Digest.class})
@SupportsStores(value={JPAIdentityStore.class, FileBasedIdentityStore.class, LDAPIdentityStore.class})
public class DigestCredentialHandler
implements CredentialHandler {
    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        DigestCredentials digestCredential = (DigestCredentials)credentials;
        Agent agent = identityStore.getAgent(digestCredential.getDigest().getUsername());
        PlainTextPasswordStorage storedPassword = (PlainTextPasswordStorage)identityStore.retrieveCredential(agent, PlainTextPasswordStorage.class);
        if (storedPassword != null && DigestUtil.matchCredential((Digest)digestCredential.getDigest(), (char[])storedPassword.getPassword().toCharArray())) {
            digestCredential.setStatus(Credentials.Status.VALID);
            digestCredential.setValidatedAgent(agent);
        }
    }

    public void update(Agent agent, Object credential, IdentityStore<?> store) {
    }
}

