/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.spi.annotations.SupportsStores;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.password.internal.PlainTextPasswordStorage;
import org.picketlink.idm.password.internal.SHASaltedPasswordEncoder;
import org.picketlink.idm.password.internal.SHASaltedPasswordHash;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={UsernamePasswordCredentials.class, PlainTextPassword.class})
@SupportsStores(value={JPAIdentityStore.class, FileBasedIdentityStore.class})
public class PlainTextPasswordCredentialHandler
implements CredentialHandler {
    private static final String PASSWORD_SALT_USER_ATTRIBUTE = "passwordSalt";

    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        if (!UsernamePasswordCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("Credentials class [" + credentials.getClass().getName() + "] not supported by this handler.");
        }
        UsernamePasswordCredentials usernamePassword = (UsernamePasswordCredentials)credentials;
        usernamePassword.setStatus(Credentials.Status.INVALID);
        Agent agent = identityStore.getAgent(usernamePassword.getUsername());
        if (agent != null) {
            this.doValidate(agent, usernamePassword, identityStore);
        }
    }

    protected void doValidate(Agent agent, UsernamePasswordCredentials usernamePassword, IdentityStore<?> identityStore) {
        PlainTextPassword password = usernamePassword.getPassword();
        if (password.isEncodePassword()) {
            SHASaltedPasswordHash hash = (SHASaltedPasswordHash)identityStore.retrieveCredential(agent, SHASaltedPasswordHash.class);
            if (hash != null) {
                String salt = this.getSalt(agent, identityStore);
                SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
                String encoded = encoder.encodePassword(salt, new String(usernamePassword.getPassword().getValue()));
                if (hash.getEncodedHash().equals(encoded)) {
                    usernamePassword.setStatus(Credentials.Status.VALID);
                    usernamePassword.setValidatedAgent(agent);
                }
            }
        } else {
            PlainTextPasswordStorage storedPassword = (PlainTextPasswordStorage)identityStore.retrieveCredential(agent, PlainTextPasswordStorage.class);
            if (storedPassword != null && storedPassword.getPassword().equals(String.valueOf(password.getValue()))) {
                usernamePassword.setStatus(Credentials.Status.VALID);
                usernamePassword.setValidatedAgent(agent);
            }
        }
    }

    protected String getSalt(Agent agent, IdentityStore<?> store) {
        Attribute saltAttribute = agent.getAttribute(PASSWORD_SALT_USER_ATTRIBUTE);
        String salt = null;
        if (saltAttribute != null) {
            salt = (String)((Object)saltAttribute.getValue());
        }
        if (salt == null) {
            SecureRandom psuedoRng = null;
            String algorithm = "SHA1PRNG";
            try {
                psuedoRng = SecureRandom.getInstance(algorithm);
                psuedoRng.setSeed(1024L);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Error getting SecureRandom instance: " + algorithm, e);
            }
            salt = String.valueOf(psuedoRng.nextLong());
            agent.setAttribute(new Attribute(PASSWORD_SALT_USER_ATTRIBUTE, (Serializable)((Object)salt)));
            store.update((IdentityType)agent);
        }
        return salt;
    }

    public void update(Agent agent, Object credential, IdentityStore<?> store) {
        if (!PlainTextPassword.class.isInstance(credential)) {
            throw new IllegalArgumentException("Credential class [" + credential.getClass().getName() + "] not supported by this handler.");
        }
        PlainTextPassword password = (PlainTextPassword)credential;
        this.doUpdate(agent, store, password);
    }

    protected void doUpdate(Agent agent, IdentityStore<?> store, PlainTextPassword password) {
        if (password.isEncodePassword()) {
            SHASaltedPasswordEncoder encoder = new SHASaltedPasswordEncoder(512);
            SHASaltedPasswordHash hash = new SHASaltedPasswordHash();
            hash.setEncodedHash(encoder.encodePassword(this.getSalt(agent, store), new String(password.getValue())));
            store.storeCredential(agent, (CredentialStorage)hash);
        } else {
            PlainTextPasswordStorage storage = new PlainTextPasswordStorage(String.valueOf(password.getValue()));
            store.storeCredential(agent, (CredentialStorage)storage);
        }
    }
}

