/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.internal;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.X509Cert;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.credential.internal.X509CertificateStorage;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.spi.annotations.SupportsStores;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.internal.util.Base64;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={X509CertificateCredentials.class, X509Cert.class})
@SupportsStores(value={JPAIdentityStore.class, LDAPIdentityStore.class, FileBasedIdentityStore.class})
public class X509CertificateCredentialHandler
implements CredentialHandler {
    public void validate(Credentials credentials, IdentityStore<?> identityStore) {
        X509CertificateStorage storage;
        if (!X509CertificateCredentials.class.isInstance(credentials)) {
            throw new IllegalArgumentException("Credentials class [" + credentials.getClass().getName() + "] not supported by this handler.");
        }
        X509CertificateCredentials certCredentials = (X509CertificateCredentials)credentials;
        Agent agent = identityStore.getAgent(certCredentials.getUsername());
        certCredentials.setStatus(Credentials.Status.INVALID);
        if (agent != null && (storage = (X509CertificateStorage)identityStore.retrieveCredential(agent, X509CertificateStorage.class)) != null) {
            String base64Cert = storage.getBase64Cert();
            byte[] certBytes = Base64.decode(base64Cert);
            try {
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate storedCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
                X509Cert providedCert = certCredentials.getCertificate();
                if (storedCert.equals(providedCert.getValue())) {
                    certCredentials.setStatus(Credentials.Status.VALID);
                }
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error while checking user's certificate.", (Throwable)e);
            }
        }
    }

    public void update(Agent agent, Object credential, IdentityStore<?> store) {
        if (!X509Cert.class.isInstance(credential)) {
            throw new IllegalArgumentException("Credential class [" + credential.getClass().getName() + "] not supported by this handler.");
        }
        X509Cert certificate = (X509Cert)credential;
        X509CertificateStorage storage = new X509CertificateStorage(certificate);
        store.storeCredential(agent, (CredentialStorage)storage);
    }
}

