/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class FileBasedIdentityStore
extends AbstractIdentityStore<FileIdentityStoreConfiguration> {
    private FileIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;

    public void setup(FileIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
    }

    public FileIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    @Override
    protected Role addRole(Role role) {
        SimpleRole fileRole = new SimpleRole(role.getName());
        this.updateCommonProperties((IdentityType)role, (IdentityType)fileRole);
        this.getConfig().getRoles().put(fileRole.getName(), (Role)fileRole);
        this.flushRoles();
        return fileRole;
    }

    @Override
    protected Group addGroup(Group group) {
        SimpleGroup fileGroup = null;
        fileGroup = group.getParentGroup() != null ? new SimpleGroup(group.getName(), this.getGroup(group.getParentGroup().getName())) : new SimpleGroup(group.getName());
        this.updateCommonProperties((IdentityType)group, (IdentityType)fileGroup);
        this.getConfig().getGroups().put(fileGroup.getName(), (Group)fileGroup);
        this.flushGroups();
        return fileGroup;
    }

    @Override
    protected User addUser(User user) {
        SimpleUser storedUser = new SimpleUser(user.getId());
        storedUser.setFirstName(user.getFirstName());
        storedUser.setLastName(user.getLastName());
        storedUser.setEmail(user.getEmail());
        this.updateCommonProperties((IdentityType)user, (IdentityType)storedUser);
        this.getConfig().getUsers().put(storedUser.getId(), (User)storedUser);
        this.flushUsers();
        return storedUser;
    }

    @Override
    protected Role updateRole(Role updatedRole, Role storedRole) {
        if (storedRole != updatedRole) {
            this.updateCommonProperties((IdentityType)updatedRole, (IdentityType)storedRole);
        }
        this.getConfig().getRoles().put(storedRole.getName(), storedRole);
        this.flushRoles();
        return storedRole;
    }

    @Override
    protected Group updateGroup(Group updatedGroup, Group storedGroup) {
        if (storedGroup != updatedGroup) {
            this.updateCommonProperties((IdentityType)updatedGroup, (IdentityType)storedGroup);
        }
        this.getConfig().getGroups().put(storedGroup.getName(), storedGroup);
        this.flushGroups();
        return storedGroup;
    }

    @Override
    protected User updateUser(User updatedUser, User storedUser) {
        if (storedUser != updatedUser) {
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setEmail(updatedUser.getEmail());
            this.updateCommonProperties((IdentityType)updatedUser, (IdentityType)storedUser);
        }
        this.getConfig().getUsers().put(storedUser.getId(), storedUser);
        this.flushUsers();
        return updatedUser;
    }

    @Override
    protected Role removeRole(Role role) {
        this.getConfig().getRoles().remove(role.getName());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Role roleMembership = membership.getRole();
            if (roleMembership == null || !roleMembership.getName().equals(role.getName())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushRoles();
        this.flushMemberships();
        return role;
    }

    @Override
    protected Group removeGroup(Group group) {
        this.getConfig().getGroups().remove(group.getName());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Group groupMembership = membership.getGroup();
            if (groupMembership == null || !groupMembership.getName().equals(group.getName())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushGroups();
        this.flushMemberships();
        return group;
    }

    @Override
    protected User removeUser(User user) {
        this.getConfig().getUsers().remove(user.getId());
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            User userMember;
            IdentityType member = membership.getMember();
            if (!this.isUserType(member.getClass()) || !(userMember = (User)member).getId().equals(user.getId())) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushUsers();
        this.flushMemberships();
        return user;
    }

    public Agent getAgent(String id) {
        return this.getUser(id);
    }

    public User getUser(String id) {
        return this.getConfig().getUsers().get(id);
    }

    public Role getRole(String role) {
        return this.getConfig().getRoles().get(role);
    }

    public Group getGroup(String groupId) {
        return this.getConfig().getGroups().get(groupId);
    }

    public Group getGroup(String name, Group parent) {
        Group group = this.getGroup(name);
        Group parentGroup = group.getParentGroup();
        if (parentGroup == null || !parentGroup.getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        SimpleGroupRole membership = new SimpleGroupRole(member, role, group);
        this.getConfig().getMemberships().add((GroupRole)membership);
        this.flushMemberships();
        return membership;
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Agent providedMember = (Agent)member;
            Agent membershipMember = (Agent)membership.getMember();
            if (membershipMember == null || providedMember == null || !membershipMember.getId().equals(providedMember.getId()) || !this.hasGroupRole(membership, group, role)) continue;
            this.getConfig().getMemberships().remove(membership);
        }
        this.flushMemberships();
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        for (GroupRole membership : new ArrayList<GroupRole>(this.getConfig().getMemberships())) {
            Agent providedMember = (Agent)member;
            Agent membershipMember = (Agent)membership.getMember();
            if (membershipMember == null || providedMember == null || !membershipMember.getId().equals(providedMember.getId()) || !this.hasGroupRole(membership, group, role)) continue;
            return membership;
        }
        return null;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        Class identityTypeClass = identityQuery.getIdentityType();
        Set<Map.Entry<String, User>> entries = null;
        if (this.isUserType(identityTypeClass)) {
            entries = this.getConfig().getUsers().entrySet();
        } else if (this.isRoleType(identityTypeClass)) {
            entries = this.getConfig().getRoles().entrySet();
        } else if (this.isGroupType(identityTypeClass)) {
            entries = this.getConfig().getGroups().entrySet();
        }
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        for (Map.Entry<String, User> entry : entries) {
            Date createdDate;
            IdentityType storedIdentityType = (IdentityType)entry.getValue();
            if (this.isUserType(identityTypeClass)) {
                User user = (User)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.ID, (Serializable)((Object)user.getId())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.EMAIL, (Serializable)((Object)user.getEmail())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.FIRST_NAME, (Serializable)((Object)user.getFirstName())) || !this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), User.LAST_NAME, (Serializable)((Object)user.getLastName()))) continue;
            }
            if (this.isRoleType(identityTypeClass)) {
                Role role = (Role)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Role.NAME, (Serializable)((Object)role.getName()))) continue;
            }
            if (this.isGroupType(identityTypeClass)) {
                Group group = (Group)storedIdentityType;
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Group.NAME, (Serializable)((Object)group.getName()))) continue;
                String parentGroupName = null;
                if (group.getParentGroup() != null) {
                    parentGroupName = group.getParentGroup().getName();
                }
                if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), Group.PARENT, (Serializable)((Object)parentGroupName))) continue;
            }
            if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.ENABLED, Boolean.valueOf(storedIdentityType.isEnabled())) || (createdDate = storedIdentityType.getCreatedDate()) != null && (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.CREATED_DATE, createdDate) || !this.isQueryParameterLessThan(identityQuery.getParameters(), IdentityType.CREATED_BEFORE, createdDate.getTime()) || !this.isQueryParameterGreaterThan(identityQuery.getParameters(), IdentityType.CREATED_AFTER, createdDate.getTime()))) continue;
            Date expiryDate = storedIdentityType.getExpirationDate();
            if (!this.isQueryParameterEquals((Map<QueryParameter, Object[]>)identityQuery.getParameters(), IdentityType.EXPIRY_DATE, expiryDate)) continue;
            Long expiryDateInMillis = null;
            if (expiryDate != null) {
                expiryDateInMillis = expiryDate.getTime();
            }
            if (!this.isQueryParameterLessThan(identityQuery.getParameters(), IdentityType.EXPIRY_BEFORE, expiryDateInMillis) || !this.isQueryParameterGreaterThan(identityQuery.getParameters(), IdentityType.EXPIRY_AFTER, expiryDateInMillis)) continue;
            result.add(storedIdentityType);
        }
        if (identityQuery.getParameters().containsKey(User.HAS_ROLE) || identityQuery.getParameters().containsKey(User.MEMBER_OF) || identityQuery.getParameters().containsKey(User.HAS_GROUP_ROLE) || identityQuery.getParameters().containsKey(User.ROLE_OF) || identityQuery.getParameters().containsKey(User.HAS_MEMBER)) {
            for (IdentityType fileUser : new ArrayList(result)) {
                for (Map.Entry parameters : identityQuery.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)parameters.getKey();
                    Object[] values = (Object[])parameters.getValue();
                    int valuesMatchCount = values.length;
                    for (GroupRole membership : this.getConfig().getMemberships()) {
                        Agent agent;
                        if (this.isUserType(fileUser.getClass()) && this.isUserType(membership.getMember().getClass())) {
                            User selectedUser = (User)fileUser;
                            User memberUser = (User)membership.getMember();
                            if (!selectedUser.getId().equals(memberUser.getId())) continue;
                        }
                        if (queryParameter.equals(IdentityType.HAS_GROUP_ROLE) && membership.getGroup() != null && membership.getRole() != null) {
                            for (Object groupNames : values) {
                                GroupRole groupRole = (GroupRole)groupNames;
                                if (!groupRole.getGroup().getName().equals(membership.getGroup().getName()) || !groupRole.getRole().getName().equals(membership.getRole().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.HAS_ROLE) && membership.getRole() != null) {
                            for (Object roleNames : values) {
                                if (!roleNames.equals(membership.getRole().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.MEMBER_OF) && membership.getGroup() != null) {
                            for (Object groupNames : values) {
                                if (!groupNames.equals(membership.getGroup().getName())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (queryParameter.equals(IdentityType.ROLE_OF) && membership.getRole() != null) {
                            for (Object member : values) {
                                agent = (Agent)member;
                                if (agent == null || !agent.getKey().equals(membership.getMember().getKey()) || !membership.getRole().getKey().equals(fileUser.getKey())) continue;
                                --valuesMatchCount;
                            }
                            continue;
                        }
                        if (!queryParameter.equals(IdentityType.HAS_MEMBER) || membership.getGroup() == null) continue;
                        for (Object member : values) {
                            agent = (Agent)member;
                            if (agent == null || !agent.getKey().equals(membership.getMember().getKey()) || !membership.getGroup().getKey().equals(fileUser.getKey())) continue;
                            --valuesMatchCount;
                        }
                    }
                    if (valuesMatchCount <= 0) continue;
                    result.remove(fileUser);
                }
            }
        }
        this.findByCustomAttributes(result, identityQuery);
        return result;
    }

    private void findByCustomAttributes(List<? extends IdentityType> identityTypes, IdentityQuery identityQuery) {
        Set entrySet = identityQuery.getParameters().entrySet();
        for (IdentityType identityType : new ArrayList<IdentityType>(identityTypes)) {
            for (Map.Entry entry : entrySet) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] queryParameterValues = (Object[])entry.getValue();
                if (!IdentityType.AttributeParameter.class.isInstance(queryParameter) || queryParameterValues == null) continue;
                IdentityType.AttributeParameter customParameter = (IdentityType.AttributeParameter)queryParameter;
                Attribute userAttribute = identityType.getAttribute(customParameter.getName());
                boolean match = false;
                if (userAttribute != null && userAttribute.getValue() != null) {
                    int count = queryParameterValues.length;
                    for (Object value : queryParameterValues) {
                        if (userAttribute.getValue().getClass().isArray()) {
                            Object[] userValues;
                            for (Object object : userValues = (Object[])userAttribute.getValue()) {
                                if (!object.equals(value)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!value.equals(userAttribute.getValue())) continue;
                        --count;
                    }
                    if (count <= 0) {
                        match = true;
                    }
                }
                if (match) continue;
                identityTypes.remove(identityType);
            }
        }
    }

    private void updateCommonProperties(IdentityType fromIdentityType, IdentityType toIdentityType) {
        toIdentityType.setEnabled(fromIdentityType.isEnabled());
        toIdentityType.setCreatedDate(fromIdentityType.getCreatedDate());
        toIdentityType.setExpirationDate(fromIdentityType.getExpirationDate());
        for (Object object : toIdentityType.getAttributes().toArray()) {
            Attribute attribute = (Attribute)object;
            toIdentityType.removeAttribute(attribute.getName());
        }
        for (Attribute attrib : fromIdentityType.getAttributes()) {
            toIdentityType.setAttribute(attrib);
        }
    }

    private boolean hasGroupRole(GroupRole membership, Group group, Role role) {
        boolean match = false;
        if (role != null && group != null) {
            match = membership.getRole() != null && role.getName().equals(membership.getRole().getName()) && membership.getGroup() != null && group.getName().equals(membership.getGroup().getName());
        } else if (group != null) {
            match = membership.getGroup() != null && group.getName().equals(membership.getGroup().getName());
        } else if (role != null) {
            match = membership.getRole() != null && role.getName().equals(membership.getRole().getName());
        }
        return match;
    }

    private boolean isQueryParameterEquals(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Serializable valueToCompare) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        Object value = values[0];
        if (Date.class.isInstance(valueToCompare)) {
            Date parameterDate = (Date)value;
            value = parameterDate.getTime();
            Date toCompareDate = (Date)valueToCompare;
            valueToCompare = Long.valueOf(toCompareDate.getTime());
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(value);
    }

    private boolean isQueryParameterEquals(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Date valueToCompare) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        return values.length > 0 && valueToCompare != null && valueToCompare.equals(values[0]);
    }

    private boolean isQueryParameterGreaterThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare) {
        return this.isQueryParameterGreaterOrLessThan(parameters, queryParameter, valueToCompare, true);
    }

    private boolean isQueryParameterLessThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare) {
        return this.isQueryParameterGreaterOrLessThan(parameters, queryParameter, valueToCompare, false);
    }

    private boolean isQueryParameterGreaterOrLessThan(Map<QueryParameter, Object[]> parameters, QueryParameter queryParameter, Long valueToCompare, boolean greaterThan) {
        Object[] values = parameters.get(queryParameter);
        if (values == null) {
            return true;
        }
        long value = 0L;
        if (Date.class.isInstance(values[0])) {
            Date parameterDate = (Date)values[0];
            value = parameterDate.getTime();
        } else {
            value = Long.valueOf(values[0].toString());
        }
        if (values.length > 0 && valueToCompare != null) {
            if (greaterThan && valueToCompare >= value) {
                return true;
            }
            if (!greaterThan && valueToCompare <= value) {
                return true;
            }
        }
        return false;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    synchronized void flushUsers() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getUsersFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getUsers());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushRoles() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getRolesFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getRoles());
            oos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void flushGroups() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getGroupsFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getGroups());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    synchronized void flushMemberships() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getConfig().getMembershipsFile());
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.getConfig().getMemberships());
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

