/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.file.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;

public class FileIdentityStoreConfiguration
extends IdentityStoreConfiguration {
    private String workingDir;
    private boolean alwaysCreateFiles = true;
    private Set<IdentityStore.Feature> featureSet = new HashSet<IdentityStore.Feature>();
    private File usersFile;
    private File rolesFile = new File("/tmp/pl-idm-work/pl-idm-roles.db");
    private File groupsFile = new File("/tmp/pl-idm-work/pl-idm-groups.db");
    private File membershipsFile = new File("/tmp/pl-idm-work/pl-idm-memberships.db");
    private Map<String, User> users = new HashMap<String, User>();
    private Map<String, Role> roles = new HashMap<String, Role>();
    private Map<String, Group> groups = new HashMap<String, Group>();
    private List<GroupRole> memberships = new ArrayList<GroupRole>();

    public void init() throws SecurityConfigurationException {
        this.featureSet.add(IdentityStore.Feature.all);
        if (this.getWorkingDir() == null) {
            this.setWorkingDir(System.getProperty("java.io.tmpdir"));
        }
        this.initDataFiles();
    }

    private void initDataFiles() {
        File workingDirectoryFile = this.initWorkingDirectory();
        this.usersFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-users.db"));
        this.rolesFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-roles.db"));
        this.groupsFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-groups.db"));
        this.membershipsFile = this.checkAndCreateFile(new File(workingDirectoryFile.getPath() + "/pl-idm-memberships.db"));
    }

    private File initWorkingDirectory() {
        String workingDir = this.getWorkingDir();
        File workingDirectoryFile = new File(workingDir);
        if (!workingDirectoryFile.exists()) {
            workingDirectoryFile.mkdirs();
        }
        return workingDirectoryFile;
    }

    private File checkAndCreateFile(File file) {
        if (this.isAlwaysCreateFiles() && file.exists()) {
            file.delete();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    private void initialize() {
        this.loadUsers();
        this.loadRoles();
        this.loadGroups();
        this.loadMemberships();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroups() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.getGroupsFile());
            ois = new ObjectInputStream(fis);
            this.groups = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMemberships() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.getMembershipsFile());
            ois = new ObjectInputStream(fis);
            this.memberships = (List)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRoles() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.getRolesFile());
            ois = new ObjectInputStream(fis);
            this.roles = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUsers() {
        ObjectInputStream ois = null;
        try {
            FileInputStream fis = new FileInputStream(this.getUsersFile());
            ois = new ObjectInputStream(fis);
            this.users = (Map)ois.readObject();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public Set<IdentityStore.Feature> getFeatureSet() {
        return this.featureSet;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean isAlwaysCreateFiles() {
        return this.alwaysCreateFiles;
    }

    public void setAlwaysCreateFiles(boolean alwaysCreateFiles) {
        this.alwaysCreateFiles = alwaysCreateFiles;
    }

    public File getUsersFile() {
        return this.usersFile;
    }

    public File getRolesFile() {
        return this.rolesFile;
    }

    public File getGroupsFile() {
        return this.groupsFile;
    }

    public File getMembershipsFile() {
        return this.membershipsFile;
    }

    public Map<String, User> getUsers() {
        return this.users;
    }

    public Map<String, Role> getRoles() {
        return this.roles;
    }

    public List<GroupRole> getMemberships() {
        return this.memberships;
    }

    public Map<String, Group> getGroups() {
        return this.groups;
    }
}

