/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.io.Serializable;
import java.util.List;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialStorage;
import org.picketlink.idm.credential.spi.annotations.Stored;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.internal.util.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.idm.internal.util.properties.query.PropertyQueries;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;

public abstract class AbstractIdentityStore<T extends IdentityStoreConfiguration>
implements IdentityStore<T> {
    public static final String EVENT_CONTEXT_USER_ENTITY = "USER_ENTITY";
    public static final String EVENT_CONTEXT_GROUP_ENTITY = "GROUP_ENTITY";
    public static final String EVENT_CONTEXT_ROLE_ENTITY = "ROLE_ENTITY";

    public void add(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (this.isUserType(identityTypeClass)) {
            User storedUser = this.addUser((User)identityType);
            UserCreatedEvent event = new UserCreatedEvent(storedUser);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isGroupType(identityTypeClass)) {
            Group storedGroup = this.addGroup((Group)identityType);
            GroupCreatedEvent event = new GroupCreatedEvent(storedGroup);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isRoleType(identityTypeClass)) {
            Role storedRole = this.addRole((Role)identityType);
            RoleCreatedEvent event = new RoleCreatedEvent(storedRole);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
    }

    public void update(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (this.isUserType(identityTypeClass)) {
            User updatedUser = (User)identityType;
            if (updatedUser.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            User storedUser = this.getUser(updatedUser.getId());
            if (storedUser == null) {
                throw new RuntimeException("User [" + updatedUser.getId() + "] does not exists.");
            }
            this.updateUser(updatedUser, storedUser);
            UserUpdatedEvent event = new UserUpdatedEvent(storedUser);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isGroupType(identityTypeClass)) {
            Group updatedGroup = (Group)identityType;
            if (updatedGroup.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Group storedGroup = this.getGroup(updatedGroup.getName());
            if (storedGroup == null) {
                throw new RuntimeException("No group found with the given name [" + updatedGroup.getName() + "].");
            }
            this.updateGroup(updatedGroup, storedGroup);
            GroupUpdatedEvent event = new GroupUpdatedEvent(storedGroup);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isRoleType(identityTypeClass)) {
            Role updatedRole = (Role)identityType;
            if (updatedRole.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Role storedRole = this.getRole(updatedRole.getName());
            if (storedRole == null) {
                throw new RuntimeException("No role found with the given name [" + updatedRole.getName() + "].");
            }
            this.updateRole(updatedRole, storedRole);
            RoleUpdatedEvent event = new RoleUpdatedEvent(storedRole);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
    }

    public void remove(IdentityType identityType) {
        Class<?> identityTypeClass = identityType.getClass();
        if (this.isUserType(identityTypeClass)) {
            User user = (User)identityType;
            if (user.getId() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            User storedUser = this.getUser(user.getId());
            if (storedUser == null) {
                throw new RuntimeException("User [" + user.getId() + "] doest not exists.");
            }
            this.removeUser(storedUser);
            UserDeletedEvent event = new UserDeletedEvent(storedUser);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedUser);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isGroupType(identityTypeClass)) {
            Group group = (Group)identityType;
            if (group.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Group storedGroup = this.getGroup(group.getName());
            if (storedGroup == null) {
                throw new RuntimeException("Group [" + group.getName() + "] doest not exists.");
            }
            this.removeGroup(storedGroup);
            GroupDeletedEvent event = new GroupDeletedEvent(storedGroup);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedGroup);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        } else if (this.isRoleType(identityTypeClass)) {
            Role role = (Role)identityType;
            if (role.getName() == null) {
                throw new IdentityManagementException("No identifier was provided.");
            }
            Role storedRole = this.getRole(role.getName());
            if (storedRole == null) {
                throw new RuntimeException("Role [" + role.getName() + "] doest not exists.");
            }
            this.removeRole(storedRole);
            RoleDeletedEvent event = new RoleDeletedEvent(storedRole);
            event.getContext().setValue(EVENT_CONTEXT_USER_ENTITY, (Object)storedRole);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
    }

    protected Role removeRole(Role identityType) {
        return null;
    }

    protected Group removeGroup(Group identityType) {
        return null;
    }

    protected User removeUser(User identityType) {
        return null;
    }

    protected Role updateRole(Role updatedRole, Role storedRole) {
        return null;
    }

    protected Group updateGroup(Group updatedGroup, Group storedGroup) {
        return null;
    }

    protected User updateUser(User updatedUser, User storedUser) {
        return null;
    }

    protected Role addRole(Role updatedRole) {
        return null;
    }

    protected Group addGroup(Group updatedGroup) {
        return null;
    }

    protected User addUser(User updatedUser) {
        return null;
    }

    public void validateCredentials(Credentials credentials) {
        CredentialHandler handler = this.getContext().getCredentialValidator(credentials.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for validating Credentials of type [" + credentials.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.validate(credentials, (IdentityStore)this);
    }

    public void updateCredential(Agent agent, Object credential) {
        CredentialHandler handler = this.getContext().getCredentialUpdater(credential.getClass(), (IdentityStore)this);
        if (handler == null) {
            throw new SecurityConfigurationException("No suitable CredentialHandler available for updating Credentials of type [" + credential.getClass() + "] for IdentityStore [" + this.getClass() + "]");
        }
        handler.update(agent, credential, (IdentityStore)this);
    }

    public <T extends CredentialStorage> void storeCredential(Agent agent, T storage) {
        List annotatedTypes = PropertyQueries.createQuery(storage.getClass()).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        if (annotatedTypes.isEmpty()) {
            throw new IdentityManagementException("Could not find any @Stored annotated method for CredentialStorage type [" + storage.getClass().getName() + "].");
        }
        Property storedProperty = annotatedTypes.get(0);
        Object credential = storedProperty.getValue(storage);
        if (!Serializable.class.isInstance(credential)) {
            throw new IdentityManagementException("Methods annotated with @Stored should aways return a serializable object.");
        }
        Attribute credentialAttribute = new Attribute(this.getCredentialAttributeName(storage.getClass()), (Serializable)credential);
        agent.setAttribute(credentialAttribute);
        this.update((IdentityType)agent);
    }

    public <C extends CredentialStorage> C retrieveCredential(Agent agent, Class<C> storageClass) {
        CredentialStorage storage = null;
        List annotatedTypes = PropertyQueries.createQuery(storageClass).addCriteria(new AnnotatedPropertyCriteria(Stored.class)).getResultList();
        if (annotatedTypes.isEmpty()) {
            throw new IdentityManagementException("Could not find any @Stored annotated method for CredentialStorage type [" + storageClass.getName() + "].");
        }
        Property<Serializable> storedProperty = annotatedTypes.get(0);
        Attribute credentialAttribute = agent.getAttribute(this.getCredentialAttributeName(storageClass));
        if (credentialAttribute != null) {
            try {
                storage = (CredentialStorage)storageClass.newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error while creating a " + storageClass.getName() + " storage instance.", (Throwable)e);
            }
        } else {
            throw new IdentityManagementException("Methods annotated with @Stored should aways return a serializable object.");
        }
        storedProperty.setValue(storage, credentialAttribute.getValue());
        return (C)storage;
    }

    private <T extends CredentialStorage> String getCredentialAttributeName(Class<T> storage) {
        return storage.getName();
    }

    protected boolean isGroupType(Class<? extends IdentityType> identityType) {
        return Group.class.isAssignableFrom(identityType);
    }

    protected boolean isRoleType(Class<? extends IdentityType> identityType) {
        return Role.class.isAssignableFrom(identityType);
    }

    protected boolean isUserType(Class<? extends IdentityType> identityType) {
        return User.class.isAssignableFrom(identityType);
    }

    protected boolean isAgentType(Class<? extends IdentityType> identityType) {
        return Agent.class.isAssignableFrom(identityType);
    }

    protected IdentityManagementException throwsNotSupportedIdentityType(IdentityType identityType) {
        return new IdentityManagementException("Not supported IdentityType.");
    }

    protected IdentityManagementException createNotImplementedYetException() {
        return new IdentityManagementException("Not implemented yet.");
    }
}

