/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.internal;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.PartitionStoreConfiguration;
import org.picketlink.idm.file.internal.FileBasedIdentityStore;
import org.picketlink.idm.file.internal.FileIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.JPAPartitionStore;
import org.picketlink.idm.jpa.internal.JPAPartitionStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;
import org.picketlink.idm.spi.PartitionStore;
import org.picketlink.idm.spi.StoreFactory;

public class DefaultStoreFactory
implements StoreFactory {
    private Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStore<?>>> identityConfigMap = new HashMap();
    private Map<Class<? extends PartitionStoreConfiguration>, Class<? extends PartitionStore>> partitionConfigMap = new HashMap<Class<? extends PartitionStoreConfiguration>, Class<? extends PartitionStore>>();

    public DefaultStoreFactory() {
        this.identityConfigMap.put(JPAIdentityStoreConfiguration.class, JPAIdentityStore.class);
        this.identityConfigMap.put(LDAPConfiguration.class, LDAPIdentityStore.class);
        this.identityConfigMap.put(FileIdentityStoreConfiguration.class, FileBasedIdentityStore.class);
        this.partitionConfigMap.put(JPAPartitionStoreConfiguration.class, JPAPartitionStore.class);
    }

    public IdentityStore<?> createIdentityStore(IdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        for (Class<? extends IdentityStoreConfiguration> cc : this.identityConfigMap.keySet()) {
            if (!cc.isInstance(config)) continue;
            try {
                IdentityStore<?> store = this.identityConfigMap.get(cc).newInstance();
                store.setup(config, context);
                return store;
            }
            catch (InstantiationException e) {
                throw new SecurityConfigurationException("Exception while creating new IdentityStore instance", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new SecurityConfigurationException("Exception while creating new IdentityStore instance", (Throwable)e);
            }
        }
        throw new IllegalArgumentException("The IdentityStoreConfiguration specified is not supported by this IdentityStoreFactory implementation");
    }

    public PartitionStore createPartitionStore(PartitionStoreConfiguration config) {
        return null;
    }

    public void mapIdentityConfiguration(Class<? extends IdentityStoreConfiguration> configClass, Class<? extends IdentityStore> storeClass) {
        this.identityConfigMap.put(configClass, storeClass);
    }

    public void mapPartitionConfiguration(Class<? extends PartitionStoreConfiguration> configClass, Class<? extends PartitionStore> storeClass) {
        this.partitionConfigMap.put(configClass, storeClass);
    }
}

