/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.AgentCreatedEvent;
import org.picketlink.idm.event.AgentDeletedEvent;
import org.picketlink.idm.event.AgentUpdatedEvent;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.SimpleAgent;

public class AgentTypeManager
extends IdentityTypeManager<Agent> {
    public AgentTypeManager(JPAIdentityStore store) {
        super(store);
    }

    @Override
    protected void fromIdentityType(Object toIdentity, Agent fromUser) {
        this.getStore().setModelProperty(toIdentity, "IDENTITY_ID", fromUser.getId(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Agent fromIdentityType) {
        return new AgentCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Agent fromIdentityType) {
        return new AgentUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Agent fromIdentityType) {
        return new AgentDeletedEvent(fromIdentityType);
    }

    @Override
    protected Agent createIdentityType(Object identity) {
        String idValue = this.getConfig().getModelProperty("IDENTITY_ID").getValue(identity).toString();
        SimpleAgent agent = new SimpleAgent(idValue);
        return agent;
    }
}

