/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.GroupCreatedEvent;
import org.picketlink.idm.event.GroupDeletedEvent;
import org.picketlink.idm.event.GroupUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.query.QueryParameter;

public class GroupTypeManager
extends IdentityTypeManager<Group> {
    public GroupTypeManager(JPAIdentityStore store) {
        super(store);
    }

    @Override
    protected void fromIdentityType(Object toIdentity, Group fromGroup) {
        this.getStore().setModelProperty(toIdentity, "IDENTITY_NAME", fromGroup.getName(), true);
        if (fromGroup.getParentGroup() != null) {
            Object parentIdentity = this.getStore().lookupIdentityObjectById((IdentityType)fromGroup.getParentGroup());
            if (parentIdentity == null) {
                this.getStore().add((IdentityType)fromGroup.getParentGroup());
                parentIdentity = this.getStore().lookupIdentityObjectById((IdentityType)fromGroup.getParentGroup());
            }
            this.getStore().setModelProperty(toIdentity, "PARENT_GROUP", parentIdentity, true);
        }
    }

    @Override
    void remove(Object identity, Group identityType) {
        this.disassociateChilds(identityType);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Group fromIdentityType) {
        return new GroupCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Group fromIdentityType) {
        return new GroupUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Group fromIdentityType) {
        return new GroupDeletedEvent(fromIdentityType);
    }

    private void disassociateChilds(Group group) {
        EntityManager em = this.getStore().getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(this.getConfig().getModelProperty("PARENT_GROUP").getName());
        predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), (Object)group.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List resultList = em.createQuery(criteria).getResultList();
        for (Object object : resultList) {
            this.getConfig().getModelProperty("PARENT_GROUP").setValue(object, null);
            em.merge(object);
        }
    }

    @Override
    protected Group createIdentityType(Object identity) {
        String name = this.getStore().getModelProperty(String.class, identity, "IDENTITY_NAME");
        Object parentInstance = this.getStore().getModelProperty(Object.class, identity, "PARENT_GROUP");
        SimpleGroup group = null;
        if (parentInstance != null) {
            String parentId = this.getStore().getModelProperty(String.class, parentInstance, "IDENTITY_NAME");
            Group parent = this.getStore().getGroup(parentId);
            group = new SimpleGroup(name, parent);
        } else {
            group = new SimpleGroup(name);
        }
        return group;
    }

    @Override
    protected List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria) {
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria);
        CriteriaBuilder builder = criteria.getBuilder();
        if (queryParameter.equals(Group.NAME)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(Group.PARENT)) {
            Join join = criteria.getRoot().join(this.getConfig().getModelProperty("PARENT_GROUP").getName());
            predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.HAS_MEMBER)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getMembershipClass());
                Root fromProject = subquery.from(this.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(groupModelProperty.getName()));
                Predicate conjunction = criteria.getBuilder().conjunction();
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(groupModelProperty.getName()), criteria.getRoot()));
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(memberModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)object)));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
            }
        }
        return predicates;
    }
}

