/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.query.QueryParameter;

public abstract class IdentityTypeManager<T extends IdentityType> {
    private JPAIdentityStore store;

    public IdentityTypeManager(JPAIdentityStore store) {
        this.store = store;
    }

    void remove(Object identity, T identityType) {
    }

    public Object createIdentityInstance(Realm realm, T fromIdentityType) {
        Object identity = null;
        try {
            identity = this.getConfig().getIdentityClass().newInstance();
            this.populateIdentityInstance(realm, identity, fromIdentityType);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return identity;
    }

    public T fromIdentityInstance(Realm realm, Object identity) {
        T identityType = this.createIdentityType(identity);
        identityType.setEnabled(this.getStore().getModelProperty(Boolean.class, identity, "IDENTITY_ENABLED").booleanValue());
        identityType.setExpirationDate(this.getStore().getModelProperty(Date.class, identity, "IDENTITY_EXPIRES"));
        identityType.setCreatedDate(this.getStore().getModelProperty(Date.class, identity, "IDENTITY_CREATED"));
        return identityType;
    }

    protected List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (queryParameter.equals(IdentityType.ENABLED)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_ENABLED").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.CREATED_DATE)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_CREATED").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_EXPIRES").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
            predicates.add(criteria.getBuilder().greaterThan((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_CREATED").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_AFTER)) {
            predicates.add(criteria.getBuilder().greaterThan((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_EXPIRES").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
            predicates.add(criteria.getBuilder().lessThan((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_CREATED").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter.equals(IdentityType.EXPIRY_BEFORE)) {
            predicates.add(criteria.getBuilder().lessThan((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_EXPIRES").getName()), (Comparable)((Date)parameterValues[0])));
        }
        if (queryParameter instanceof IdentityType.AttributeParameter) {
            IdentityType.AttributeParameter customParameter = (IdentityType.AttributeParameter)queryParameter;
            Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getAttributeClass());
            Root fromProject = subquery.from(this.getConfig().getAttributeClass());
            Subquery select = subquery.select((Expression)fromProject.get(this.getConfig().getModelProperty("ATTRIBUTE_IDENTITY").getName()));
            Predicate conjunction = criteria.getBuilder().conjunction();
            conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(this.getConfig().getModelProperty("ATTRIBUTE_NAME").getName()), (Object)customParameter.getName()));
            conjunction.getExpressions().add(fromProject.get(this.getConfig().getModelProperty("ATTRIBUTE_VALUE").getName()).in(parameterValues));
            subquery.where((Expression)conjunction);
            subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteria.getBuilder().equal(criteria.getBuilder().count(subquery.getSelection()), (Object)parameterValues.length));
            predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
        }
        return predicates;
    }

    protected abstract T createIdentityType(Object var1);

    protected abstract void fromIdentityType(Object var1, T var2);

    protected abstract AbstractBaseEvent raiseCreatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseUpdatedEvent(T var1);

    protected abstract AbstractBaseEvent raiseDeletedEvent(T var1);

    void populateIdentityInstance(Realm realm, Object toIdentity, T fromIdentityType) {
        String identityDiscriminator = this.store.getIdentityDiscriminator(fromIdentityType.getClass());
        this.store.setModelProperty(toIdentity, "IDENTITY_DISCRIMINATOR", identityDiscriminator, true);
        this.store.setModelProperty(toIdentity, "IDENTITY_KEY", fromIdentityType.getKey(), true);
        this.store.setModelProperty(toIdentity, "IDENTITY_ENABLED", fromIdentityType.isEnabled(), true);
        this.store.setModelProperty(toIdentity, "IDENTITY_CREATED", fromIdentityType.getCreatedDate(), true);
        this.store.setModelProperty(toIdentity, "IDENTITY_EXPIRES", fromIdentityType.getExpirationDate());
        if (realm != null) {
            this.store.setModelProperty(toIdentity, "IDENTITY_PARTITION", this.store.lookupPartitionObject((Partition)realm));
        }
        this.fromIdentityType(toIdentity, fromIdentityType);
    }

    protected JPAIdentityStoreConfiguration getConfig() {
        return this.store.getConfig();
    }

    protected JPAIdentityStore getStore() {
        return this.store;
    }
}

