/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;

public class JPACriteriaQueryBuilder {
    private JPAIdentityStoreConfiguration config;
    private IdentityQuery<?> identityQuery;
    private EntityManager entityManager;
    private CriteriaBuilder builder;
    private Root<?> root;
    private CriteriaQuery<?> criteria;
    private List<Predicate> predicates = new ArrayList<Predicate>();
    private JPAIdentityStore identityStore;
    private IdentityTypeManager identityTypeManager;

    public JPACriteriaQueryBuilder(JPAIdentityStore identityStore, IdentityQuery<?> identityQuery) {
        this.identityStore = identityStore;
        this.identityQuery = identityQuery;
        this.config = identityStore.getConfig();
        this.identityTypeManager = this.identityStore.getIdentityTypeManager(identityQuery.getIdentityType());
        this.entityManager = identityStore.getEntityManager();
        this.builder = this.entityManager.getCriteriaBuilder();
        Class<?> identityClass = this.config.getIdentityClass();
        this.criteria = this.builder.createQuery(identityClass);
        this.root = this.criteria.from(identityClass);
    }

    public List<Predicate> getPredicates() {
        this.builder = this.entityManager.getCriteriaBuilder();
        String discriminator = this.config.getIdentityTypeDiscriminator(this.identityQuery.getIdentityType());
        this.predicates.add(this.builder.equal((Expression)this.root.get(this.config.getModelProperty("IDENTITY_DISCRIMINATOR").getName()), (Object)discriminator));
        for (Map.Entry entry : this.identityQuery.getParameters().entrySet()) {
            QueryParameter queryParameter = (QueryParameter)entry.getKey();
            Object[] parameterValues = (Object[])entry.getValue();
            this.predicates.addAll(this.identityTypeManager.getPredicate(queryParameter, parameterValues, this));
        }
        return this.predicates;
    }

    public CriteriaQuery<?> getCriteria() {
        return this.criteria;
    }

    public CriteriaBuilder getBuilder() {
        return this.builder;
    }

    public Root<?> getRoot() {
        return this.root;
    }
}

