/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.annotations.IDMAttribute;
import org.picketlink.idm.jpa.internal.AgentTypeManager;
import org.picketlink.idm.jpa.internal.GroupTypeManager;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.jpa.internal.RoleTypeManager;
import org.picketlink.idm.jpa.internal.UserTypeManager;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.internal.DefaultIdentityQuery;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class JPAIdentityStore
extends AbstractIdentityStore<JPAIdentityStoreConfiguration> {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    private JPAIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;
    private Map<String, IdentityTypeManager<? extends IdentityType>> identityTypeStores = new HashMap<String, IdentityTypeManager<? extends IdentityType>>();

    public void setup(JPAIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
        this.identityTypeStores.put(this.getIdentityDiscriminator(User.class), new UserTypeManager(this));
        this.identityTypeStores.put(this.getIdentityDiscriminator(Agent.class), new AgentTypeManager(this));
        this.identityTypeStores.put(this.getIdentityDiscriminator(Role.class), new RoleTypeManager(this));
        this.identityTypeStores.put(this.getIdentityDiscriminator(Group.class), new GroupTypeManager(this));
    }

    public JPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    @Override
    public void add(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        if (this.lookupIdentityObjectById(identityType) != null) {
            throw new IdentityManagementException("IdentityType already exists.");
        }
        try {
            IdentityTypeManager<IdentityType> identityTypeManager = this.getIdentityTypeManager(identityType.getClass());
            Object identity = identityTypeManager.createIdentityInstance(this.getContext().getRealm(), identityType);
            this.updateAttributes(identityType, identity);
            EntityManager em = this.getEntityManager();
            em.persist(identity);
            em.flush();
            AbstractBaseEvent event = identityTypeManager.raiseCreatedEvent(identityType);
            event.getContext().setValue("USER_ENTITY", identity);
            this.getContext().getEventBridge().raiseEvent((Object)event);
        }
        catch (Exception ex) {
            throw new IdentityManagementException("Exception while creating IdentityType [" + identityType + "].", (Throwable)ex);
        }
    }

    @Override
    public void update(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        IdentityTypeManager<IdentityType> identityTypeManager = this.getIdentityTypeManager(identityType.getClass());
        Object identity = this.getIdentityObject(identityType);
        identityTypeManager.populateIdentityInstance(this.getContext().getRealm(), identity, identityType);
        this.updateAttributes(identityType, identity);
        EntityManager em = this.getEntityManager();
        em.merge(identity);
        em.flush();
        AbstractBaseEvent event = identityTypeManager.raiseUpdatedEvent(identityType);
        event.getContext().setValue("USER_ENTITY", identity);
        this.getContext().getEventBridge().raiseEvent((Object)event);
    }

    @Override
    public void remove(IdentityType identityType) {
        this.checkInvalidIdentityType(identityType);
        EntityManager em = this.getEntityManager();
        IdentityTypeManager<IdentityType> identityTypeManager = this.getIdentityTypeManager(identityType.getClass());
        Object identity = this.getIdentityObject(identityType);
        identityTypeManager.remove(identity, identityType);
        this.removeCredentials(identity);
        this.removeAttributes(identity);
        this.removeMemberships(identity);
        em.remove(identity);
        em.flush();
        AbstractBaseEvent event = identityTypeManager.raiseDeletedEvent(identityType);
        event.getContext().setValue("USER_ENTITY", identity);
        this.getContext().getEventBridge().raiseEvent((Object)event);
    }

    public User getUser(String id) {
        if (id == null) {
            return null;
        }
        User user = this.getContext().getCache().lookupUser(this.context.getRealm(), id);
        if (user == null) {
            DefaultIdentityQuery<User> defaultIdentityQuery = new DefaultIdentityQuery<User>(User.class, this);
            defaultIdentityQuery.setParameter(User.ID, id);
            List<User> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                user = resultList.get(0);
            }
            this.getContext().getCache().putUser(this.context.getRealm(), user);
        }
        return user;
    }

    private void configurePartition(Partition partition, Object identity, IdentityType identityType) {
        if (this.getConfig().isModelPropertySet("IDENTITY_PARTITION")) {
            Object partitionInstance = this.getModelProperty(Object.class, identity, "IDENTITY_PARTITION");
            identityType.setPartition(this.convertPartitionEntityToPartition(partitionInstance));
        } else {
            identityType.setPartition(partition);
        }
    }

    public Group getGroup(String groupId) {
        if (groupId == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Group group = this.getContext().getCache().lookupGroup((Partition)partition, groupId);
        if (group == null) {
            DefaultIdentityQuery<Group> defaultIdentityQuery = new DefaultIdentityQuery<Group>(Group.class, this);
            defaultIdentityQuery.setParameter(Group.NAME, groupId);
            List<Group> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                group = resultList.get(0);
            }
            this.getContext().getCache().putGroup((Partition)partition, group);
        }
        return group;
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        Group group = this.getGroup(name);
        if (group.getParentGroup() == null || !group.getParentGroup().getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public Role getRole(String name) {
        if (name == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Role role = this.getContext().getCache().lookupRole((Partition)partition, name);
        if (role == null) {
            DefaultIdentityQuery<Role> defaultIdentityQuery = new DefaultIdentityQuery<Role>(Role.class, this);
            defaultIdentityQuery.setParameter(Role.NAME, name);
            List<Role> resultList = defaultIdentityQuery.getResultList();
            if (!resultList.isEmpty()) {
                role = resultList.get(0);
            }
            this.getContext().getCache().putRole((Partition)partition, role);
        }
        return role;
    }

    public Agent getAgent(String id) {
        if (id == null) {
            return null;
        }
        Realm partition = this.context.getRealm();
        Object agent = this.getContext().getCache().lookupAgent(partition, id);
        if (agent == null) {
            DefaultIdentityQuery<Agent> defaultIdentityQuery = new DefaultIdentityQuery<Agent>(Agent.class, this);
            defaultIdentityQuery.setParameter(Agent.ID, id);
            List<Agent> resultList = defaultIdentityQuery.getResultList();
            agent = !resultList.isEmpty() ? resultList.get(0) : this.getUser(id);
            this.getContext().getCache().putAgent(partition, agent);
        }
        return agent;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<IdentityType> result = new ArrayList<IdentityType>();
        try {
            EntityManager em = this.getEntityManager();
            JPACriteriaQueryBuilder criteriaBuilder = new JPACriteriaQueryBuilder(this, identityQuery);
            List<Predicate> predicates = criteriaBuilder.getPredicates();
            CriteriaQuery<?> criteria = criteriaBuilder.getCriteria();
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List queryResult = em.createQuery(criteria).getResultList();
            for (Object identity : queryResult) {
                String discriminator = this.getConfig().getModelProperty("IDENTITY_DISCRIMINATOR").getValue(identity).toString();
                IdentityTypeManager<? extends IdentityType> identityTypeManager = this.identityTypeStores.get(discriminator);
                IdentityType identityType = identityTypeManager.fromIdentityInstance(this.getContext().getRealm(), identity);
                this.configurePartition((Partition)this.getContext().getRealm(), identity, identityType);
                this.populateAttributes(identityType, identity);
                result.add(identityType);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error executing query.", (Throwable)e);
        }
        return result;
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        Object membership;
        Group storedGroup;
        User storedUser;
        Role storedRole;
        Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
        Property<Object> roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
        Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
        SimpleGroupRole groupRole = null;
        if (member instanceof User) {
            storedRole = null;
            Object identityRole = null;
            if (role != null) {
                storedRole = this.getRole(role.getName());
                identityRole = this.lookupIdentityObjectById((IdentityType)storedRole);
            }
            storedUser = null;
            Object identityUser = null;
            if (member != null) {
                storedUser = this.getUser(((User)member).getId());
                identityUser = this.lookupIdentityObjectById((IdentityType)storedUser);
            }
            storedGroup = null;
            Object identityGroup = null;
            if (group != null) {
                storedGroup = this.getGroup(group.getName());
                identityGroup = this.lookupIdentityObjectById((IdentityType)storedGroup);
            }
            membership = null;
            try {
                membership = this.getConfig().getMembershipClass().newInstance();
            }
            catch (Exception e) {
                throw new IdentityManagementException("Could not create membership type instance.", (Throwable)e);
            }
            if (storedRole != null && storedGroup != null) {
                try {
                    memberModelProperty.setValue(membership, identityUser);
                    roleModelProperty.setValue(membership, identityRole);
                    groupModelProperty.setValue(membership, identityGroup);
                }
                catch (Exception e) {}
            } else if (storedRole != null) {
                memberModelProperty.setValue(membership, identityUser);
                roleModelProperty.setValue(membership, identityRole);
            } else {
                memberModelProperty.setValue(membership, identityUser);
                groupModelProperty.setValue(membership, identityGroup);
            }
        } else {
            if (member instanceof Group) {
                throw this.createNotImplementedYetException();
            }
            throw new IllegalArgumentException("The member parameter must be an instance of User or Group");
        }
        this.getEntityManager().persist(membership);
        this.getEntityManager().flush();
        groupRole = new SimpleGroupRole((IdentityType)storedUser, storedRole, storedGroup);
        return groupRole;
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        Object identityRole;
        Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
        Property<Object> roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
        Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getMembershipClass());
        Root root = criteria.from(this.getConfig().getMembershipClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Object identityUser = this.lookupIdentityObjectById(member);
        predicates.add(builder.equal((Expression)root.get(memberModelProperty.getName()), identityUser));
        if (group != null && role != null) {
            identityRole = this.lookupIdentityObjectById((IdentityType)role);
            Object identityGroup = this.lookupIdentityObjectById((IdentityType)group);
            predicates.add(builder.equal((Expression)root.get(roleModelProperty.getName()), identityRole));
            predicates.add(builder.equal((Expression)root.get(groupModelProperty.getName()), identityGroup));
        } else {
            if (role != null) {
                identityRole = this.lookupIdentityObjectById((IdentityType)role);
                predicates.add(builder.equal((Expression)root.get(roleModelProperty.getName()), identityRole));
            }
            if (group != null) {
                Object identityGroup = this.lookupIdentityObjectById((IdentityType)group);
                predicates.add(builder.equal((Expression)root.get(groupModelProperty.getName()), identityGroup));
            }
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List resultList = em.createQuery(criteria).getResultList();
        for (Object object : resultList) {
            em.remove(object);
        }
        em.flush();
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        SimpleGroupRole groupRole = null;
        List<Object> resultList = Collections.emptyList();
        DefaultIdentityQuery defaultIdentityQuery = new DefaultIdentityQuery(member.getClass(), this);
        defaultIdentityQuery.setParameter(IdentityType.HAS_GROUP_ROLE, new SimpleGroupRole(member, role, group));
        resultList = defaultIdentityQuery.getResultList();
        if (!resultList.isEmpty()) {
            User storedUser = this.getUser(((User)member).getId());
            Role storedRole = null;
            Group storedGroup = null;
            if (role != null) {
                storedRole = this.getRole(role.getName());
            }
            if (group != null) {
                storedGroup = this.getGroup(group.getName());
            }
            groupRole = new SimpleGroupRole((IdentityType)storedUser, storedRole, storedGroup);
        }
        return groupRole;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> providedAttrib) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identity, String name) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    protected EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }

    private void storeAttribute(Object identity, Attribute<? extends Serializable> userAttribute) {
        Serializable value = userAttribute.getValue();
        Object[] values = null;
        values = value.getClass().isArray() ? (Object[])value : new Object[]{value};
        Property<Object> attributeNameProperty = this.getAttributeNameProperty();
        Property<Object> attributeIdentityProperty = this.getAttributeIdentityProperty();
        Property<Object> attributeValueProperty = this.getAttributeValueProperty();
        try {
            for (Object attribValue : values) {
                Object newInstance = this.getConfig().getAttributeClass().newInstance();
                attributeNameProperty.setValue(newInstance, userAttribute.getName());
                attributeValueProperty.setValue(newInstance, attribValue);
                attributeIdentityProperty.setValue(newInstance, identity);
                this.getEntityManager().persist(newInstance);
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error creating attributes.", (Throwable)e);
        }
    }

    private void removeAttributes(Object identity, List<String> attributesToRetain) {
        StringBuffer attributeNames = new StringBuffer();
        for (String string : attributesToRetain) {
            if (attributeNames.length() != 0) {
                attributeNames.append(",");
            }
            attributeNames.append("'").append(string).append("'");
        }
        List<?> storedAttributes = this.findAttributes(identity);
        for (Object attribute : storedAttributes) {
            String attributeName = this.getAttributeNameProperty().getValue(attribute).toString();
            if (attributesToRetain.contains(attributeName)) continue;
            this.getEntityManager().remove(attribute);
        }
    }

    private void removeAllAttributes(Object identity) {
        this.removeAttributes(identity, Collections.<String>emptyList());
    }

    private List<?> findAttributes(IdentityType identityType, String idValue, Attribute<? extends Serializable> userAttribute) {
        Property<Object> attributeIdentityProperty = this.getAttributeIdentityProperty();
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        Join join = root.join(attributeIdentityProperty.getName());
        if (this.isUserType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)join.get(this.getIdentityIdProperty().getName()), (Object)idValue));
        } else {
            predicates.add(builder.equal((Expression)join.get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), (Object)idValue));
        }
        predicates.add(builder.equal((Expression)root.get(this.getAttributeNameProperty().getName()), (Object)userAttribute.getName()));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private List<?> findAttributes(Object object) {
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
        Root root = criteria.from(this.getConfig().getAttributeClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getAttributeIdentityProperty().getName()), object));
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        return em.createQuery(criteria).getResultList();
    }

    private Property<Object> getIdentityIdProperty() {
        return this.getConfig().getModelProperty("IDENTITY_ID");
    }

    private Property<Object> getAttributeIdentityProperty() {
        return this.getConfig().getModelProperty("ATTRIBUTE_IDENTITY");
    }

    private Property<Object> getAttributeNameProperty() {
        return this.getConfig().getModelProperty("ATTRIBUTE_NAME");
    }

    private Property<Object> getAttributeValueProperty() {
        return this.getConfig().getModelProperty("ATTRIBUTE_VALUE");
    }

    protected Object lookupIdentityObjectById(IdentityType identityType) {
        String id = this.getIdentifierValue(identityType);
        if (id == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_DISCRIMINATOR").getName()), (Object)this.getIdentityDiscriminator(identityType.getClass())));
        if (this.isUserType(identityType.getClass()) || this.isAgentType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)root.get(this.getIdentityIdProperty().getName()), (Object)id));
        } else if (this.isGroupType(identityType.getClass()) || this.isRoleType(identityType.getClass())) {
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), (Object)id));
        } else {
            throw new SecurityException("Could not lookup identity by id - unsupported IdentityType [" + identityType.getClass().getName() + "]");
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new SecurityException("Error looking up identity by id - ambiguous identities found for id: [" + id + "]");
    }

    private Object lookupIdentityObjectByKey(String key) {
        if (key == null) {
            return null;
        }
        EntityManager em = this.getEntityManager();
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(this.getConfig().getIdentityClass());
        Root root = criteria.from(this.getConfig().getIdentityClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_KEY").getName()), (Object)key));
        if (this.getConfig().isModelPropertySet("IDENTITY_PARTITION")) {
            if (key.startsWith("USER://")) {
                if (this.getContext().getRealm() == null) {
                    throw new SecurityException("Cannot look up User key without a provided realm.");
                }
                predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_PARTITION").getName()), this.lookupPartitionObject((Partition)this.getContext().getRealm())));
            } else if (key.startsWith("GROUP://") || key.startsWith("ROLE://")) {
                if (this.getContext().getRealm() != null && this.getContext().getTier() != null) {
                    throw new SecurityException("Ambiguous lookup for key [" + key + "] - both Realm and Tier have been specified in context.");
                }
                if (this.getContext().getRealm() != null) {
                    predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_PARTITION").getName()), this.lookupPartitionObject((Partition)this.getContext().getRealm())));
                } else if (this.getContext().getTier() != null) {
                    predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("IDENTITY_PARTITION").getName()), this.lookupPartitionObject((Partition)this.getContext().getTier())));
                } else {
                    throw new SecurityException("Cannot look up key [" + key + "] without a provided realm or tier.");
                }
            }
        }
        criteria.where(predicates.toArray(new Predicate[predicates.size()]));
        List results = em.createQuery(criteria).getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() == 1) {
            return results.get(0);
        }
        throw new SecurityException("Error looking up identity by key - ambiguous identities found for key: [" + key + "]");
    }

    private void removeMemberships(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getMembershipClass() != null) {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getMembershipClass());
            Root root = criteria.from(this.getConfig().getMembershipClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_MEMBER").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
            criteria = builder.createQuery(this.getConfig().getMembershipClass());
            root = criteria.from(this.getConfig().getMembershipClass());
            predicates.clear();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_GROUP").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
            criteria = builder.createQuery(this.getConfig().getMembershipClass());
            root = criteria.from(this.getConfig().getMembershipClass());
            predicates.clear();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("MEMBERSHIP_ROLE").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void removeAttributes(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getAttributeClass() != null) {
            List<?> results = this.findAttributes(object);
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    private void removeCredentials(Object object) {
        EntityManager em = this.getEntityManager();
        if (this.getConfig().getCredentialClass() != null) {
            CriteriaBuilder builder = em.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(this.getConfig().getCredentialClass());
            Root root = criteria.from(this.getConfig().getCredentialClass());
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            predicates.add(builder.equal((Expression)root.get(this.getConfig().getModelProperty("CREDENTIAL_IDENTITY").getName()), object));
            criteria.where(predicates.toArray(new Predicate[predicates.size()]));
            List results = em.createQuery(criteria).getResultList();
            for (Object result : results) {
                em.remove(result);
            }
        }
    }

    <P> P getModelProperty(Class<P> propertyType, Object instance, String propertyName) {
        Property<Object> property = this.getConfig().getModelProperty(propertyName);
        return (P)(property == null ? null : property.getValue(instance));
    }

    void setModelProperty(Object instance, String propertyName, Object value) {
        this.setModelProperty(instance, propertyName, value, false);
    }

    void setModelProperty(Object instance, String propertyName, Object value, boolean required) {
        if (this.getConfig().isModelPropertySet(propertyName)) {
            this.getConfig().getModelProperty(propertyName).setValue(instance, value);
        } else if (required) {
            throw new IdentityManagementException("Model property [" + propertyName + "] has not been configured.");
        }
    }

    String getIdentityDiscriminator(Class<? extends IdentityType> identityType) {
        return this.getConfig().getIdentityTypeDiscriminator(identityType);
    }

    private void updateAttributes(IdentityType identityType, Object identity) {
        EntityManager em = this.getEntityManager();
        if (identityType.getAttributes() != null && !identityType.getAttributes().isEmpty()) {
            ArrayList<String> attributesToRetain = new ArrayList<String>();
            for (Attribute userAttribute : identityType.getAttributes()) {
                attributesToRetain.add(userAttribute.getName());
                try {
                    JPAIdentityStoreConfiguration.MappedAttribute mappedAttribute = this.getConfig().getAttributeProperties().get(userAttribute.getName());
                    if (mappedAttribute != null) {
                        for (String attribName : this.getConfig().getAttributeProperties().keySet()) {
                            JPAIdentityStoreConfiguration.MappedAttribute attrib = this.getConfig().getAttributeProperties().get(attribName);
                            if (!userAttribute.getName().equals(attribName)) continue;
                            attrib.getAttributeProperty().setValue(identity, userAttribute.getValue());
                        }
                        continue;
                    }
                    List<?> results = this.findAttributes(identityType, this.getIdentifierValue(identityType), (Attribute<? extends Serializable>)userAttribute);
                    for (Object object : results) {
                        em.remove(object);
                    }
                    this.storeAttribute(identity, (Attribute<? extends Serializable>)userAttribute);
                }
                catch (Exception e) {
                    throw new IdentityManagementException("Error setting attribute [" + userAttribute + "] for [" + identity + "]", (Throwable)e);
                }
            }
            if (attributesToRetain.isEmpty()) {
                this.removeAllAttributes(identity);
            } else {
                this.removeAttributes(identity, attributesToRetain);
            }
        }
    }

    private String getIdentifierValue(IdentityType identityType) {
        String value = null;
        if (this.isUserType(identityType.getClass())) {
            value = ((User)identityType).getId();
        } else if (this.isAgentType(identityType.getClass())) {
            value = ((Agent)identityType).getId();
        } else if (this.isRoleType(identityType.getClass())) {
            value = ((Role)identityType).getName();
        } else if (this.isGroupType(identityType.getClass())) {
            value = ((Group)identityType).getName();
        }
        return value;
    }

    private void populateAttributes(IdentityType identityType, Object identity) {
        try {
            for (JPAIdentityStoreConfiguration.MappedAttribute attrib : this.getConfig().getAttributeProperties().values()) {
                if (attrib.getIdentityProperty() != null && attrib.getIdentityProperty().getValue(identity) == null) continue;
                Member member = attrib.getAttributeProperty().getMember();
                String mappedName = null;
                Object value = null;
                if (member instanceof Field) {
                    Field field = (Field)member;
                    IDMAttribute annotation = field.getAnnotation(IDMAttribute.class);
                    field.setAccessible(true);
                    mappedName = annotation.name();
                    value = field.get(identity);
                }
                identityType.setAttribute(new Attribute(mappedName, (Serializable)value));
            }
            if (this.getConfig().getAttributeClass() != null) {
                EntityManager em = this.getEntityManager();
                CriteriaBuilder builder = em.getCriteriaBuilder();
                CriteriaQuery criteria = builder.createQuery(this.getConfig().getAttributeClass());
                Root attributeClassRoot = criteria.from(this.getConfig().getAttributeClass());
                ArrayList<Predicate> predicates = new ArrayList<Predicate>();
                Join identityPropertyJoin = attributeClassRoot.join(this.getAttributeIdentityProperty().getName());
                String propertyNameToJoin = this.getIdentityIdProperty().getName();
                if (this.isRoleType(identityType.getClass()) || this.isGroupType(identityType.getClass())) {
                    propertyNameToJoin = this.getConfig().getModelProperty("IDENTITY_NAME").getName();
                }
                predicates.add(builder.equal((Expression)identityPropertyJoin.get(propertyNameToJoin), (Object)this.getIdentifierValue(identityType)));
                criteria.where(predicates.toArray(new Predicate[predicates.size()]));
                List results = em.createQuery(criteria).getResultList();
                if (!results.isEmpty()) {
                    for (Object object : results) {
                        Property<Object> attributeNameProperty = this.getAttributeNameProperty();
                        Property<Object> attributeValueProperty = this.getAttributeValueProperty();
                        String attribName = (String)attributeNameProperty.getValue(object);
                        Serializable attribValue = (Serializable)attributeValueProperty.getValue(object);
                        Attribute identityTypeAttribute = identityType.getAttribute(attribName);
                        if (identityTypeAttribute == null) {
                            identityTypeAttribute = new Attribute(attribName, attribValue);
                            identityType.setAttribute(identityTypeAttribute);
                            continue;
                        }
                        if (identityTypeAttribute.getValue() == null) continue;
                        String[] values = null;
                        values = identityTypeAttribute.getValue().getClass().isArray() ? (String[])identityTypeAttribute.getValue() : new String[]{identityTypeAttribute.getValue().toString()};
                        String[] newValues = Arrays.copyOf(values, values.length + 1);
                        newValues[newValues.length - 1] = attribValue.toString();
                        identityTypeAttribute.setValue((Serializable)newValues);
                        identityType.setAttribute(identityTypeAttribute);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException("Error setting attribute.", (Throwable)e);
        }
    }

    private Partition convertPartitionEntityToPartition(Object instance) {
        return null;
    }

    Object lookupPartitionObject(Partition partition) {
        return null;
    }

    private void checkInvalidIdentityType(IdentityType identityType) throws IdentityManagementException {
        if (identityType == null) {
            throw new IdentityManagementException("The provided IdentityType instance is invalid or was null.");
        }
    }

    private Object getIdentityObject(IdentityType identityType) throws IdentityManagementException {
        Object identity = this.lookupIdentityObjectById(identityType);
        if (identity == null) {
            throw new IdentityManagementException("The provided IdentityType instance does not exists.");
        }
        return identity;
    }

    IdentityTypeManager<IdentityType> getIdentityTypeManager(Class<? extends IdentityType> identityTypeClass) {
        IdentityTypeManager<IdentityType> identityTypeManager = this.identityTypeStores.get(this.getIdentityDiscriminator(identityTypeClass));
        return identityTypeManager;
    }
}

