/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.RoleCreatedEvent;
import org.picketlink.idm.event.RoleDeletedEvent;
import org.picketlink.idm.event.RoleUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.query.QueryParameter;

public class RoleTypeManager
extends IdentityTypeManager<Role> {
    public RoleTypeManager(JPAIdentityStore store) {
        super(store);
    }

    @Override
    protected void fromIdentityType(Object toIdentity, Role fromRole) {
        this.getStore().setModelProperty(toIdentity, "IDENTITY_NAME", fromRole.getName(), true);
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(Role fromIdentityType) {
        return new RoleCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(Role fromIdentityType) {
        return new RoleUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(Role fromIdentityType) {
        return new RoleDeletedEvent(fromIdentityType);
    }

    @Override
    protected Role createIdentityType(Object identity) {
        String name = this.getStore().getModelProperty(String.class, identity, "IDENTITY_NAME");
        SimpleRole role = new SimpleRole(name);
        return role;
    }

    @Override
    protected List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria) {
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria);
        if (queryParameter.equals(Role.NAME)) {
            predicates.add(criteria.getBuilder().equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.ROLE_OF)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
                Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getMembershipClass());
                Root fromProject = subquery.from(this.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(roleModelProperty.getName()));
                Predicate conjunction = criteria.getBuilder().conjunction();
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(roleModelProperty.getName()), criteria.getRoot()));
                conjunction.getExpressions().add(criteria.getBuilder().equal((Expression)fromProject.get(memberModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)object)));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)criteria.getBuilder().in(criteria.getRoot()).value((Expression)subquery));
            }
        }
        return predicates;
    }
}

