/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.internal.util.properties.Property;
import org.picketlink.idm.jpa.internal.IdentityTypeManager;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.QueryParameter;

public class UserTypeManager
extends IdentityTypeManager<User> {
    public UserTypeManager(JPAIdentityStore store) {
        super(store);
    }

    @Override
    protected void fromIdentityType(Object toIdentity, User fromUser) {
        this.getStore().setModelProperty(toIdentity, "IDENTITY_ID", fromUser.getId(), true);
        this.getStore().setModelProperty(toIdentity, "USER_FIRST_NAME", fromUser.getFirstName());
        this.getStore().setModelProperty(toIdentity, "USER_LAST_NAME", fromUser.getLastName());
        this.getStore().setModelProperty(toIdentity, "USER_EMAIL", fromUser.getEmail());
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(User fromIdentityType) {
        return new UserCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(User fromIdentityType) {
        return new UserUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(User fromIdentityType) {
        return new UserDeletedEvent(fromIdentityType);
    }

    @Override
    protected List<Predicate> getPredicate(QueryParameter queryParameter, Object[] parameterValues, JPACriteriaQueryBuilder criteria) {
        Property<Object> roleModelProperty;
        Property<Object> memberModelProperty;
        List<Predicate> predicates = super.getPredicate(queryParameter, parameterValues, criteria);
        CriteriaBuilder builder = criteria.getBuilder();
        Root<?> root = criteria.getRoot();
        if (queryParameter.equals(User.ID)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("IDENTITY_ID").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(User.FIRST_NAME)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("USER_FIRST_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(User.LAST_NAME)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("USER_LAST_NAME").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(User.EMAIL)) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty("USER_EMAIL").getName()), parameterValues[0]));
        }
        if (queryParameter.equals(IdentityType.HAS_GROUP_ROLE)) {
            for (Object object : parameterValues) {
                GroupRole groupRole = (GroupRole)object;
                memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
                Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getMembershipClass());
                Root fromProject = subquery.from(this.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), root));
                if (groupRole.getMember() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), this.getStore().lookupIdentityObjectById(groupRole.getMember())));
                }
                if (groupRole.getRole() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(roleModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)groupRole.getRole())));
                }
                if (groupRole.getGroup() != null) {
                    conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(groupModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)groupRole.getGroup())));
                }
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        if (queryParameter.equals(IdentityType.MEMBER_OF)) {
            for (Object object : parameterValues) {
                Property<Object> memberModelProperty2 = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                Property<Object> groupModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_GROUP");
                Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getMembershipClass());
                Root fromProject = subquery.from(this.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty2.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty2.getName()), root));
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(groupModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)new SimpleGroup(object.toString()))));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        if (queryParameter.equals(IdentityType.HAS_ROLE)) {
            for (Object object : parameterValues) {
                String roleName = (String)parameterValues[0];
                memberModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_MEMBER");
                roleModelProperty = this.getConfig().getModelProperty("MEMBERSHIP_ROLE");
                Subquery subquery = criteria.getCriteria().subquery(this.getConfig().getMembershipClass());
                Root fromProject = subquery.from(this.getConfig().getMembershipClass());
                Subquery select = subquery.select((Expression)fromProject.get(memberModelProperty.getName()));
                Predicate conjunction = builder.conjunction();
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(memberModelProperty.getName()), root));
                conjunction.getExpressions().add(builder.equal((Expression)fromProject.get(roleModelProperty.getName()), this.getStore().lookupIdentityObjectById((IdentityType)new SimpleRole(object.toString()))));
                subquery.where((Expression)conjunction);
                predicates.add((Predicate)builder.in(root).value((Expression)subquery));
            }
        }
        return predicates;
    }

    @Override
    protected User createIdentityType(Object identity) {
        String idValue = this.getConfig().getModelProperty("IDENTITY_ID").getValue(identity).toString();
        SimpleUser user = new SimpleUser(idValue);
        user.setFirstName(this.getStore().getModelProperty(String.class, identity, "USER_FIRST_NAME"));
        user.setLastName(this.getStore().getModelProperty(String.class, identity, "USER_LAST_NAME"));
        user.setEmail(this.getStore().getModelProperty(String.class, identity, "USER_EMAIL"));
        return user;
    }
}

