/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.directory.BasicAttribute;
import org.picketlink.idm.ldap.internal.LDAPConstants;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;

public class LDAPGroupRole
extends LDAPEntry
implements GroupRole {
    private static final long serialVersionUID = 1L;
    private LDAPUser user;
    private LDAPGroup group;
    private LDAPRole role;

    public LDAPGroupRole(LDAPUser user, LDAPGroup group, LDAPRole role) {
        super(user.getDN());
        this.user = user;
        this.group = group;
        this.role = role;
        BasicAttribute oc = new BasicAttribute("objectclass");
        oc.add("top");
        oc.add(LDAPConstants.GROUP_OF_NAMES);
        this.getLDAPAttributes().put(oc);
        this.getLDAPAttributes().put("member", this.role.getDN());
    }

    @Override
    public String getDN() {
        return "cn=" + this.group.getName() + "," + this.user.getDN();
    }

    public IdentityType getMember() {
        return this.user;
    }

    public Group getGroup() {
        return this.group;
    }

    public Role getRole() {
        return this.role;
    }

    public String getKey() {
        return null;
    }
}

