/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPConfiguration;
import org.picketlink.idm.ldap.internal.LDAPCustomAttributes;
import org.picketlink.idm.ldap.internal.LDAPEntry;
import org.picketlink.idm.ldap.internal.LDAPGroup;
import org.picketlink.idm.ldap.internal.LDAPGroupRole;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPQuery;
import org.picketlink.idm.ldap.internal.LDAPRole;
import org.picketlink.idm.ldap.internal.LDAPSearchCallback;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroupRole;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class LDAPIdentityStore
extends AbstractIdentityStore<LDAPConfiguration> {
    private LDAPConfiguration configuration;
    private IdentityStoreInvocationContext context;

    public void setup(LDAPConfiguration config, IdentityStoreInvocationContext context) {
        this.configuration = config;
        this.context = context;
    }

    public LDAPConfiguration getConfig() {
        return this.configuration;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public Agent getAgent(String id) {
        return this.getUser(id);
    }

    public User getUser(String id) {
        final String baseDN = this.configuration.getUserDNSuffix();
        List<User> answer = this.getLdapManager().searchByAttribute(baseDN, "uid", id, new LDAPSearchCallback<User>(){

            @Override
            public User processResult(SearchResult sr) {
                LDAPUser user = new LDAPUser(baseDN, sr.getAttributes());
                user.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(user.getDN()));
                return user;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Group getGroup(String name) {
        final String baseDN = this.configuration.getGroupDNSuffix();
        List<Group> answer = this.getLdapManager().searchByAttribute(baseDN, "cn", name, new LDAPSearchCallback<Group>(){

            @Override
            public Group processResult(SearchResult sr) {
                LDAPGroup ldapGroup = new LDAPGroup(sr.getAttributes(), baseDN);
                ldapGroup.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(ldapGroup.getDN()));
                Group parentGroup = LDAPIdentityStore.this.getParentGroup(ldapGroup);
                if (parentGroup != null) {
                    ldapGroup.setParentGroup(parentGroup);
                }
                return ldapGroup;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Role getRole(String name) {
        final String baseDN = this.configuration.getRoleDNSuffix();
        List<Role> answer = this.getLdapManager().searchByAttribute(baseDN, "cn", name, new LDAPSearchCallback<Role>(){

            @Override
            public Role processResult(SearchResult sr) {
                LDAPRole ldapRole = new LDAPRole(sr.getAttributes(), baseDN);
                ldapRole.setCustomAttributes(LDAPIdentityStore.this.getCustomAttributes(ldapRole.getDN()));
                return ldapRole;
            }
        });
        return answer.isEmpty() ? null : answer.get(0);
    }

    public Group getGroup(String name, Group parent) {
        Group ldapGroup = this.getGroup(name);
        Group ldapGroupParent = ldapGroup.getParentGroup();
        if (parent != null && ldapGroup != null && ldapGroupParent != null && ldapGroupParent.getName().equals(parent.getName())) {
            return ldapGroup;
        }
        return null;
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        if (member instanceof User) {
            User user = this.getUser(((User)member).getId());
            LDAPRole ldapRole = null;
            if (role != null) {
                ldapRole = (LDAPRole)this.getRole(role.getName());
            }
            LDAPUser ldapUser = null;
            if (user != null) {
                ldapUser = (LDAPUser)this.getUser(user.getId());
            }
            LDAPGroup ldapGroup = null;
            if (group != null) {
                ldapGroup = (LDAPGroup)this.getGroup(group.getName());
            }
            if (ldapRole != null && ldapGroup != null) {
                LDAPGroupRole groupRole = new LDAPGroupRole(ldapUser, ldapGroup, ldapRole);
                this.storeMembershipEntry(groupRole, ldapRole);
            } else {
                if (ldapUser != null && ldapRole != null) {
                    this.addMember(ldapRole, ldapUser);
                }
                if (ldapGroup != null && ldapRole != null) {
                    this.addMember(ldapGroup, ldapRole);
                }
                if (ldapGroup != null && ldapUser != null) {
                    this.addMember(ldapGroup, ldapUser);
                }
            }
            return new SimpleGroupRole((IdentityType)ldapUser, (Role)ldapRole, (Group)ldapGroup);
        }
        if (member instanceof Group) {
            return null;
        }
        throw new IllegalArgumentException("The member parameter must be an instance of User or Group");
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        if (member instanceof User) {
            LDAPUser ldapUser = (LDAPUser)this.getUser(((User)member).getId());
            LDAPRole ldapRole = null;
            if (role != null) {
                ldapRole = (LDAPRole)this.getRole(role.getName());
            }
            LDAPGroup ldapGroup = null;
            if (group != null) {
                ldapGroup = (LDAPGroup)this.getGroup(group.getName());
            }
            if (group != null && role != null) {
                LDAPGroupRole groupRole = new LDAPGroupRole(ldapUser, ldapGroup, ldapRole);
                this.removeMemberShipEntry(groupRole, ldapRole);
            } else {
                if (ldapRole != null) {
                    this.removeMember(ldapRole, ldapUser);
                }
                if (ldapGroup != null) {
                    this.removeMember(ldapGroup, ldapUser);
                }
            }
        } else if (member instanceof Group) {
            // empty if block
        }
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        SimpleGroupRole groupRole = null;
        LDAPUser ldapUser = (LDAPUser)this.getUser(((User)member).getId());
        if (group != null && role != null) {
            LDAPRole ldapRole = (LDAPRole)this.getRole(role.getName());
            LDAPGroup ldapGroup = (LDAPGroup)this.getGroup(group.getName());
            String dn = new LDAPGroupRole(ldapUser, ldapGroup, ldapRole).getDN();
            groupRole = (GroupRole)this.getLdapManager().lookup(dn);
            LDAPGroupRole ldapGroupRole = (LDAPGroupRole)groupRole;
            if (groupRole == null || !ldapGroupRole.isMember(ldapRole)) {
                groupRole = null;
            }
        } else {
            LDAPGroup ldapGroup;
            LDAPRole ldapRole;
            if (role != null && (ldapRole = (LDAPRole)this.getRole(role.getName())).isMember(ldapUser)) {
                groupRole = new SimpleGroupRole((IdentityType)ldapUser, this.getRole(role.getName()), null);
            }
            if (group != null && (ldapGroup = (LDAPGroup)this.getGroup(group.getName())).isMember(ldapUser)) {
                groupRole = new SimpleGroupRole((IdentityType)ldapUser, null, group);
            }
        }
        return groupRole;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        ArrayList<Object> result = new ArrayList<Object>();
        String filter = this.getSearchFilter(identityQuery);
        Class typeClass = identityQuery.getIdentityType();
        NamingEnumeration<SearchResult> answer = null;
        if (filter == null) {
            return result;
        }
        LDAPQuery ldapQuery = new LDAPQuery(identityQuery.getParameters());
        String idAttribute = this.getIdAttribute(typeClass);
        String dnSuffix = this.getBaseDN(typeClass);
        try {
            answer = this.getLdapManager().search(dnSuffix, filter);
            while (answer.hasMoreElements()) {
                long providedDateInMillis;
                Object[] values;
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String uid = (String)attributes.get(idAttribute).get();
                LDAPCustomAttributes customAttributes = this.getCustomAttributes(idAttribute + "=" + uid + "," + dnSuffix);
                if (ldapQuery.hasCustomAttributes() && customAttributes == null) continue;
                if (identityQuery.getParameters().containsKey(IdentityType.ENABLED)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.ENABLED);
                    String enabled = String.valueOf(customAttributes.getAttribute("enabled"));
                    if (!enabled.equals(values[0].toString())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_DATE)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_DATE);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis != (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_BEFORE)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_BEFORE);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis > (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.CREATED_AFTER)) {
                    values = (Object[])identityQuery.getParameters().get(IdentityType.CREATED_AFTER);
                    long storedDateInMillis = Long.valueOf(customAttributes.getAttribute("createDate").toString());
                    if (storedDateInMillis < (providedDateInMillis = ((Date)values[0]).getTime())) continue;
                }
                if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE) || identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                    long providedDateInMillis2;
                    long storedDateInMillis;
                    Object[] values2;
                    Object expiryAttribute = customAttributes.getAttribute("expiryDate");
                    if (expiryAttribute == null) continue;
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_DATE)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_DATE);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis != (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_BEFORE)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_BEFORE);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis > (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                    if (identityQuery.getParameters().containsKey(IdentityType.EXPIRY_AFTER)) {
                        values2 = (Object[])identityQuery.getParameters().get(IdentityType.EXPIRY_AFTER);
                        storedDateInMillis = Long.valueOf(expiryAttribute.toString());
                        if (storedDateInMillis < (providedDateInMillis2 = ((Date)values2[0]).getTime())) continue;
                    }
                }
                boolean match = true;
                for (Map.Entry ldapQueryParameter : identityQuery.getParameters().entrySet()) {
                    QueryParameter queryParameter = (QueryParameter)ldapQueryParameter.getKey();
                    Object[] values3 = (Object[])ldapQueryParameter.getValue();
                    if (!(queryParameter instanceof IdentityType.AttributeParameter)) continue;
                    match = false;
                    Object[] queryParameterValues = values3;
                    IdentityType.AttributeParameter customParameter = (IdentityType.AttributeParameter)queryParameter;
                    Object customParameterValue = customAttributes.getAttribute(customParameter.getName());
                    if (customParameterValue == null) continue;
                    int count = queryParameterValues.length;
                    for (Object parameterValue : queryParameterValues) {
                        if (customParameterValue.getClass().isArray()) {
                            Object[] customParameterValues;
                            for (Object value : customParameterValues = (Object[])customParameterValue) {
                                if (!value.equals(parameterValue)) continue;
                                --count;
                            }
                            continue;
                        }
                        if (!parameterValue.equals(customParameterValue)) continue;
                        --count;
                    }
                    if (count > 0) continue;
                    match = true;
                }
                if (!match) continue;
                if (this.isUserType(typeClass)) {
                    result.add(this.getUser(uid));
                    continue;
                }
                if (this.isRoleType(typeClass)) {
                    result.add(this.getRole(uid));
                    continue;
                }
                if (!this.isGroupType(typeClass)) continue;
                result.add(this.getGroup(uid));
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException(ne);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return result;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        throw this.createNotImplementedYetException();
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        throw this.createNotImplementedYetException();
    }

    public void setAttribute(IdentityType identity, Attribute<? extends Serializable> attribute) {
        throw this.createNotImplementedYetException();
    }

    public void removeAttribute(IdentityType identity, String name) {
        throw this.createNotImplementedYetException();
    }

    private LDAPUser convert(User user) {
        LDAPUser ldapUser = null;
        if (user instanceof LDAPUser) {
            ldapUser = (LDAPUser)user;
        } else {
            ldapUser = new LDAPUser(this.configuration.getUserDNSuffix());
            ldapUser.setId(user.getId());
            ldapUser.setFirstName(" ");
            ldapUser.setLastName(" ");
            if (user.getFirstName() != null) {
                ldapUser.setFirstName(user.getFirstName());
            }
            if (user.getLastName() != null) {
                ldapUser.setLastName(user.getLastName());
            }
            if (user.getEmail() != null) {
                ldapUser.setEmail(user.getEmail());
            }
            if (user.getExpirationDate() != null) {
                ldapUser.setExpirationDate(user.getExpirationDate());
            }
            for (Attribute attrib : user.getAttributes()) {
                ldapUser.setAttribute((Attribute<? extends Serializable>)attrib);
            }
        }
        return ldapUser;
    }

    private LDAPCustomAttributes getCustomAttributes(String parentDN) {
        String customDN = this.getCustomAttributesDN(parentDN);
        LDAPCustomAttributes customAttributes = null;
        try {
            customAttributes = (LDAPCustomAttributes)this.getLdapManager().lookup(customDN);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return customAttributes;
    }

    private String getCustomAttributesDN(String parentDN) {
        return "cn=custom-attributes," + parentDN;
    }

    private void store(LDAPEntry ldapEntry) {
        this.getLdapManager().bind(ldapEntry.getDN(), ldapEntry);
        this.getLdapManager().bind(this.getCustomAttributesDN(ldapEntry.getDN()), ldapEntry.getCustomAttributes());
    }

    private void addMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.addMember(childEntry);
        this.getLdapManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private void removeMember(LDAPEntry parentEntry, LDAPEntry childEntry) {
        parentEntry.removeMember(childEntry);
        this.getLdapManager().modifyAttribute(parentEntry.getDN(), parentEntry.getLDAPAttributes().get("member"));
    }

    private void removeEntry(LDAPEntry ldapEntry) {
        this.getLdapManager().destroySubcontext(ldapEntry.getDN());
    }

    private Group getParentGroup(LDAPGroup childGroup) {
        BasicAttributes matchAttrs = new BasicAttributes(true);
        matchAttrs.put(new BasicAttribute("member", "cn=" + childGroup.getName() + "," + this.configuration.getGroupDNSuffix()));
        NamingEnumeration<SearchResult> answer = null;
        try {
            answer = this.getLdapManager().search(this.configuration.getGroupDNSuffix(), matchAttrs, new String[]{"cn"});
            if (answer.hasMoreElements()) {
                SearchResult sr = (SearchResult)answer.nextElement();
                Attributes attributes = sr.getAttributes();
                String cn = (String)attributes.get("cn").get();
                Group group = this.getGroup(cn);
                return group;
            }
        }
        catch (NamingException e) {
            throw new RuntimeException("Error looking parent group for [" + childGroup.getDN() + "]", e);
        }
        finally {
            if (answer != null) {
                try {
                    answer.close();
                }
                catch (NamingException e) {}
            }
        }
        return null;
    }

    private void updateAttributes(LDAPEntry updatedEntryEntry, LDAPEntry storedEntry) {
        try {
            javax.naming.directory.Attribute updatedAttribute;
            NamingEnumeration<? extends javax.naming.directory.Attribute> storedAttributes = storedEntry.getLDAPAttributes().getAll();
            while (storedAttributes.hasMore()) {
                javax.naming.directory.Attribute storedAttribute = storedAttributes.next();
                updatedAttribute = updatedEntryEntry.getLDAPAttributes().get(storedAttribute.getID());
                if (updatedAttribute != null) {
                    this.getLdapManager().modifyAttribute(storedEntry.getDN(), updatedAttribute);
                    continue;
                }
                this.getLdapManager().removeAttribute(storedEntry.getDN(), storedAttribute);
            }
            NamingEnumeration<? extends javax.naming.directory.Attribute> enumUpdatedAttributes = updatedEntryEntry.getLDAPAttributes().getAll();
            while (enumUpdatedAttributes.hasMore()) {
                updatedAttribute = enumUpdatedAttributes.next();
                javax.naming.directory.Attribute storedAttribute = storedEntry.getLDAPAttributes().get(updatedAttribute.getID());
                if (storedAttribute != null || !this.getLdapManager().isManagedAttribute(updatedAttribute.getID())) continue;
                this.getLdapManager().addAttribute(storedEntry.getDN(), updatedAttribute);
            }
            LDAPCustomAttributes attributes = updatedEntryEntry.getCustomAttributes();
            this.getLdapManager().rebind(this.getCustomAttributesDN(updatedEntryEntry.getDN()), attributes);
        }
        catch (NamingException e) {
            throw new IdentityManagementException("Error updating custom attributes for IdentityType [" + storedEntry + "].", (Throwable)e);
        }
    }

    private NamingEnumeration<SearchResult> findParentEntries(String dnSuffix, LDAPEntry member) {
        String filter = "(member=" + member.getDN() + ")";
        return this.getLdapManager().search(dnSuffix, filter);
    }

    private void removeFromParent(String dnSuffix, LDAPEntry member) {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.findParentEntries(dnSuffix, member);
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                javax.naming.directory.Attribute memberAttribute = searchResult.getAttributes().get("member");
                if (memberAttribute != null) {
                    memberAttribute.remove(member.getDN());
                }
                if (memberAttribute.getAll().hasMoreElements()) continue;
                memberAttribute.add(" ");
            }
        }
        catch (NamingException ne) {
            throw new IdentityManagementException((Throwable)ne);
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException e) {}
            }
        }
    }

    private void storeMembershipEntry(LDAPEntry ldapEntry, LDAPEntry member) {
        String dn = ldapEntry.getDN();
        LDAPEntry storedGroupRole = (LDAPEntry)this.getLdapManager().lookup(dn);
        if (storedGroupRole == null) {
            storedGroupRole = ldapEntry;
            this.getLdapManager().bind(dn, storedGroupRole);
        } else {
            javax.naming.directory.Attribute memberAttribute = storedGroupRole.getLDAPAttributes().get("member");
            if (!memberAttribute.contains(member.getDN())) {
                memberAttribute.add(member.getDN());
                this.getLdapManager().modifyAttribute(dn, memberAttribute);
                this.getLdapManager().rebind(dn, storedGroupRole);
            }
        }
    }

    private void removeMemberShipEntry(LDAPEntry ldapEntry, LDAPEntry member) {
        javax.naming.directory.Attribute memberAttribute;
        String dn = ldapEntry.getDN();
        LDAPEntry storedGroupRole = (LDAPEntry)this.getLdapManager().lookup(dn);
        if (storedGroupRole != null && (memberAttribute = storedGroupRole.getLDAPAttributes().get("member")).contains(member.getDN())) {
            memberAttribute.remove(member.getDN());
            memberAttribute.add(" ");
            this.getLdapManager().modifyAttribute(dn, memberAttribute);
            this.getLdapManager().rebind(dn, storedGroupRole);
        }
    }

    public LDAPOperationManager getLdapManager() {
        return this.configuration.getLdapManager();
    }

    @Override
    protected Role addRole(Role role) {
        if (role.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPRole ldapRole = new LDAPRole(this.configuration.getRoleDNSuffix());
        ldapRole.setName(role.getName());
        this.store(ldapRole);
        return ldapRole;
    }

    @Override
    protected Group addGroup(Group group) {
        if (group.getName() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPGroup ldapGroup = new LDAPGroup(this.configuration.getGroupDNSuffix());
        ldapGroup.setName(group.getName());
        if (group.getParentGroup() != null) {
            String parentName = group.getParentGroup().getName();
            LDAPGroup parentGroup = (LDAPGroup)this.getGroup(parentName);
            if (parentGroup == null) {
                throw new RuntimeException("Parent group [" + parentName + "] does not exists.");
            }
            parentGroup.addChildGroup(ldapGroup);
            ldapGroup.setParentGroup(parentGroup);
            this.getLdapManager().modifyAttribute(parentGroup.getDN(), parentGroup.getLDAPAttributes().get("member"));
        }
        this.store(ldapGroup);
        return ldapGroup;
    }

    @Override
    protected User addUser(User user) {
        if (user.getId() == null) {
            throw new IdentityManagementException("No identifier was provided.");
        }
        LDAPUser ldapUser = null;
        ldapUser = !(user instanceof LDAPUser) ? this.convert(user) : (LDAPUser)user;
        ldapUser.setFullName(ldapUser.getUserCN());
        this.store(ldapUser);
        return ldapUser;
    }

    @Override
    protected Group updateGroup(Group updatedGroup, Group storedGroup) {
        this.updateAttributes((LDAPGroup)updatedGroup, (LDAPGroup)storedGroup);
        return updatedGroup;
    }

    @Override
    protected Role updateRole(Role updatedRole, Role storedRole) {
        this.updateAttributes((LDAPRole)updatedRole, (LDAPRole)storedRole);
        return updatedRole;
    }

    @Override
    protected User updateUser(User user, User storedUser) {
        LDAPUser updatedUser = this.convert(user);
        updatedUser.setFullName(updatedUser.getUserCN());
        this.updateAttributes(updatedUser, (LDAPEntry)storedUser);
        return updatedUser;
    }

    @Override
    protected Role removeRole(Role role) {
        this.removeEntry((LDAPEntry)role);
        this.removeFromParent(this.configuration.getGroupDNSuffix(), (LDAPEntry)role);
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Group removeGroup(Group group) {
        NamingEnumeration<SearchResult> results = null;
        try {
            results = this.getLdapManager().search(this.configuration.getUserDNSuffix(), "(&(cn= " + group.getName() + "*))");
            while (results.hasMoreElements()) {
                SearchResult searchResult = (SearchResult)results.nextElement();
                String dn = searchResult.getNameInNamespace();
                this.getLdapManager().destroySubcontext(dn);
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (NamingException namingException) {}
            }
        }
        this.removeEntry((LDAPEntry)group);
        return group;
    }

    @Override
    protected User removeUser(User user) {
        this.removeFromParent(this.configuration.getRoleDNSuffix(), (LDAPEntry)user);
        this.removeFromParent(this.configuration.getGroupDNSuffix(), (LDAPEntry)user);
        this.removeEntry((LDAPEntry)user);
        return user;
    }

    private String getSearchFilter(IdentityQuery<IdentityType> identityQuery) {
        LDAPQuery ldapQuery;
        StringBuffer filter;
        Agent[] agents;
        Object[] values;
        Class typeClass = identityQuery.getIdentityType();
        StringBuffer additionalFilter = new StringBuffer();
        if (this.isUserType(typeClass)) {
            String usersFilterMemberOf;
            Object name;
            if (identityQuery.getParameters().containsKey(User.HAS_ROLE)) {
                Object[] roleNames = (Object[])identityQuery.getParameters().get(User.HAS_ROLE);
                LDAPEntry[] roles = new LDAPEntry[roleNames.length];
                for (int i = 0; i < roleNames.length; ++i) {
                    name = roleNames[i];
                    roles[i] = (LDAPEntry)this.getRole(name.toString());
                }
                usersFilterMemberOf = this.getUsersFilterMemberOf(roles);
                if (usersFilterMemberOf.length() == 0) {
                    return null;
                }
                additionalFilter.append(usersFilterMemberOf);
            }
            if (identityQuery.getParameters().containsKey(User.MEMBER_OF)) {
                Object[] groupNames = (Object[])identityQuery.getParameters().get(User.MEMBER_OF);
                LDAPEntry[] groups = new LDAPEntry[groupNames.length];
                for (int i = 0; i < groupNames.length; ++i) {
                    name = groupNames[i];
                    groups[i] = (LDAPEntry)this.getGroup(name.toString());
                }
                usersFilterMemberOf = this.getUsersFilterMemberOf(groups);
                if (usersFilterMemberOf.length() == 0) {
                    return null;
                }
                additionalFilter.append(usersFilterMemberOf);
            }
            if (identityQuery.getParameters().containsKey(IdentityType.HAS_GROUP_ROLE)) {
                Object[] groupRoles = (Object[])identityQuery.getParameters().get(User.HAS_GROUP_ROLE);
                NamingEnumeration<SearchResult> search = null;
                try {
                    for (Object group : groupRoles) {
                        GroupRole groupRole = (GroupRole)group;
                        search = this.getLdapManager().search(this.configuration.getUserDNSuffix(), "(cn=" + groupRole.getGroup().getName() + ")");
                        if (!search.hasMoreElements()) continue;
                        while (search.hasMoreElements()) {
                            SearchResult searchResult = search.next();
                            String[] nameInNamespace = searchResult.getNameInNamespace().split(",");
                            String userId = nameInNamespace[1];
                            javax.naming.directory.Attribute member = searchResult.getAttributes().get("member");
                            if (!member.contains("cn=" + groupRole.getRole().getName() + "," + this.configuration.getRoleDNSuffix())) continue;
                            additionalFilter.append("(").append(userId).append(")");
                        }
                    }
                    if (additionalFilter.length() == 0) {
                        Object[] arr$ = null;
                        return arr$;
                    }
                }
                catch (Exception e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    if (search != null) {
                        try {
                            search.close();
                        }
                        catch (NamingException e) {}
                    }
                }
            }
        } else if (this.isRoleType(typeClass)) {
            if (identityQuery.getParameters().containsKey(Role.ROLE_OF)) {
                values = (Object[])identityQuery.getParameters().get(Role.ROLE_OF);
                agents = new Agent[values.length];
                for (int j = 0; j < values.length; ++j) {
                    Object value = values[j];
                    agents[j] = (Agent)value;
                }
                String filter2 = this.getEntryFilterForMembers(agents, this.configuration.getRoleDNSuffix());
                if (filter2.length() == 0) {
                    return null;
                }
                additionalFilter.append(filter2);
            }
        } else if (this.isGroupType(typeClass)) {
            if (identityQuery.getParameters().containsKey(Group.HAS_MEMBER)) {
                values = (Object[])identityQuery.getParameters().get(Group.HAS_MEMBER);
                agents = new Agent[values.length];
                for (int j = 0; j < values.length; ++j) {
                    Object value = values[j];
                    agents[j] = (Agent)value;
                }
                String filter3 = this.getEntryFilterForMembers(agents, this.configuration.getGroupDNSuffix());
                if (filter3.length() == 0) {
                    return null;
                }
                additionalFilter.append(filter3);
            }
            if (identityQuery.getParameters().containsKey(Group.PARENT)) {
                String parentName = ((Object[])identityQuery.getParameters().get(Group.PARENT))[0].toString();
                LDAPGroup parentGroup = (LDAPGroup)this.getGroup(parentName);
                NamingEnumeration<?> members = null;
                try {
                    members = parentGroup.getLDAPAttributes().get("member").getAll();
                    while (members.hasMoreElements()) {
                        String groupDN = (String)members.nextElement();
                        if (groupDN.toString().trim().isEmpty()) continue;
                        String groupName = groupDN.split(",")[0];
                        additionalFilter.append("(").append(groupName).append(")");
                    }
                }
                catch (NamingException e) {
                    throw new IdentityManagementException((Throwable)e);
                }
                finally {
                    if (members != null) {
                        try {
                            members.close();
                        }
                        catch (NamingException e) {}
                    }
                }
            }
        }
        if (additionalFilter.length() > 0) {
            additionalFilter.insert(0, "(|");
            additionalFilter.insert(additionalFilter.length() - 1, ")");
        }
        if ((filter = (ldapQuery = new LDAPQuery(identityQuery.getParameters())).createManagedAttributesFilter()) == null) {
            filter = new StringBuffer("(&(objectClass=*)(" + this.getIdAttribute(typeClass) + "=*)(!(cn=custom-attributes)))");
        }
        filter.insert(filter.length() - 1, additionalFilter.toString());
        return filter.toString();
    }

    private String getIdAttribute(Class<? extends IdentityType> identityTypeClass) {
        String idAttribute = null;
        if (this.isUserType(identityTypeClass)) {
            idAttribute = "uid";
        } else if (this.isRoleType(identityTypeClass)) {
            idAttribute = "cn";
        } else if (this.isGroupType(identityTypeClass)) {
            idAttribute = "cn";
        }
        return idAttribute;
    }

    private String getBaseDN(Class<? extends IdentityType> identityTypeClass) {
        String baseDN = null;
        if (this.isUserType(identityTypeClass)) {
            baseDN = this.configuration.getUserDNSuffix();
        } else if (this.isRoleType(identityTypeClass)) {
            baseDN = this.configuration.getRoleDNSuffix();
        } else if (this.isGroupType(identityTypeClass)) {
            baseDN = this.configuration.getGroupDNSuffix();
        }
        return baseDN;
    }

    private String getEntryFilterForMembers(Agent[] members, String baseDN) {
        StringBuffer additionalFilter = new StringBuffer();
        String hasMemberFilter = "";
        for (Agent agent : members) {
            LDAPUser ldapUser = (LDAPUser)this.getUser(agent.getId());
            hasMemberFilter = hasMemberFilter + "(member=" + ldapUser.getDN() + ")";
        }
        NamingEnumeration<SearchResult> search = null;
        try {
            search = this.getLdapManager().search(baseDN, hasMemberFilter.toString());
            while (search.hasMoreElements()) {
                SearchResult searchResult = search.next();
                String entryCN = searchResult.getAttributes().get("cn").get().toString();
                additionalFilter.append("(").append("cn").append("=").append(entryCN).append(")");
            }
        }
        catch (Exception e) {
            throw new IdentityManagementException((Throwable)e);
        }
        finally {
            if (search != null) {
                try {
                    search.close();
                }
                catch (NamingException e) {}
            }
        }
        return additionalFilter.toString();
    }

    private String getUsersFilterMemberOf(LDAPEntry[] parents) {
        StringBuffer additionalFilter = new StringBuffer();
        HashMap<String, Integer> userCount = new HashMap<String, Integer>();
        for (LDAPEntry ldapEntry : parents) {
            javax.naming.directory.Attribute memberAttribute = null;
            memberAttribute = ldapEntry.getLDAPAttributes().get("member");
            NamingEnumeration<?> members = null;
            try {
                members = memberAttribute.getAll();
                while (members.hasMoreElements()) {
                    String memberDN = (String)members.nextElement();
                    if (memberDN.trim().isEmpty()) continue;
                    String userId = memberDN.split(",")[0];
                    if (!userCount.containsKey(userId)) {
                        userCount.put(userId, 1);
                    } else {
                        Integer count = (Integer)userCount.get(userId);
                        userCount.put(userId, count + 1);
                    }
                    additionalFilter.append("(").append(userId).append(")");
                }
            }
            catch (NamingException e) {
                throw new IdentityManagementException((Throwable)e);
            }
            finally {
                if (members != null) {
                    try {
                        members.close();
                    }
                    catch (NamingException e) {}
                }
            }
        }
        Set entrySet = userCount.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((Integer)entry.getValue()).equals(parents.length)) continue;
            String filterTmp = additionalFilter.toString();
            filterTmp = filterTmp.replaceAll("\\(" + (String)entry.getKey() + "\\)", "");
            additionalFilter = new StringBuffer(filterTmp);
        }
        return additionalFilter.toString();
    }
}

