/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.PlainTextPassword;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.internal.PlainTextPasswordCredentialHandler;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.credential.spi.annotations.SupportsStores;
import org.picketlink.idm.ldap.internal.LDAPIdentityStore;
import org.picketlink.idm.ldap.internal.LDAPUser;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.spi.IdentityStore;

@SupportsCredentials(value={UsernamePasswordCredentials.class, PlainTextPassword.class})
@SupportsStores(value={LDAPIdentityStore.class})
public class LDAPPlainTextPasswordCredentialHandler
extends PlainTextPasswordCredentialHandler {
    private static final String USER_PASSWORD_ATTRIBUTE = "userpassword";

    @Override
    protected void doUpdate(Agent agent, IdentityStore<?> store, PlainTextPassword password) {
        LDAPIdentityStore ldapIdentityStore = this.getLDAPIdentityStore(store);
        LDAPUser ldapuser = (LDAPUser)ldapIdentityStore.getUser(agent.getId());
        if (ldapIdentityStore.getConfig().isActiveDirectory()) {
            this.updateADPassword(ldapuser, new String(password.getValue()), ldapIdentityStore);
        } else {
            ModificationItem[] mods = new ModificationItem[1];
            try {
                BasicAttribute mod0 = new BasicAttribute(USER_PASSWORD_ATTRIBUTE, new String(password.getValue()));
                mods[0] = new ModificationItem(2, mod0);
                ldapIdentityStore.getLdapManager().modifyAttribute(ldapuser.getDN(), mod0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private LDAPIdentityStore getLDAPIdentityStore(IdentityStore<?> store) {
        if (!LDAPIdentityStore.class.isInstance(store)) {
            throw new IllegalArgumentException("IdentityStore class [" + store.getClass() + "] not supported by this handler.");
        }
        return (LDAPIdentityStore)store;
    }

    @Override
    protected void doValidate(Agent agent, UsernamePasswordCredentials usernamePassword, IdentityStore<?> identityStore) {
        LDAPIdentityStore ldapIdentityStore = this.getLDAPIdentityStore(identityStore);
        LDAPUser ldapUser = (LDAPUser)ldapIdentityStore.getUser(agent.getId());
        char[] password = usernamePassword.getPassword().getValue();
        boolean isValid = this.getLDAPIdentityStore(identityStore).getLdapManager().authenticate(ldapUser.getDN(), new String(password));
        if (isValid) {
            usernamePassword.setStatus(Credentials.Status.VALID);
        }
    }

    private void updateADPassword(LDAPUser user, String password, LDAPIdentityStore store) {
        try {
            String newQuotedPassword = "\"" + password + "\"";
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            BasicAttribute unicodePwd = new BasicAttribute("unicodePwd", newUnicodePassword);
            store.getLdapManager().modifyAttribute(user.getDN(), unicodePwd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

