/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.ldap.internal.LDAPQueryParameter;
import org.picketlink.idm.query.QueryParameter;

public class LDAPQuery {
    private List<LDAPQueryParameter> managedParameters = new ArrayList<LDAPQueryParameter>();
    private Boolean hasCustomAttributes = null;

    public LDAPQuery(Map<QueryParameter, Object[]> queryParameters) {
        for (Map.Entry<QueryParameter, Object[]> entry : queryParameters.entrySet()) {
            Object[] values;
            QueryParameter queryParameter = entry.getKey();
            LDAPQueryParameter parameter = new LDAPQueryParameter(queryParameter, values = entry.getValue());
            if (parameter.isMappedToManagedAttribute()) {
                this.managedParameters.add(parameter);
                continue;
            }
            if (parameter.isMembershipParameter()) continue;
            this.hasCustomAttributes = true;
        }
    }

    public StringBuffer createManagedAttributesFilter() {
        if (this.getManagedParameters().isEmpty()) {
            return null;
        }
        StringBuffer filter = new StringBuffer("(&(objectClass=*)");
        for (LDAPQueryParameter ldapQueryParameter : this.getManagedParameters()) {
            filter.append(ldapQueryParameter.createFilter());
        }
        filter.append(")");
        return filter;
    }

    public boolean hasCustomAttributes() {
        return this.hasCustomAttributes != null && this.hasCustomAttributes != false;
    }

    public List<LDAPQueryParameter> getManagedParameters() {
        return this.managedParameters;
    }
}

