/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config.internal.resolver;

import org.picketlink.config.idm.ObjectType;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.internal.resolver.PropertyResolver;

public abstract class BasePropertyResolver<V>
implements PropertyResolver<V> {
    @Override
    public V resolveProperty(Object propertyValueFromConfiguration, Class<V> propertyClass) {
        if (propertyValueFromConfiguration instanceof String) {
            String stringValue = (String)propertyValueFromConfiguration;
            return this.resolvePropertyFromString(stringValue, propertyClass);
        }
        if (propertyValueFromConfiguration instanceof ObjectType) {
            ObjectType objectType = (ObjectType)propertyValueFromConfiguration;
            return this.resolvePropertyFromObjectType(objectType);
        }
        throw new SecurityConfigurationException("Unknown type of propertyValue: " + propertyValueFromConfiguration);
    }

    protected abstract V resolvePropertyFromString(String var1, Class<V> var2);

    protected abstract V resolvePropertyFromObjectType(ObjectType var1);
}

