/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.internal;

import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.event.AbstractBaseEvent;
import org.picketlink.idm.event.UserCreatedEvent;
import org.picketlink.idm.event.UserDeletedEvent;
import org.picketlink.idm.event.UserUpdatedEvent;
import org.picketlink.idm.jpa.annotations.PropertyType;
import org.picketlink.idm.jpa.internal.IdentityTypeHandler;
import org.picketlink.idm.jpa.internal.JPACriteriaQueryBuilder;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.jpa.internal.JPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;

public class UserHandler
extends IdentityTypeHandler<User> {
    public UserHandler(JPAIdentityStoreConfiguration config) {
        super(config);
        this.getSortParametersMapping().put(User.LOGIN_NAME, PropertyType.AGENT_LOGIN_NAME);
        this.getSortParametersMapping().put(User.FIRST_NAME, PropertyType.USER_FIRST_NAME);
        this.getSortParametersMapping().put(User.LAST_NAME, PropertyType.USER_LAST_NAME);
        this.getSortParametersMapping().put(User.EMAIL, PropertyType.USER_EMAIL);
    }

    @Override
    protected void doPopulateIdentityInstance(Object toIdentity, User fromUser, JPAIdentityStore store) {
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_PARTITION, store.lookupPartitionObject((Partition)store.getCurrentRealm()), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.IDENTITY_ID, fromUser.getId(), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.AGENT_LOGIN_NAME, fromUser.getLoginName(), true);
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.USER_FIRST_NAME, fromUser.getFirstName());
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.USER_LAST_NAME, fromUser.getLastName());
        this.getConfig().setModelPropertyValue(toIdentity, PropertyType.USER_EMAIL, fromUser.getEmail());
    }

    @Override
    protected AbstractBaseEvent raiseCreatedEvent(User fromIdentityType) {
        return new UserCreatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseUpdatedEvent(User fromIdentityType) {
        return new UserUpdatedEvent(fromIdentityType);
    }

    @Override
    protected AbstractBaseEvent raiseDeletedEvent(User fromIdentityType) {
        return new UserDeletedEvent(fromIdentityType);
    }

    @Override
    public List<Predicate> getPredicate(JPACriteriaQueryBuilder criteria, JPAIdentityStore store) {
        List<Predicate> predicates = super.getPredicate(criteria, store);
        CriteriaBuilder builder = criteria.getBuilder();
        Object[] parameterValues = criteria.getIdentityQuery().getParameter(User.LOGIN_NAME);
        if (parameterValues != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.AGENT_LOGIN_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.FIRST_NAME)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.USER_FIRST_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.LAST_NAME)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.USER_LAST_NAME).getName()), parameterValues[0]));
        }
        if ((parameterValues = criteria.getIdentityQuery().getParameter(User.EMAIL)) != null) {
            predicates.add(builder.equal((Expression)criteria.getRoot().get(this.getConfig().getModelProperty(PropertyType.USER_EMAIL).getName()), parameterValues[0]));
        }
        return predicates;
    }

    @Override
    protected User doCreateIdentityType(Object identity, JPAIdentityStore store) {
        String loginName = this.getConfig().getModelProperty(PropertyType.AGENT_LOGIN_NAME).getValue(identity).toString();
        SimpleUser user = new SimpleUser(loginName);
        user.setFirstName(this.getConfig().getModelPropertyValue(String.class, identity, PropertyType.USER_FIRST_NAME));
        user.setLastName(this.getConfig().getModelPropertyValue(String.class, identity, PropertyType.USER_LAST_NAME));
        user.setEmail(this.getConfig().getModelPropertyValue(String.class, identity, PropertyType.USER_EMAIL));
        return user;
    }

    @Override
    public void validate(User user, JPAIdentityStore store) {
        if (user.getLoginName() == null) {
            throw new IdentityManagementException("No login name was provided.");
        }
        if (store.getUser(user.getLoginName()) != null) {
            throw new IdentityManagementException("User already exists with the given loginName [" + user.getLoginName() + "] for the given Realm [" + store.getCurrentRealm().getName() + "]");
        }
    }
}

