/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.ldap.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingException;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.ldap.internal.LDAPOperationManager;
import org.picketlink.idm.ldap.internal.LDAPPlainTextPasswordCredentialHandler;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.GroupMembership;

public class LDAPIdentityStoreConfiguration
extends IdentityStoreConfiguration {
    private String ldapURL;
    private String userDNSuffix;
    private String roleDNSuffix;
    private String groupDNSuffix;
    private String factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
    private String authType = "simple";
    private String protocol;
    private String bindDN;
    private String bindCredential;
    private String standardAttributesFileName = "standardattributes.txt";
    private boolean isActiveDirectory = false;
    private Properties additionalProperties = new Properties();
    private IdentityStoreConfiguration.FeatureSet featureSet = new IdentityStoreConfiguration.FeatureSet((IdentityStoreConfiguration)this);
    private LDAPOperationManager ldapManager;
    private String agentDNSuffix;
    private String baseDN;
    private Map<String, String> groupMapping = new HashMap<String, String>();

    public void init() throws SecurityConfigurationException {
        this.featureSet.addSupportedFeature(IdentityStoreConfiguration.Feature.all);
        this.featureSet.addSupportedRelationship(Grant.class);
        this.featureSet.addSupportedRelationship(GroupMembership.class);
        this.getSupportedCredentialHandlers().add(LDAPPlainTextPasswordCredentialHandler.class);
        if (this.getUserDNSuffix() == null) {
            throw new SecurityConfigurationException("User baseDN not provided.");
        }
        if (this.getRoleDNSuffix() == null) {
            throw new SecurityConfigurationException("Role baseDN not provided.");
        }
        if (this.getGroupDNSuffix() == null) {
            throw new SecurityConfigurationException("Group baseDN not provided.");
        }
        if (this.getAgentDNSuffix() == null) {
            throw new SecurityConfigurationException("Agent baseDN not provided.");
        }
        try {
            this.ldapManager = new LDAPOperationManager(this);
        }
        catch (NamingException e) {
            throw new SecurityConfigurationException((Throwable)e);
        }
    }

    public IdentityStoreConfiguration.FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    public String getStandardAttributesFileName() {
        return this.standardAttributesFileName;
    }

    public LDAPIdentityStoreConfiguration setStandardAttributesFileName(String standardAttributesFileName) {
        this.standardAttributesFileName = standardAttributesFileName;
        return this;
    }

    public LDAPIdentityStoreConfiguration setLdapURL(String ldapURL) {
        this.ldapURL = ldapURL;
        return this;
    }

    public LDAPIdentityStoreConfiguration setUserDNSuffix(String userDNSuffix) {
        this.userDNSuffix = userDNSuffix;
        return this;
    }

    public LDAPIdentityStoreConfiguration setRoleDNSuffix(String roleDNSuffix) {
        this.roleDNSuffix = roleDNSuffix;
        return this;
    }

    public LDAPIdentityStoreConfiguration setGroupDNSuffix(String groupDNSuffix) {
        this.groupDNSuffix = groupDNSuffix;
        return this;
    }

    public LDAPIdentityStoreConfiguration setFactoryName(String factoryName) {
        this.factoryName = factoryName;
        return this;
    }

    public LDAPIdentityStoreConfiguration setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public LDAPIdentityStoreConfiguration setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public LDAPIdentityStoreConfiguration setBindDN(String bindDN) {
        this.bindDN = bindDN;
        return this;
    }

    public LDAPIdentityStoreConfiguration setBindCredential(String bindCredential) {
        this.bindCredential = bindCredential;
        return this;
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    public String getUserDNSuffix() {
        return this.userDNSuffix;
    }

    public String getRoleDNSuffix() {
        return this.roleDNSuffix;
    }

    public String getGroupDNSuffix() {
        return this.groupDNSuffix;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public boolean isActiveDirectory() {
        return this.isActiveDirectory;
    }

    public void setActiveDirectory(boolean isActiveDirectory) {
        this.isActiveDirectory = isActiveDirectory;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Properties additionalProperties) {
        this.additionalProperties.putAll((Map<?, ?>)additionalProperties);
    }

    public LDAPOperationManager getLdapManager() {
        return this.ldapManager;
    }

    public String getAgentDNSuffix() {
        return this.agentDNSuffix;
    }

    public LDAPIdentityStoreConfiguration setAgentDNSuffix(String agentDNSuffix) {
        this.agentDNSuffix = agentDNSuffix;
        return this;
    }

    public LDAPIdentityStoreConfiguration setBaseDN(String baseDN) {
        this.baseDN = baseDN;
        return this;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void addGroupMapping(String groupPath, String groupBaseDN) {
        this.groupMapping.put(groupPath, groupBaseDN);
    }

    public String getGroupMappingDN(String groupPath) {
        Set<Map.Entry<String, String>> entrySet = this.groupMapping.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!groupPath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.groupMapping.get(groupPath);
    }
}

