/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.GroupQuery;
import org.picketlink.test.idm.jpa.schema.AbstractJPAIdentityManagerTestCase;

public class JPAGroupQueryTestCase
extends AbstractJPAIdentityManagerTestCase {
    private static final String ROLE_NAME_PREFIX = "admin";
    private static final String GROUP_PARENT_NAME = "parentGroup";
    private static final String USER_NAME = "theuser";
    private static final String GROUP_NAME = "Administrators";
    private Group group;
    private User user;
    private Group parentGroup;

    @Override
    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadGroups();
    }

    @Test
    public void testfindByName() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setName(this.group.getName());
        this.assertQueryResult(query);
        query.setName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindById() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setId(this.group.getId());
        this.assertQueryResult(query);
        query.setId("9999");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByRole() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setRole("admin1");
        this.assertQueryResult(query);
        query.setRole("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByUser() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setId(this.group.getId());
        query.setRelatedUser(this.user);
        this.assertQueryResult(query);
        query.setRelatedUser("9999");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByParentGroup() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setId(this.group.getId());
        query.setParentGroup(this.parentGroup);
        this.assertQueryResult(query);
        query.setParentGroup("9999");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByAttributes() throws Exception {
        GroupQuery query = this.createGroupQuery();
        query.setId(this.group.getId());
        query.addAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.addAttributeFilter("attribute2", new String[]{"attributeValue2"});
        this.assertQueryResult(query);
    }

    private void loadGroups() {
        IdentityManager identityManager = this.getIdentityManager();
        this.group = identityManager.getGroup("Administrators1");
        this.user = identityManager.getUser(USER_NAME);
        this.parentGroup = identityManager.getGroup(GROUP_PARENT_NAME);
        if (this.group != null) {
            return;
        }
        this.user = identityManager.createUser(USER_NAME);
        this.parentGroup = identityManager.createGroup(GROUP_PARENT_NAME, (Group)null);
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            Group currentGroup = identityManager.createGroup(GROUP_NAME + index, this.parentGroup);
            if (this.group == null) {
                this.group = currentGroup;
            }
            Role role = identityManager.createRole(ROLE_NAME_PREFIX + index);
            identityManager.grantRole(role, (IdentityType)this.user, currentGroup);
            currentGroup.setAttribute("attribute1", "attributeValue1");
            currentGroup.setAttribute("attribute1", "attributeValue12");
            currentGroup.setAttribute("attribute1", "attributeValue123");
            currentGroup.setAttribute("attribute2", "attributeValue2");
        }
    }

    private void assertQueryResult(GroupQuery query) {
        List result = query.executeQuery();
        junit.framework.Assert.assertFalse((boolean)result.isEmpty());
        junit.framework.Assert.assertEquals((String)this.group.getId(), (String)((Group)result.get(0)).getId());
    }

    private GroupQuery createGroupQuery() {
        return this.getIdentityManager().createGroupQuery();
    }
}

