/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Membership;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.test.idm.jpa.schema.AbstractJPAIdentityManagerTestCase;

public class JPAMembershipTestCase
extends AbstractJPAIdentityManagerTestCase {
    @Test
    public void testMembershipStore() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Role role = identityManager.createRole("admin");
        User user = identityManager.createUser("asaldhan");
        Group group = identityManager.createGroup("Administrators", (Group)null);
        identityManager.grantRole(role, (IdentityType)user, group);
        junit.framework.Assert.assertTrue((boolean)identityManager.hasRole(role, (IdentityType)user, group));
        this.testRemoveGroup();
    }

    public void testRemoveGroup() throws Exception {
        IdentityStore identityStore = this.createIdentityStore();
        Role role = identityStore.getRole(null, "admin");
        User user = identityStore.getUser(null, "asaldhan");
        Group group = identityStore.getGroup(null, "Administrators");
        Membership membership = identityStore.getMembership(null, (IdentityType)user, group, role);
        Assert.assertNotNull((Object)membership);
        identityStore.removeMembership(null, (IdentityType)user, group, role);
        membership = identityStore.getMembership(null, (IdentityType)user, group, role);
        Assert.assertNull((Object)membership);
    }
}

