/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import org.junit.Assert;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.test.idm.jpa.schema.AbstractJPAIdentityTypeTestCase;

public class JPARoleTestCase
extends AbstractJPAIdentityTypeTestCase {
    private static final String ROLE_NAME = "admin";

    @Test
    public void testRoleStore() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Role role = identityManager.createRole(ROLE_NAME);
        Assert.assertNotNull((Object)role);
        Assert.assertNotNull((Object)role.getKey());
        Assert.assertEquals((Object)ROLE_NAME, (Object)role.getName());
        this.testAddAttributes();
        this.testGetRole();
        this.testRemoveRole();
    }

    public void testGetRole() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Role group = identityManager.getRole(ROLE_NAME);
        Assert.assertNotNull((Object)group);
        Assert.assertNotNull((Object)group.getKey());
        Assert.assertEquals((Object)ROLE_NAME, (Object)group.getName());
        this.testRemoveAttributes();
    }

    public void testRemoveRole() throws Exception {
        IdentityManager identityManager = this.getIdentityManager();
        Role role = identityManager.getRole(ROLE_NAME);
        Assert.assertNotNull((Object)role);
        identityManager.removeRole(role);
        role = identityManager.getRole(ROLE_NAME);
        Assert.assertNull((Object)role);
    }

    @Override
    protected IdentityType getIdentityTypeFromDatabase(IdentityManager identityManager) {
        return identityManager.getRole(ROLE_NAME);
    }
}

