/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.test.idm.jpa.schema;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.jpa.schema.DatabaseUser;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.UserQuery;
import org.picketlink.test.idm.jpa.schema.AbstractJPAIdentityManagerTestCase;

public class JPAUserQueryTestCase
extends AbstractJPAIdentityManagerTestCase {
    private static final String GROUP_NAME_PREFIX = "Administrators";
    private static final String ROLE_NAME_PREFIX = "admin";
    private static final String USER_EMAIL = "myemail@company.com";
    private static final String USER_LAST_NAME = "Saldhana";
    private static final String USER_FIRST_NAME = "Anil";
    private static final String USER_USERNAME = "asaldhana";
    private User user;

    @Override
    @Before
    public void onSetupTest() throws Exception {
        super.onSetupTest();
        this.loadUsers();
    }

    @Test
    public void testfindByUserName() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setName(this.user.getId());
        this.assertQueryResult(query);
        query.setName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByFirstName() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setFirstName(this.user.getFirstName());
        this.assertQueryResult(query);
        query.setFirstName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByLastName() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setLastName(this.user.getLastName());
        this.assertQueryResult(query);
        query.setLastName("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByEmail() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setEmail(this.user.getEmail());
        this.assertQueryResult(query);
        query.setEmail("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByRole() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setRole("admin1");
        this.assertQueryResult(query);
        query.setRole("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByGroup() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setRelatedGroup("Administrators1");
        this.assertQueryResult(query);
        query.setRelatedGroup("Invalid");
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    @Test
    public void testfindByAttributes() throws Exception {
        UserQuery query = this.createUserQuery();
        query.setName(this.user.getId());
        query.setAttributeFilter("attribute1", new String[]{"attributeValue1", "attributeValue12", "attributeValue123"});
        query.setAttributeFilter("attribute2", new String[]{"attributeValue2", "attributeValue21", "attributeValue23"});
        this.assertQueryResult(query);
        query.setAttributeFilter("Invalid", new String[]{"Invalid"});
        Assert.assertTrue((boolean)query.executeQuery().isEmpty());
    }

    private void assertQueryResult(UserQuery query) {
        List result = query.executeQuery();
        Assert.assertFalse((boolean)result.isEmpty());
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertEquals((Object)this.user.getId(), (Object)((User)result.get(0)).getId());
    }

    private void loadUsers() {
        IdentityManager identityManager = this.getIdentityManager();
        this.user = identityManager.getUser("asaldhana1");
        if (this.user != null) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int index = i + 1;
            DatabaseUser currentUser = new DatabaseUser(USER_USERNAME + index);
            identityManager.createUser((User)currentUser);
            if (this.user == null) {
                this.user = currentUser;
            }
            currentUser.setEmail(USER_EMAIL + index);
            currentUser.setFirstName(USER_FIRST_NAME + index);
            currentUser.setLastName(USER_LAST_NAME + index);
            Role role = identityManager.createRole(ROLE_NAME_PREFIX + index);
            Group group = identityManager.createGroup(GROUP_NAME_PREFIX + index, (Group)null);
            identityManager.grantRole(role, (IdentityType)this.user, group);
            currentUser.setAttribute("attribute1", "attributeValue1");
            currentUser.setAttribute("attribute1", "attributeValue12");
            currentUser.setAttribute("attribute1", "attributeValue123");
            currentUser.setAttribute("attribute2", "attributeValue2");
        }
    }

    private UserQuery createUserQuery() {
        return this.getIdentityManager().createUserQuery();
    }
}

