/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.picketlink.idm.jpa.schema.AbstractDatabaseAttribute;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Partition;

@MappedSuperclass
public abstract class AbstractDatabaseIdentityType<A extends AbstractDatabaseAttribute>
implements IdentityType {
    private String id;
    private String key;
    private boolean enabled = true;
    private Date expirationDate;
    private Date createdDate = new Date();
    @Transient
    private Map<String, String[]> userAttributesMap;

    public AbstractDatabaseIdentityType() {
    }

    public AbstractDatabaseIdentityType(String name) {
        this.setId(name);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Transient
    public Partition getPartition() {
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setAttribute(Attribute<? extends Serializable> attribute) {
        Serializable providedValue = attribute.getValue();
        String[] values = null;
        if (providedValue.getClass().isArray()) {
            Object[] providedValues = (Object[])providedValue;
            values = new String[providedValues.length];
            for (int i = 0; i < providedValues.length; ++i) {
                values[i] = providedValues[i].toString();
            }
        } else {
            values = new String[]{providedValue.toString()};
        }
        this.getUserAttributesMap().put(attribute.getName(), values);
        for (String value : values) {
            A attributeInstance = this.createAttribute(attribute.getName(), value);
            ((AbstractDatabaseAttribute)attributeInstance).setIdentityType((AbstractDatabaseIdentityType)this);
            this.getOwnerAttributes().add(attributeInstance);
        }
    }

    public abstract List<A> getOwnerAttributes();

    protected abstract A createAttribute(String var1, String var2);

    private Map<String, String[]> getUserAttributesMap() {
        if (this.userAttributesMap == null) {
            this.userAttributesMap = new HashMap<String, String[]>();
            for (AbstractDatabaseAttribute attribute : this.getOwnerAttributes()) {
                String[] values = this.userAttributesMap.get(attribute.getName());
                if (values == null) {
                    values = new String[]{attribute.getValue()};
                } else {
                    int len = values.length;
                    values = Arrays.copyOf(values, len + 1);
                    values[len] = attribute.getValue();
                }
                this.userAttributesMap.put(attribute.getName(), values);
            }
        }
        return this.userAttributesMap;
    }

    @Transient
    public void removeAttribute(String name) {
        this.getUserAttributesMap().remove(name);
        for (AbstractDatabaseAttribute attribute : new ArrayList<A>(this.getOwnerAttributes())) {
            if (!attribute.getName().equals(name)) continue;
            attribute.setIdentityType(null);
            this.getOwnerAttributes().remove(attribute);
        }
    }

    @Transient
    public Attribute<Serializable> getAttribute(String name) {
        Attribute attribute = null;
        String[] values = this.getUserAttributesMap().get(name);
        if (values != null) {
            attribute = values.length == 1 ? new Attribute(name, (Serializable)((Object)values[0])) : new Attribute(name, (Serializable)values);
        }
        return attribute;
    }

    @Transient
    public Collection<Attribute<? extends Serializable>> getAttributes() {
        Set<Map.Entry<String, String[]>> entrySet = this.getUserAttributesMap().entrySet();
        ArrayList<Attribute<? extends Serializable>> attributes = new ArrayList<Attribute<? extends Serializable>>();
        for (Map.Entry<String, String[]> entry : entrySet) {
            String name = entry.getKey();
            String[] values = entry.getValue();
            Attribute attribute = null;
            if (values != null) {
                attribute = values.length == 1 ? new Attribute(name, (Serializable)((Object)values[0])) : new Attribute(name, (Serializable)values);
            }
            attributes.add(attribute);
        }
        return attributes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractDatabaseIdentityType)) {
            return false;
        }
        AbstractDatabaseIdentityType other = (AbstractDatabaseIdentityType)obj;
        return new EqualsBuilder().append((Object)this.getId(), (Object)other.getId()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.getId()).append("key", (Object)this.getKey()).append("enabled", this.isEnabled()).append("expirationDate", (Object)this.getExpirationDate()).append("creationDate", (Object)this.getCreatedDate()).toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).toHashCode();
    }

    public void setPartition(Partition partition) {
    }
}

