/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jpa.schema.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.picketlink.idm.internal.AbstractIdentityStore;
import org.picketlink.idm.jpa.schema.AbstractDatabaseAttribute;
import org.picketlink.idm.jpa.schema.AbstractDatabaseIdentityType;
import org.picketlink.idm.jpa.schema.DatabaseGroup;
import org.picketlink.idm.jpa.schema.DatabaseGroupAttribute;
import org.picketlink.idm.jpa.schema.DatabaseMembership;
import org.picketlink.idm.jpa.schema.DatabaseRole;
import org.picketlink.idm.jpa.schema.DatabaseRoleAttribute;
import org.picketlink.idm.jpa.schema.DatabaseUser;
import org.picketlink.idm.jpa.schema.DatabaseUserAttribute;
import org.picketlink.idm.jpa.schema.internal.SimpleJPAIdentityStoreConfiguration;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.SimpleGroup;
import org.picketlink.idm.model.SimpleRole;
import org.picketlink.idm.model.SimpleUser;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;
import org.picketlink.idm.query.QueryParameter;
import org.picketlink.idm.spi.IdentityStoreInvocationContext;

public class SimpleJPAIdentityStore
extends AbstractIdentityStore<SimpleJPAIdentityStoreConfiguration> {
    public static final String INVOCATION_CTX_ENTITY_MANAGER = "CTX_ENTITY_MANAGER";
    private SimpleJPAIdentityStoreConfiguration config;
    private IdentityStoreInvocationContext context;

    public void add(IdentityType identityType) {
        Object toStoreInstance = null;
        if (this.isUserType(identityType.getClass())) {
            User user = (User)identityType;
            User newUser = null;
            if (!(user instanceof DatabaseUser)) {
                newUser = new DatabaseUser(user.getId());
                newUser.setFirstName(user.getFirstName());
                newUser.setLastName(user.getLastName());
                newUser.setEmail(user.getEmail());
                for (Attribute attribute : user.getAttributes()) {
                    newUser.setAttribute(attribute);
                }
            } else {
                newUser = user;
            }
            toStoreInstance = newUser;
        } else if (this.isGroupType(identityType.getClass())) {
            Group group = (Group)identityType;
            DatabaseGroup newGroup = new DatabaseGroup(group.getName());
            if (group.getParentGroup() != null) {
                newGroup.setParentGroup(this.getStoredGroup(group.getParentGroup().getName()));
            }
            toStoreInstance = newGroup;
        } else if (this.isRoleType(identityType.getClass())) {
            Role role = (Role)identityType;
            DatabaseRole newRole = new DatabaseRole(role.getName());
            toStoreInstance = newRole;
        }
        this.persist(toStoreInstance);
    }

    public void remove(IdentityType identityType) {
        AbstractDatabaseIdentityType toRemove = null;
        if (this.isUserType(identityType.getClass())) {
            User user = (User)identityType;
            if (user.getId() == null) {
                throw new IllegalArgumentException("User identifier nor provided.");
            }
            toRemove = this.getStoredUser(user.getId());
        } else if (this.isGroupType(identityType.getClass())) {
            Group group = (Group)identityType;
            if (group.getId() == null) {
                throw new IllegalArgumentException("Group identifier not provided.");
            }
            toRemove = this.getStoredGroup(group.getName());
        } else if (this.isRoleType(identityType.getClass())) {
            Role role = (Role)identityType;
            if (role.getName() == null) {
                throw new IllegalArgumentException("Role name not provided.");
            }
            toRemove = this.getStoredRole(role.getName());
        }
        this.getEntityManager().remove((Object)toRemove);
        this.getEntityManager().flush();
    }

    public User getUser(String name) {
        DatabaseUser storedUser = this.getStoredUser(name);
        if (storedUser == null) {
            return null;
        }
        SimpleUser user = new SimpleUser(name);
        user.setEmail(storedUser.getEmail());
        user.setCreatedDate(storedUser.getCreatedDate());
        user.setEnabled(storedUser.isEnabled());
        user.setExpirationDate(storedUser.getExpirationDate());
        user.setFirstName(storedUser.getFirstName());
        user.setLastName(storedUser.getLastName());
        Collection attributes = storedUser.getAttributes();
        for (Attribute attribute : attributes) {
            user.setAttribute(attribute);
        }
        return user;
    }

    private DatabaseUser getStoredUser(String name) {
        return (DatabaseUser)this.findIdentityTypeByKey("id", name, "USER.LOAD_BY_KEY");
    }

    public Group getGroup(String name) {
        DatabaseGroup storedGroup = this.getStoredGroup(name);
        if (storedGroup == null) {
            return null;
        }
        SimpleGroup group = null;
        group = storedGroup.getParentGroup() == null ? new SimpleGroup(name) : new SimpleGroup(name, this.getGroup(storedGroup.getParentGroup().getName()));
        group.setCreatedDate(storedGroup.getCreatedDate());
        group.setEnabled(storedGroup.isEnabled());
        group.setExpirationDate(storedGroup.getExpirationDate());
        Collection<Attribute<Serializable>> attributes = storedGroup.getAttributes();
        for (Attribute<Serializable> attribute : attributes) {
            group.setAttribute(attribute);
        }
        return group;
    }

    private DatabaseGroup getStoredGroup(String group) {
        return (DatabaseGroup)this.findIdentityTypeByKey("name", group, "GROUP.LOAD_BY_KEY");
    }

    public Role getRole(String name) {
        DatabaseRole storedRole = this.getStoredRole(name);
        if (storedRole == null) {
            return null;
        }
        SimpleRole role = new SimpleRole(name);
        role.setCreatedDate(storedRole.getCreatedDate());
        role.setEnabled(storedRole.isEnabled());
        role.setExpirationDate(storedRole.getExpirationDate());
        Collection<Attribute<Serializable>> attributes = storedRole.getAttributes();
        for (Attribute<Serializable> attribute : attributes) {
            role.setAttribute(attribute);
        }
        return role;
    }

    private DatabaseRole getStoredRole(String role) {
        return (DatabaseRole)this.findIdentityTypeByKey("name", role, "ROLE.LOAD_BY_KEY");
    }

    public GroupRole createMembership(IdentityType member, Group group, Role role) {
        if (member instanceof User) {
            DatabaseUser dbUser = this.getStoredUser(((User)member).getId());
            DatabaseRole dbRole = null;
            DatabaseGroup dbGroup = null;
            if (role != null) {
                dbRole = this.getStoredRole(role.getName());
            }
            if (group != null) {
                dbGroup = this.getStoredGroup(group.getName());
            }
            DatabaseMembership newMembership = new DatabaseMembership(dbUser, dbGroup, dbRole);
            this.persist(newMembership);
            return newMembership;
        }
        throw new UnsupportedOperationException("Only members of type User are supported by this implementation.");
    }

    public void removeMembership(IdentityType member, Group group, Role role) {
        GroupRole membership = this.getMembership(member, group, role);
        if (membership != null) {
            this.getEntityManager().remove((Object)membership);
            this.getEntityManager().flush();
        }
    }

    public GroupRole getMembership(IdentityType member, Group group, Role role) {
        Query query = null;
        DatabaseUser storedMember = null;
        DatabaseRole storedRole = null;
        DatabaseGroup storedGroup = null;
        if (member != null) {
            storedMember = this.getStoredUser(((User)member).getId());
        }
        if (role != null) {
            storedRole = this.getStoredRole(role.getName());
        }
        if (group != null) {
            storedGroup = this.getStoredGroup(group.getName());
        }
        String namedQuery = null;
        if (storedRole != null && storedGroup != null) {
            namedQuery = "MEMBERSHIP.LOAD_BY_KEY_ALL";
        } else {
            if (storedRole != null) {
                namedQuery = "MEMBERSHIP.LOAD_BY_KEY_MEMBER_ROLE";
            }
            if (storedGroup != null) {
                namedQuery = "MEMBERSHIP.LOAD_BY_KEY_MEMBER_GROUP";
            }
        }
        query = this.getEntityManager().createNamedQuery(namedQuery);
        query.setParameter("member", (Object)storedMember);
        if (storedRole != null) {
            query.setParameter("role", (Object)storedRole);
        }
        if (storedGroup != null) {
            query.setParameter("group", (Object)storedGroup);
        }
        GroupRole loadedMembership = null;
        try {
            loadedMembership = (GroupRole)query.getSingleResult();
        }
        catch (NoResultException nre) {
            // empty catch block
        }
        return loadedMembership;
    }

    public <T extends IdentityType> List<T> fetchQueryResults(IdentityQuery<T> identityQuery) {
        EntityManager entityManager = this.getEntityManager();
        if (this.isUserType(identityQuery.getIdentityType())) {
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseUser.class);
            Root user = criteriaQuery.from(DatabaseUser.class);
            user.alias("resultClass");
            criteriaQuery.distinct(true);
            ArrayList<Object> predicates = new ArrayList<Object>();
            Map parameters = identityQuery.getParameters();
            Set parametersEntrySet = parameters.entrySet();
            for (Map.Entry entry : parametersEntrySet) {
                Predicate conjunction;
                Subquery select;
                Root fromProject;
                Subquery subquery;
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] value = (Object[])entry.getValue();
                if (User.ID.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("id"), value[0]));
                }
                if (User.EMAIL.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("email"), value[0]));
                }
                if (User.FIRST_NAME.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("firstName"), value[0]));
                }
                if (User.LAST_NAME.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("lastName"), value[0]));
                }
                if (IdentityType.ENABLED.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("enabled"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("createdDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)user.get("expirationDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)user.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)user.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)user.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)user.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.HAS_GROUP_ROLE)) {
                    for (Object object : value) {
                        GroupRole groupRole = (GroupRole)object;
                        subquery = criteriaQuery.subquery(DatabaseMembership.class);
                        fromProject = subquery.from(DatabaseMembership.class);
                        select = subquery.select((Expression)fromProject.get("member"));
                        conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("member"), (Expression)user));
                        if (groupRole.getMember() != null) {
                            conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("member"), (Object)this.getStoredUser(((User)groupRole.getMember()).getId())));
                        }
                        if (groupRole.getRole() != null) {
                            conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("role"), (Object)this.getStoredRole(groupRole.getRole().getName())));
                        }
                        if (groupRole.getGroup() != null) {
                            conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("group"), (Object)this.getStoredGroup(groupRole.getGroup().getName())));
                        }
                        subquery.where((Expression)conjunction);
                        predicates.add(criteriaBuilder.in((Expression)user).value((Expression)subquery));
                    }
                }
                Join join = null;
                if (IdentityType.MEMBER_OF.equals(queryParameter) || IdentityType.HAS_ROLE.equals(queryParameter) || IdentityType.HAS_GROUP_ROLE.equals(queryParameter)) {
                    join = user.join("memberships");
                }
                if (IdentityType.HAS_ROLE.equals(queryParameter)) {
                    for (Object object : value) {
                        subquery = criteriaQuery.subquery(DatabaseMembership.class);
                        fromProject = subquery.from(DatabaseMembership.class);
                        select = subquery.select((Expression)fromProject.get("member"));
                        conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("member"), (Expression)user));
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("role"), (Object)this.getStoredRole(object.toString())));
                        subquery.where((Expression)conjunction);
                        predicates.add(criteriaBuilder.in((Expression)user).value((Expression)subquery));
                    }
                }
                if (IdentityType.MEMBER_OF.equals(queryParameter)) {
                    for (Object object : value) {
                        subquery = criteriaQuery.subquery(DatabaseMembership.class);
                        fromProject = subquery.from(DatabaseMembership.class);
                        select = subquery.select((Expression)fromProject.get("member"));
                        conjunction = criteriaBuilder.conjunction();
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("member"), (Expression)user));
                        conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("group"), (Object)this.getStoredGroup(object.toString())));
                        subquery.where((Expression)conjunction);
                        predicates.add(criteriaBuilder.in((Expression)user).value((Expression)subquery));
                    }
                }
                if (!IdentityType.AttributeParameter.class.isInstance(queryParameter)) continue;
                IdentityType.AttributeParameter attribute = (IdentityType.AttributeParameter)queryParameter;
                Subquery subquery2 = criteriaQuery.subquery(DatabaseUserAttribute.class);
                Root fromProject2 = subquery2.from(DatabaseUserAttribute.class);
                Subquery select2 = subquery2.select((Expression)fromProject2.get("user"));
                Predicate conjunction2 = criteriaBuilder.conjunction();
                conjunction2.getExpressions().add(criteriaBuilder.equal((Expression)fromProject2.get("name"), (Object)attribute.getName()));
                conjunction2.getExpressions().add(fromProject2.get("value").in(value));
                subquery2.where((Expression)conjunction2);
                subquery2.groupBy(new Expression[]{subquery2.getSelection()}).having((Expression)criteriaBuilder.equal(criteriaBuilder.count(subquery2.getSelection()), (Object)value.length));
                predicates.add(criteriaBuilder.in((Expression)user).value((Expression)select2));
            }
            criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
            TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
            return resultQuery.getResultList();
        }
        if (this.isGroupType(identityQuery.getIdentityType())) {
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseGroup.class);
            Root group = criteriaQuery.from(DatabaseGroup.class);
            group.alias("resultClass");
            criteriaQuery.distinct(true);
            ArrayList<Object> predicates = new ArrayList<Object>();
            Map parameters = identityQuery.getParameters();
            Set parametersEntrySet = parameters.entrySet();
            for (Map.Entry entry : parametersEntrySet) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] value = (Object[])entry.getValue();
                if (Group.NAME.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("name"), value[0]));
                }
                if (IdentityType.ENABLED.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("enabled"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("createdDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("expirationDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)group.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)group.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)group.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)group.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                if (Group.ID.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)group.get("id"), value[0]));
                }
                if (Group.PARENT.equals(queryParameter)) {
                    Join joinParentGroup = group.join("parentGroup");
                    predicates.add(criteriaBuilder.equal((Expression)joinParentGroup.get("id"), value[0]));
                }
                Join join = null;
                if (IdentityType.HAS_MEMBER.equals(queryParameter) || IdentityType.HAS_ROLE.equals(queryParameter)) {
                    join = group.join("memberships");
                }
                if (IdentityType.HAS_ROLE.equals(queryParameter)) {
                    Join joinRole = join.join("role");
                    predicates.add(criteriaBuilder.equal((Expression)joinRole.get("name"), value[0]));
                }
                if (IdentityType.HAS_MEMBER.equals(queryParameter)) {
                    Join joinGroup = join.join("member");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), value[0]));
                }
                if (!IdentityType.AttributeParameter.class.isInstance(queryParameter)) continue;
                IdentityType.AttributeParameter attribute = (IdentityType.AttributeParameter)queryParameter;
                Subquery subquery = criteriaQuery.subquery(DatabaseGroupAttribute.class);
                Root fromProject = subquery.from(DatabaseGroupAttribute.class);
                Subquery select = subquery.select((Expression)fromProject.get("group"));
                Predicate conjunction = criteriaBuilder.conjunction();
                conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("name"), (Object)attribute.getName()));
                conjunction.getExpressions().add(fromProject.get("value").in(value));
                subquery.where((Expression)conjunction);
                subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteriaBuilder.equal(criteriaBuilder.count(subquery.getSelection()), (Object)value.length));
                predicates.add(criteriaBuilder.in((Expression)group).value((Expression)select));
            }
            criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
            TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
            return resultQuery.getResultList();
        }
        if (this.isRoleType(identityQuery.getIdentityType())) {
            CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DatabaseRole.class);
            Root role = criteriaQuery.from(DatabaseRole.class);
            role.alias("resultClass");
            criteriaQuery.distinct(true);
            ArrayList<Object> predicates = new ArrayList<Object>();
            Map parameters = identityQuery.getParameters();
            Set parametersEntrySet = parameters.entrySet();
            for (Map.Entry entry : parametersEntrySet) {
                QueryParameter queryParameter = (QueryParameter)entry.getKey();
                Object[] value = (Object[])entry.getValue();
                if (Role.NAME.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("name"), value[0]));
                }
                if (IdentityType.ENABLED.equals(queryParameter)) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("enabled"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("createdDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_DATE)) {
                    predicates.add(criteriaBuilder.equal((Expression)role.get("expirationDate"), value[0]));
                }
                if (queryParameter.equals(IdentityType.CREATED_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)role.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.CREATED_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)role.get("createdDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_AFTER)) {
                    predicates.add(criteriaBuilder.greaterThan((Expression)role.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                if (queryParameter.equals(IdentityType.EXPIRY_BEFORE)) {
                    predicates.add(criteriaBuilder.lessThan((Expression)role.get("expirationDate"), (Comparable)((Date)value[0])));
                }
                Join join = null;
                if (Role.GROUP_ROLE_OF.equals(queryParameter) || Role.HAS_ROLE.equals(queryParameter)) {
                    join = role.join("memberships");
                }
                if (Role.GROUP_ROLE_OF.equals(queryParameter)) {
                    Join joinGroup = join.join("group");
                    predicates.add(criteriaBuilder.equal((Expression)joinGroup.get("id"), value[0]));
                }
                if (Role.HAS_ROLE.equals(queryParameter)) {
                    Join joinUser = join.join("member");
                    predicates.add(criteriaBuilder.equal((Expression)joinUser.get("id"), value[0]));
                }
                if (!IdentityType.AttributeParameter.class.isInstance(queryParameter)) continue;
                IdentityType.AttributeParameter attribute = (IdentityType.AttributeParameter)queryParameter;
                Subquery subquery = criteriaQuery.subquery(DatabaseRoleAttribute.class);
                Root fromProject = subquery.from(DatabaseRoleAttribute.class);
                Subquery select = subquery.select((Expression)fromProject.get("role"));
                Predicate conjunction = criteriaBuilder.conjunction();
                conjunction.getExpressions().add(criteriaBuilder.equal((Expression)fromProject.get("name"), (Object)attribute.getName()));
                conjunction.getExpressions().add(fromProject.get("value").in(value));
                subquery.where((Expression)conjunction);
                subquery.groupBy(new Expression[]{subquery.getSelection()}).having((Expression)criteriaBuilder.equal(criteriaBuilder.count(subquery.getSelection()), (Object)value.length));
                predicates.add(criteriaBuilder.in((Expression)role).value((Expression)select));
            }
            criteriaQuery.where(predicates.toArray(new Predicate[predicates.size()]));
            TypedQuery resultQuery = entityManager.createQuery(criteriaQuery);
            return resultQuery.getResultList();
        }
        return Collections.emptyList();
    }

    private void persist(Object entity) {
        this.getEntityManager().persist(entity);
        this.getEntityManager().flush();
    }

    private IdentityType findIdentityTypeByKey(String idFieldName, String idValue, String namedQueryName) {
        Query query = this.getEntityManager().createNamedQuery(namedQueryName);
        query.setParameter(idFieldName, (Object)idValue);
        IdentityType loadedUser = null;
        try {
            loadedUser = (IdentityType)query.getSingleResult();
        }
        catch (NoResultException nre) {
        }
        catch (NonUniqueResultException nure) {
            // empty catch block
        }
        return loadedUser;
    }

    public void setup(SimpleJPAIdentityStoreConfiguration config, IdentityStoreInvocationContext context) {
        this.config = config;
        this.context = context;
    }

    public SimpleJPAIdentityStoreConfiguration getConfig() {
        return this.config;
    }

    public IdentityStoreInvocationContext getContext() {
        return this.context;
    }

    public void update(IdentityType identityType) {
        if (this.isUserType(identityType.getClass())) {
            User updatedUser = (User)identityType;
            DatabaseUser storedUser = this.getStoredUser(updatedUser.getId());
            storedUser.setEmail(updatedUser.getEmail());
            storedUser.setFirstName(updatedUser.getFirstName());
            storedUser.setLastName(updatedUser.getLastName());
            storedUser.setKey(updatedUser.getKey());
            storedUser.setEnabled(updatedUser.isEnabled());
            storedUser.setExpirationDate(updatedUser.getExpirationDate());
            this.updateAttributes(identityType, storedUser);
            this.getEntityManager().merge((Object)storedUser);
            this.getEntityManager().flush();
        } else if (this.isRoleType(identityType.getClass())) {
            Role updatedRole = (Role)identityType;
            DatabaseRole storedRole = this.getStoredRole(updatedRole.getName());
            storedRole.setKey(updatedRole.getKey());
            storedRole.setEnabled(updatedRole.isEnabled());
            storedRole.setExpirationDate(updatedRole.getExpirationDate());
            this.updateAttributes(identityType, storedRole);
            this.getEntityManager().merge((Object)storedRole);
            this.getEntityManager().flush();
        } else if (this.isGroupType(identityType.getClass())) {
            Group updatedGroup = (Group)identityType;
            DatabaseGroup storedGroup = this.getStoredGroup(updatedGroup.getName());
            storedGroup.setKey(updatedGroup.getKey());
            storedGroup.setEnabled(updatedGroup.isEnabled());
            storedGroup.setExpirationDate(updatedGroup.getExpirationDate());
            this.updateAttributes(identityType, storedGroup);
            this.getEntityManager().merge((Object)storedGroup);
            this.getEntityManager().flush();
        }
    }

    public Agent getAgent(String id) {
        return this.getUser(id);
    }

    public Group getGroup(String name, Group parent) {
        if (name == null || parent == null) {
            return null;
        }
        Group group = this.getGroup(name);
        if (group.getParentGroup() == null || !group.getParentGroup().getName().equals(parent.getName())) {
            group = null;
        }
        return group;
    }

    public <T extends IdentityType> int countQueryResults(IdentityQuery<T> identityQuery) {
        return 0;
    }

    public void setAttribute(IdentityType identityType, Attribute<? extends Serializable> attribute) {
    }

    public <T extends Serializable> Attribute<T> getAttribute(IdentityType identityType, String attributeName) {
        return null;
    }

    public void removeAttribute(IdentityType identityType, String attributeName) {
    }

    protected EntityManager getEntityManager() {
        if (!this.getContext().isParameterSet(INVOCATION_CTX_ENTITY_MANAGER)) {
            throw new IllegalStateException("Error while trying to determine EntityManager - context parameter not set.");
        }
        return (EntityManager)this.getContext().getParameter(INVOCATION_CTX_ENTITY_MANAGER);
    }

    private void updateAttributes(IdentityType identityType, AbstractDatabaseIdentityType<?> identity) {
        EntityManager em = this.getEntityManager();
        this.removeAllAttributes(identity);
        if (identityType.getAttributes() != null && !identityType.getAttributes().isEmpty()) {
            ArrayList attributesToRetain = new ArrayList();
            for (Attribute userAttribute : identityType.getAttributes()) {
                identity.setAttribute((Attribute<Serializable>)userAttribute);
            }
        }
    }

    private void removeAttributes(AbstractDatabaseIdentityType<?> identity, List<String> attributesToRetain) {
        StringBuffer attributeNames = new StringBuffer();
        for (String string : attributesToRetain) {
            if (attributeNames.length() != 0) {
                attributeNames.append(",");
            }
            attributeNames.append("'").append(string).append("'");
        }
        List<?> attributes = identity.getOwnerAttributes();
        for (AbstractDatabaseAttribute attribute : new ArrayList(attributes)) {
            if (attributesToRetain.contains(attribute.getName())) continue;
            identity.removeAttribute(attribute.getName());
            this.getEntityManager().remove((Object)attribute);
            this.getEntityManager().flush();
        }
    }

    private void removeAllAttributes(AbstractDatabaseIdentityType<?> identity) {
        this.removeAttributes(identity, Collections.<String>emptyList());
    }
}

