/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.picketlink.annotations.PicketLink;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.jpa.internal.JPAIdentityStore;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;

public class EEJPAContextInitializer
implements ContextInitializer {
    @Inject
    @PicketLink
    Instance<EntityManager> entityManagerInstance;

    public void initContextForStore(IdentityContext context, IdentityStore<?> store) {
        if (store instanceof JPAIdentityStore) {
            if (this.entityManagerInstance.isUnsatisfied()) {
                throw new SecurityConfigurationException("To use JPAIdentityStore you must provide an EntityManager producer method qualified with @org.picketlink.annotations.PicketLink.");
            }
            if (!context.isParameterSet("CTX_ENTITY_MANAGER")) {
                context.setParameter("CTX_ENTITY_MANAGER", this.entityManagerInstance.get());
            }
        }
    }
}

