/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.cors;

import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Pattern;

public class CorsUtil {
    private static final Pattern VALID = Pattern.compile("^[\\x21-\\x7e&&[^]\\[}{()<>@,;:\\\\\"/?=]]+$");

    public static String[] parseMultipleHeaderValues(String headerValue) {
        if (headerValue == null) {
            return new String[0];
        }
        String trimmedHeaderValue = headerValue.trim();
        if (trimmedHeaderValue.isEmpty()) {
            return new String[0];
        }
        return trimmedHeaderValue.split("\\s*,\\s*|\\s+");
    }

    public static String formatCanonical(String name) {
        String nameTrimmed = name.trim();
        if (nameTrimmed.isEmpty()) {
            throw new IllegalArgumentException("The header field name must not be an empty string");
        }
        assert (VALID != null);
        if (!VALID.matcher(nameTrimmed).matches()) {
            throw new IllegalArgumentException("Invalid header field name syntax (see RFC 2616)");
        }
        String[] tokens = nameTrimmed.toLowerCase().split("-");
        String out = "";
        for (int i = 0; i < tokens.length; ++i) {
            char[] c = tokens[i].toCharArray();
            c[0] = Character.toUpperCase(c[0]);
            if (i >= 1) {
                out = out + "-";
            }
            out = out + new String(c);
        }
        return out;
    }

    public static String join(Collection<String> strings) {
        return CorsUtil.join(strings, ", ");
    }

    public static String join(Collection<String> strings, String separator) {
        Iterator<String> iter = strings.iterator();
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }
}

